<!-- received="Fri Nov  6 21:52:18 1998 EET" -->
<!-- sent="Fri, 6 Nov 1998 20:15:43 +0100 (CET)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@e-mind.com" -->
<!-- subject="lp fix against pre-2.1.127-7" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: lp fix against pre-2.1.127-7</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>lp fix against pre-2.1.127-7</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@e-mind.com"><i>andrea@e-mind.com</i></a>)<br>
<i>Fri, 6 Nov 1998 20:15:43 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#838">[ date ]</a><a href="index.html#838">[ thread ]</a><a href="subject.html#838">[ subject ]</a><a href="author.html#838">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0839.html">Meelis Roos: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Previous message:</b> <a href="0837.html">Alan Cox: "Re: Problem with SLIP in 2.1.126"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hpa, the stall you reported it' s due a missing schedule_timeout() ;-&gt;. I<br>
didn' t noticed that in the last days because I was under pressure...<br>
<p>
Here a preliminary patch that _only_ fix bugs (compared to 2.1.126), this<br>
is not intended to go into 2.1.127 (even if safe) because I would like to<br>
be sure that the trustirq thing really broke the printing somewhere before<br>
to cut it out. In the weekend I'll try to submit to Linus a patch that fix<br>
lp without cutting out the trustirq thing.<br>
<p>
Trusting the irq is the only way to give a sense to the irq printing<br>
here (and probably in many other places...).<br>
<p>
Index: linux/drivers/char/lp.c<br>
diff -u linux/drivers/char/lp.c:1.1.1.4 linux/drivers/char/lp.c:1.1.1.1.12.14<br>
--- linux/drivers/char/lp.c:1.1.1.4	Wed Nov  4 13:06:06 1998<br>
+++ linux/drivers/char/lp.c	Fri Nov  6 20:07:10 1998<br>
@@ -18,11 +18,7 @@<br>
  * 				by Riccardo Facchetti &lt;<a href="mailto:fizban@tin.it">fizban@tin.it</a>&gt;<br>
  * Redesigned interrupt handling for handle printers with buggy handshake<br>
  *				by Andrea Arcangeli, 11 May 1998<br>
- * Full efficient handling of printer with buggy irq handshake (now I have<br>
- * understood the meaning of the strange handshake). This is done sending new<br>
- * characters if the interrupt is just happened, even if the printer say to<br>
- * be still BUSY. This is needed at least with Epson Stylus Color.<br>
- * I also fixed the irq on the rising edge of the strobe problem.<br>
+ * Fixed the irq on the rising edge of the strobe problem.<br>
  *				Andrea Arcangeli, 15 Oct 1998<br>
  */<br>
 <br>
@@ -84,13 +80,12 @@<br>
  *<br>
  *	<a href="ftp://e-mind.com/pub/linux/pscan/">ftp://e-mind.com/pub/linux/pscan/</a><br>
  *<br>
+ *					11 May 98, Andrea Arcangeli<br>
+ *<br>
  * My printer scanner run on an Epson Stylus Color show that such printer<br>
  * generates the irq on the _rising_ edge of the STROBE. Now lp handle<br>
  * this case fine too.<br>
  *<br>
- * I also understood that on such printer we are just allowed to send<br>
- * new characters after the interrupt even if the BUSY line is still active.<br>
- *<br>
  *					15 Oct 1998, Andrea Arcangeli<br>
  */<br>
 <br>
@@ -124,25 +119,16 @@<br>
 #ifdef LP_STATS<br>
 			   0, 0, {0},<br>
 #endif<br>
-			   NULL, 0, 0, 0}<br>
+			   NULL, 0, 0, 0, 0}<br>
 };<br>
 <br>
-/*<br>
- * Test if printer is ready.<br>
- */<br>
-#define LP_READY(status) \<br>
+/* Test if printer is ready (and optionally has no error conditions) */<br>
+#define LP_READY(minor, status) \<br>
+  ((LP_F(minor) &amp; LP_CAREFUL) ? _LP_CAREFUL_READY(status) : ((status) &amp; LP_PBUSY))<br>
+#define _LP_CAREFUL_READY(status) \<br>
    ((status) &amp; (LP_PBUSY|LP_POUTPA|LP_PSELECD|LP_PERRORP)) == \<br>
       (LP_PBUSY|LP_PSELECD|LP_PERRORP)<br>
 <br>
-/*<br>
- * Test if the printer has error conditions.<br>
- */<br>
-#define LP_NO_ERROR(status) \<br>
-   ((status) &amp; (LP_POUTPA|LP_PSELECD|LP_PERRORP)) == \<br>
-      (LP_PSELECD|LP_PERRORP)<br>
-<br>
-#define LP_NO_ACKING(status) ((status) &amp; LP_PACK)<br>
-<br>
 #undef LP_DEBUG<br>
 #undef LP_READ_DEBUG<br>
 <br>
@@ -189,7 +175,7 @@<br>
 		schedule_timeout(timeout);<br>
 		lp_parport_claim(minor);<br>
 	} else<br>
-		schedule();<br>
+		schedule_timeout(timeout);<br>
 }<br>
 <br>
 static int lp_reset(int minor)<br>
@@ -221,27 +207,9 @@<br>
 <br>
 	for (;;)<br>
 	{<br>
-		unsigned char status;<br>
 		lp_yield(minor);<br>
-<br>
-		status = r_str(minor);<br>
-		/*<br>
-		 * On Epson Stylus Color we must continue even if LP_READY()<br>
-		 * is false to be efficient. This way is backwards<br>
-		 * compatible with old not-buggy printers. -arca<br>
-		 */<br>
-		if (LP_NO_ERROR(status) &amp;&amp;<br>
-		    ((lp_table[minor].irq_detected &amp;&amp; LP_NO_ACKING(status)) ||<br>
-		     LP_READY(status)))<br>
+		if (LP_READY(minor, r_str(minor)))<br>
 			break;<br>
-		/*<br>
-		 * To have a chance to sleep on the interrupt we should break<br>
-		 * the polling loop ASAP. Unfortunately there seems to be<br>
-		 * some hardware that underperform so we leave this<br>
-		 * configurable at runtime. So when printing with irqs<br>
-		 * `tunelp /dev/lp0 -c 1' is a must to take the full<br>
-		 * advantage of the irq. -arca<br>
-		 */<br>
 		if (++count == LP_CHAR(minor))<br>
 			return 0;<br>
 	}<br>
@@ -253,19 +221,6 @@<br>
 	stats-&gt;chars++;<br>
 #endif<br>
 <br>
-	/*<br>
-	 * Epson Stylus Color generate the IRQ on the rising edge of<br>
-	 * strobe so clean the irq's information before playing with<br>
-	 * the strobe. -arca<br>
-	 */<br>
-	lp_table[minor].irq_detected = 0;<br>
-	lp_table[minor].irq_missed = 0;<br>
-	/*<br>
-	 * Be sure that the CPU doesn' t reorder instruction. I am not sure<br>
-	 * if it' s needed also before an outb(). If not tell me ;-). -arca<br>
-	 */<br>
-	mb();<br>
-<br>
 	/* must wait before taking strobe high, and after taking strobe<br>
 	   low, according spec.  Some printers need it, others don't. */<br>
 	lp_wait(minor);<br>
@@ -277,11 +232,29 @@<br>
 		lp_wait(minor);<br>
 		w_ctr(minor, LP_PSELECP | LP_PINITP);<br>
 	} else {<br>
+		/*<br>
+		 * Epson Stylus Color generate the IRQ on the rising edge of<br>
+		 * strobe so clean the irq's information before playing with<br>
+		 * the strobe. -arca<br>
+		 */<br>
+		lp_table[minor].irq_detected = 0;<br>
+		lp_table[minor].irq_missed = 0;<br>
+		/*<br>
+		 * Be sure that the CPU doesn' t reorder instructions.<br>
+		 * I am not sure if it' s needed also before an outb().<br>
+		 * If not tell me ;-). -arca<br>
+		 */<br>
+		mb();<br>
 		w_ctr(minor, LP_PSELECP | LP_PINITP | LP_PSTROBE | LP_PINTEN);<br>
 		lp_wait(minor);<br>
 		w_ctr(minor, LP_PSELECP | LP_PINITP | LP_PINTEN);<br>
 	}<br>
 <br>
+	/*<br>
+	 * Give to the printer a chance to put BUSY low.<br>
+	 */<br>
+	lp_wait(minor);<br>
+<br>
 #ifdef LP_STATS<br>
 	/* update waittime statistics */<br>
 	if (count &gt; stats-&gt;maxwait) {<br>
@@ -371,7 +344,6 @@<br>
 	lp_table[minor].last_error = 0;<br>
 	lp_table[minor].irq_detected = 0;<br>
 	lp_table[minor].irq_missed = 1;<br>
-	LP_POLLED(minor) = lp_table[minor].dev-&gt;port-&gt;irq == PARPORT_IRQ_NONE;<br>
 <br>
 	if (LP_POLLED(minor))<br>
 		w_ctr(minor, LP_PSELECP | LP_PINITP);<br>
@@ -480,6 +452,12 @@<br>
  	 */<br>
  	lp_parport_claim (minor);<br>
 <br>
+	/*<br>
+	 * We can set the polled flag here since once we have parport claimed<br>
+	 * the parport irq remains locked. -arca<br>
+	 */<br>
+	LP_POLLED(minor) = lp_table[minor].dev-&gt;port-&gt;irq == PARPORT_IRQ_NONE;<br>
+<br>
 	retv = lp_write_buf(minor, buf, count);<br>
 <br>
  	lp_parport_release (minor);<br>
@@ -694,6 +672,12 @@<br>
 			else<br>
 				LP_F(minor) &amp;= ~LP_ABORTOPEN;<br>
 			break;<br>
+		case LPCAREFUL:<br>
+			if (arg)<br>
+				LP_F(minor) |= LP_CAREFUL;<br>
+			else<br>
+				LP_F(minor) &amp;= ~LP_CAREFUL;<br>
+			break;<br>
 		case LPWAIT:<br>
 			LP_WAIT(minor) = arg;<br>
 			break;<br>
@@ -736,7 +720,6 @@<br>
 	}<br>
 	return retval;<br>
 }<br>
-<br>
 <br>
 static struct file_operations lp_fops = {<br>
 	lp_lseek,<br>
Index: linux/include/linux/lp.h<br>
diff -u linux/include/linux/lp.h:1.1.1.4 linux/include/linux/lp.h:1.1.1.1.12.6<br>
--- linux/include/linux/lp.h:1.1.1.4	Wed Nov  4 13:09:24 1998<br>
+++ linux/include/linux/lp.h	Fri Nov  6 02:02:54 1998<br>
@@ -25,9 +25,7 @@<br>
 #define LP_NOPA  0x0010<br>
 #define LP_ERR   0x0020<br>
 #define LP_ABORT 0x0040<br>
-#if 0<br>
 #define LP_CAREFUL 0x0080<br>
-#endif<br>
 #define LP_ABORTOPEN 0x0100<br>
 <br>
 /* timeout for each character.  This is relative to bus cycles -- it<br>
@@ -67,11 +65,9 @@<br>
 			    or 0 for polling (no IRQ) */<br>
 #define LPGETIRQ 0x0606  /* get the current IRQ number */<br>
 #define LPWAIT   0x0608  /* corresponds to LP_INIT_WAIT */<br>
-#ifdef LP_NEED_CAREFUL<br>
 #define LPCAREFUL   0x0609  /* call with TRUE arg to require out-of-paper, off-<br>
 			    line, and error indicators good on all writes,<br>
 			    FALSE to ignore them.  Default is ignore. */<br>
-#endif<br>
 #define LPABORTOPEN 0x060a  /* call with TRUE arg to abort open() on error,<br>
 			    FALSE to ignore error.  Default is ignore.  */<br>
 #define LPGETSTATUS 0x060b  /* return LP_S(minor) */<br>
<p>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0839.html">Meelis Roos: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Previous message:</b> <a href="0837.html">Alan Cox: "Re: Problem with SLIP in 2.1.126"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
