<!-- received="Fri Nov  6 20:31:11 1998 EET" -->
<!-- sent="Fri, 06 Nov 1998 19:21:37 +0100" -->
<!-- name="Brian Schau" -->
<!-- email="bsc@fleggaard.dk" -->
<!-- subject="[PATCH] Patch to Memory Subsystem ...  (Needed?)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] Patch to Memory Subsystem ...  (Needed?)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Patch to Memory Subsystem ...  (Needed?)</h1>
<b>Brian Schau</b> (<a href="mailto:bsc@fleggaard.dk"><i>bsc@fleggaard.dk</i></a>)<br>
<i>Fri, 06 Nov 1998 19:21:37 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#824">[ date ]</a><a href="index.html#824">[ thread ]</a><a href="subject.html#824">[ subject ]</a><a href="author.html#824">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0825.html">Henning P. Schmiedehausen: "Re: Comments on Microsoft Open Source document"</a>
<li> <b>Previous message:</b> <a href="0823.html">Lenart Gabor: "Re: GURU needed: Linux vs. FreeBSD"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0836.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0836.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0842.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0845.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0846.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0852.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0853.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0873.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0887.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0888.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0924.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0925.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0938.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0963.html">Stefan Monnier: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0964.html">Stefan Monnier: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
--------------4951A3669A1E87ABE7DE010E<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Transfer-Encoding: 7bit<br>
<p>
Hello,<br>
<p>
<p>
(This is long ...)<br>
<p>
Find attached three files - one a patch to the memory-subsystem, one a<br>
shell-script and one a simple c-program.<br>
<p>
Motivation.   Today one of my servers had to be 'hard'-rebooted due to<br>
lack of memory.  One user-space program ate all available memory -<br>
resulting in a lot of 'Unable to load interpreter' and the like.   Even<br>
root couldn't get a login at the console.<br>
<p>
Solution.   Some way to specify an amount of free pages which is only<br>
accessible by root-processes so that root can get a login and kill the<br>
offending memory-eater ...<br>
<p>
Description.   The attached patch patches against a clean 2.1.126.  It<br>
touches the following files:<br>
<p>
	mm/mmap.c<br>
	include/linux/sysctl.h<br>
	kernel/sysctl.c<br>
<p>
It adds an entry to /proc/sys/vm/ called rootpages.  Reading 'rootpages'<br>
returns the no. of pages reserved exclusively for root (defaults to<br>
0).   Writing to 'rootpages' sets the no. of pages to reserve<br>
exclusively for root.   A shell script ('rootpages') is attached for<br>
your convenience:<br>
<p>
cryo:/home/bsc # /home/bsc/rootpages<br>
Rootpages fixed at 0 pages.<br>
cryo:/home/bsc # /home/bsc/rootpages 1024 <br>
Setting new rootpages value to 1024 pages.<br>
<p>
Test.   To test, compile the third file 'eat.c':<br>
<p>
	gcc -Wall -o eat eat.c<br>
<p>
... it compiles without warnings/errors on my 2.1.117.  On tty1, run:<br>
<p>
	free -mtos 1<br>
<p>
On tty2, run 'eat' as a normal user and with /proc/sys/vm/rootpages set<br>
to 0.  'eat' should eat all available memory (it does on my machine). <br>
Watch 'free' on tty1 report loses of memory.<br>
Press ctrl-c on tty2 thus aborting 'eat'.  The amount of free memory<br>
should rise.<br>
Now set the no. of freepages to say, 1024 (4 Mb on Intel-platforms) and<br>
run 'eat' again as normal user.  Watch the amount of free memory.  It<br>
should drop down to ~ 4Mb - not below!   You're then able to login as<br>
root and do your stuff ...  ;o)<br>
(Running 'eat' as root eats all available memory - so take care!)<br>
<p>
Notes.  The patch has been developed on a 2.1.117 kernel.  It runs with<br>
no errors on a 2.1.117.  It patches cleanly against a 2.1.126 kernel -<br>
but I haven't tried it on a 2.1.126 kernel (due to compilation errors in<br>
the sound sub-system).  But with my un-trained eye (and some help from<br>
'diff'), it seems like there has been no fundamental changes to the<br>
files touched between .117 and .126 ...<br>
There is no check to see if the number of rootpages exceed some<br>
??strange?? value (like 10000000).  So, 'roots' beware!<br>
<p>
Conclusion.   I don't know if this patch is needed in the kernel at all<br>
(haven't checked to see if somebody have done this already) - but it was<br>
a simple 1 hour hack which, if the facility existed in the kernel I use<br>
at work (2.1.107 - soon to be upgraded ;o), would have saved me from a<br>
hard-reboot, a lot of fsck'ing and loosing lots of precious time better<br>
spent at work (14 people total ...).<br>
I would like, though, that somebody validates the patch - is it safe?<br>
<p>
<p>
Kind regards,<br>
<p>
<p>
Brisse<br>
--------------4951A3669A1E87ABE7DE010E<br>
Content-Type: text/plain; charset=us-ascii; name="eat.c"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline; filename="eat.c"<br>
<p>
#include &lt;stdlib.h&gt;<br>
#include &lt;stdio.h&gt;<br>
<p>
<p>
#define CHUNKSIZE 10240<br>
#define STEP 1024<br>
<p>
int<br>
main(int argc, char* argv[])<br>
{<br>
	char* ptr=NULL;<br>
	int cnt=0;<br>
	int c;<br>
<p>
	<br>
	while (1) {<br>
		cnt++;<br>
		if ((ptr=(char*)calloc(CHUNKSIZE, 1))) {<br>
			for (c=0; c&lt;CHUNKSIZE; c+=STEP) *(ptr+c)=1;<br>
			printf("(%06i) Ate %i bytes ...\n", cnt, CHUNKSIZE);<br>
		} else printf("(%06i) Couldn't eat %i bytes ...\n", cnt, CHUNKSIZE);<br>
	}<br>
	exit(0);<br>
}<br>
<p>
--------------4951A3669A1E87ABE7DE010E<br>
Content-Type: text/plain; charset=us-ascii; name="rootpages"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline; filename="rootpages"<br>
<p>
#!/bin/sh<br>
ROOTPAGES=/proc/sys/vm/rootpages<br>
if test "$(whoami)" = "root"; then<br>
	if test -f $ROOTPAGES; then<br>
		if test $# -gt 0; then<br>
			echo "Setting new rootpages value to $1 pages."<br>
			echo $1 &gt; $ROOTPAGES<br>
		else<br>
			rp="$(cat $ROOTPAGES)"<br>
			echo "Rootpages fixed at $rp pages."<br>
		fi<br>
	else<br>
		echo "Can't find $ROOTPAGES ..."<br>
	fi<br>
else<br>
	echo "You must be root to use this program!"<br>
fi<br>
exit 0<br>
<p>
--------------4951A3669A1E87ABE7DE010E<br>
Content-Type: text/plain; charset=us-ascii; name="mm.diff"<br>
Content-Transfer-Encoding: 7bit<br>
Content-Disposition: inline; filename="mm.diff"<br>
<p>
diff -ur linux-2.1.117/include/linux/sysctl.h linux/include/linux/sysctl.h<br>
--- linux-2.1.117/include/linux/sysctl.h	Fri Nov  6 16:45:44 1998<br>
+++ linux/include/linux/sysctl.h	Fri Nov  6 16:50:59 1998<br>
@@ -99,7 +99,8 @@<br>
 	VM_BUFFERMEM,		/* struct: Set buffer memory thresholds */<br>
 	VM_PAGECACHE,		/* struct: Set cache memory thresholds */<br>
 	VM_PAGERDAEMON,		/* struct: Control kswapd behaviour */<br>
-/*9*/	VM_PGT_CACHE		/* struct: Set page table cache parameters */<br>
+/*9*/	VM_PGT_CACHE,		/* struct: Set page table cache parameters */<br>
+	VM_ROOTPAGES		/* int: No. of free pages reserved for UID 0 */<br>
 };<br>
 <br>
 <br>
diff -ur linux-2.1.117/kernel/sysctl.c linux/kernel/sysctl.c<br>
--- linux-2.1.117/kernel/sysctl.c	Fri Nov  6 16:42:17 1998<br>
+++ linux/kernel/sysctl.c	Fri Nov  6 16:48:32 1998<br>
@@ -42,6 +42,7 @@<br>
 extern int bdf_prm[], bdflush_min[], bdflush_max[];<br>
 extern char binfmt_java_interpreter[], binfmt_java_appletviewer[];<br>
 extern int sysctl_overcommit_memory;<br>
+extern int rootpages;<br>
 #ifdef CONFIG_KMOD<br>
 extern char modprobe_path[];<br>
 #endif<br>
@@ -211,6 +212,8 @@<br>
 	 &amp;pager_daemon, sizeof(pager_daemon_t), 0644, NULL, &amp;proc_dointvec},<br>
 	{VM_PGT_CACHE, "pagetable_cache", <br>
 	 &amp;pgt_cache_water, 2*sizeof(int), 0600, NULL, &amp;proc_dointvec},<br>
+	{VM_ROOTPAGES, "rootpages",<br>
+	 &amp;rootpages, sizeof(int), 0600, NULL, &amp;proc_dointvec},<br>
 	{0}<br>
 };<br>
 <br>
diff -ur linux-2.1.117/mm/mmap.c linux/mm/mmap.c<br>
--- linux-2.1.117/mm/mmap.c	Fri Nov  6 16:40:49 1998<br>
+++ linux/mm/mmap.c	Fri Nov  6 17:21:26 1998<br>
@@ -47,6 +47,7 @@<br>
 kmem_cache_t *vm_area_cachep;<br>
 <br>
 int sysctl_overcommit_memory;<br>
+int rootpages=0;<br>
 <br>
 /* Check that a process has enough memory to allocate a<br>
  * new virtual mapping.<br>
@@ -58,7 +59,7 @@<br>
 	 * fool it, but this should catch most mistakes.<br>
 	 */<br>
 	long free;<br>
-	<br>
+<br>
         /* Sometimes we want to use more memory than we have. */<br>
 	if (sysctl_overcommit_memory)<br>
 	    return 1;<br>
@@ -68,6 +69,7 @@<br>
 	free &gt;&gt;= 1;<br>
 	free += nr_free_pages;<br>
 	free += nr_swap_pages;<br>
+	if (current-&gt;uid) free -= rootpages;<br>
 	free -= num_physpages &gt;&gt; 4;<br>
 	return free &gt; pages;<br>
 }<br>
<p>
--------------4951A3669A1E87ABE7DE010E--<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0825.html">Henning P. Schmiedehausen: "Re: Comments on Microsoft Open Source document"</a>
<li> <b>Previous message:</b> <a href="0823.html">Lenart Gabor: "Re: GURU needed: Linux vs. FreeBSD"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0836.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0836.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0842.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0845.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0846.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0852.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0853.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0873.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0887.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0888.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0924.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0925.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0938.html">Brian Schau: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0963.html">Stefan Monnier: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<li> <b>Reply:</b> <a href="0964.html">Stefan Monnier: "Re: [PATCH] Patch to Memory Subsystem ...  (Needed?)"</a>
<!-- reply="end" -->
</ul>
</font></body>
