<!-- received="Fri Nov  6 05:36:44 1998 EET" -->
<!-- sent="Thu, 5 Nov 1998 18:04:58 -0800" -->
<!-- name="Ken Pizzini" -->
<!-- email="ken@halcyon.com" -->
<!-- subject="Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)" -->
<!-- id="19981106020513Z276516-223+14@pulsar.halcyon.com" -->
<!-- inreplyto="Pine.LNX.4.05.9811050939180.25952-100000@ns.snowman.net" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)</h1>
<b>Ken Pizzini</b> (<a href="mailto:ken@halcyon.com"><i>ken@halcyon.com</i></a>)<br>
<i>Thu, 5 Nov 1998 18:04:58 -0800</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#745">[ date ]</a><a href="index.html#745">[ thread ]</a><a href="subject.html#745">[ subject ]</a><a href="author.html#745">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0746.html">Paul Mackerras: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Previous message:</b> <a href="0744.html">Stephen Donnelly: "Packet timestamp errors (2.1.126)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The sonycd535.c driver uses a "periodically retry until timeout"<br>
logic to poll the device for status; the existing logic is not<br>
jiffies-wrap safe.  Attached is a patch to correct this; it is<br>
incremental to the one posted by Stephen Frost &lt;<a href="mailto:sfrost@ns.snowman.net">sfrost@ns.snowman.net</a>&gt;<br>
earlier today.<br>
<p>
		--Ken Pizzini<br>
<p>
--- linux-2.1.127-pre7+sfrost/drivers/cdrom/sonycd535.c	Thu Nov  5 07:58:47 1998<br>
+++ linux/drivers/cdrom/sonycd535.c	Thu Nov  5 17:55:15 1998<br>
@@ -62,26 +62,24 @@<br>
  * This interface is (unfortunately) a polled interface.  This is<br>
  * because most Sony interfaces are set up with DMA and interrupts<br>
  * disables.  Some (like mine) do not even have the capability to<br>
- * handle interrupts or DMA.  For this reason you will see a lot of<br>
+ * handle interrupts or DMA.  For this reason you will see a bit of<br>
  * the following:<br>
  *<br>
- *   retry_count = jiffies+ SONY_JIFFIES_TIMEOUT;<br>
- *   while ((retry_count &gt; jiffies) &amp;&amp; (! &lt;some condition to wait for))<br>
+ *   snap = jiffies;<br>
+ *   while (jiffies-snap &lt; SONY_JIFFIES_TIMEOUT)<br>
  *   {<br>
- *      while (handle_sony_cd_attention())<br>
- *         ;<br>
- *<br>
+ *		if (some_condition())<br>
+ *         break;<br>
  *      sony_sleep();<br>
  *   }<br>
- *   if (the condition not met)<br>
+ *   if (some_condition not met)<br>
  *   {<br>
- *      return an error;<br>
+ *      return an_error;<br>
  *   }<br>
  *<br>
  * This ugly hack waits for something to happen, sleeping a little<br>
- * between every try.  it also handles attentions, which are<br>
- * asynchronous events from the drive informing the driver that a disk<br>
- * has been inserted, removed, etc.<br>
+ * between every try.  (The conditional is written so that jiffies<br>
+ * wrap-around is handled properly.)<br>
  *<br>
  * One thing about these drives: They talk in MSF (Minute Second Frame) format.<br>
  * There are 75 frames a second, 60 seconds a minute, and up to 75 minutes on a<br>
@@ -327,9 +325,7 @@<br>
 <br>
 <br>
 /*<br>
- * Wait a little while (used for polling the drive).  If in initialization,<br>
- * setting a timeout doesn't work, so just loop for a while.  (We trust<br>
- * that the sony_sleep() call is protected by a test for proper jiffies count.)<br>
+ * Wait a little while.<br>
  */<br>
 static inline void<br>
 sony_sleep(void)<br>
@@ -369,12 +365,13 @@<br>
 static int<br>
 read_result_reg(Byte *data_ptr)<br>
 {<br>
-	int retry_count;<br>
+	unsigned long snap;<br>
 	int read_status;<br>
 <br>
-	retry_count = jiffies + SONY_JIFFIES_TIMEOUT;<br>
-	while (jiffies &lt; retry_count) {<br>
-		if (((read_status = inb(read_status_reg)) &amp; SONY535_RESULT_NOT_READY_BIT) == 0) {<br>
+	snap = jiffies;<br>
+	while (jiffies-snap &lt; SONY_JIFFIES_TIMEOUT) {<br>
+		read_status = inb(read_status_reg);<br>
+		if ((read_status &amp; SONY535_RESULT_NOT_READY_BIT) == 0) {<br>
 #if DEBUG &gt; 1<br>
 			printk(CDU535_MESSAGE_NAME<br>
 					": read_result_reg(): readStatReg = 0x%x\n", read_status);<br>
@@ -598,7 +595,7 @@<br>
 	Byte cmd_buff[7];<br>
 	int  i;<br>
 	int  read_status;<br>
-	int  retry_count;<br>
+	unsigned long snap;<br>
 	Byte *data_buff;<br>
 	int  sector_count = 0;<br>
 <br>
@@ -617,8 +614,9 @@<br>
 	/* read back the data one block at a time */<br>
 	while (0 &lt; n_blocks--) {<br>
 		/* wait for data to be ready */<br>
-		retry_count = jiffies + SONY_JIFFIES_TIMEOUT;<br>
-		while (jiffies &lt; retry_count) {<br>
+		int data_valid = 0;<br>
+		snap = jiffies;<br>
+		while (jiffies-snap &lt; SONY_JIFFIES_TIMEOUT) {<br>
 			read_status = inb(read_status_reg);<br>
 			if ((read_status &amp; SONY535_RESULT_NOT_READY_BIT) == 0) {<br>
 				read_exec_status(status);<br>
@@ -629,11 +627,12 @@<br>
 				data_buff = buff[sector_count++];<br>
 				for (i = 0; i &lt; block_size; i++)<br>
 					*data_buff++ = inb(data_reg);	/* unrolling this loop does not seem to help */<br>
+				data_valid = 1;<br>
 				break;			/* exit the timeout loop */<br>
 			}<br>
 			sony_sleep();		/* data not ready, sleep a while */<br>
 		}<br>
-		if (retry_count &lt;= jiffies)<br>
+		if (!data_valid)<br>
 			return TIME_OUT;	/* if we reach this stage */<br>
 	}<br>
 <br>
@@ -892,7 +891,7 @@<br>
 						if (readStatus == BAD_STATUS) {<br>
 							/* Sleep for a while, then retry */<br>
 							current-&gt;state = TASK_INTERRUPTIBLE;<br>
-							schedule_timeout(RETRY_FOR_BAD_STATUS);<br>
+							schedule_timeout(RETRY_FOR_BAD_STATUS*HZ/10);<br>
 						}<br>
 #if DEBUG &gt; 0<br>
 						printk(CDU535_MESSAGE_NAME<br>
@@ -1491,7 +1490,8 @@<br>
 	Byte cmd_buff[3];<br>
 	Byte ret_buff[2];<br>
 	Byte status[2];<br>
-	int  retry_count;<br>
+	unsigned long snap;<br>
+	int  got_result = 0;<br>
 	int  tmp_irq;<br>
 	int  i;<br>
 <br>
@@ -1523,21 +1523,22 @@<br>
 	}<br>
 	/* look for the CD-ROM, follows the procedure in the DOS driver */<br>
 	inb(select_unit_reg);<br>
-	retry_count = jiffies + 2 * HZ;<br>
-	while (jiffies &lt; retry_count)<br>
-		sony_sleep();			/* wait for 40 18 Hz ticks (from DOS driver) */<br>
+	/* wait for 40 18 Hz ticks (reverse-engineered from DOS driver) */<br>
+	schedule_timeout((HZ+17)*40/18);<br>
 	inb(result_reg);<br>
 <br>
 	outb(0, read_status_reg);	/* does a reset? */<br>
-	retry_count = jiffies + SONY_JIFFIES_TIMEOUT;<br>
-	while (jiffies &lt; retry_count) {<br>
+	snap = jiffies;<br>
+	while (jiffies-snap &lt; SONY_JIFFIES_TIMEOUT) {<br>
 		select_unit(0);<br>
-		if (inb(result_reg) != 0xff)<br>
+		if (inb(result_reg) != 0xff) {<br>
+			got_result = 1;<br>
 			break;<br>
+		}<br>
 		sony_sleep();<br>
 	}<br>
 <br>
-	if ((jiffies &lt; retry_count) &amp;&amp; (check_drive_status() != TIME_OUT)) {<br>
+	if (got_result &amp;&amp; (check_drive_status() != TIME_OUT)) {<br>
 		/* CD-ROM drive responded --  get the drive configuration */<br>
 		cmd_buff[0] = SONY535_INQUIRY;<br>
 		if (do_sony_cmd(cmd_buff, 1, status,<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0746.html">Paul Mackerras: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Previous message:</b> <a href="0744.html">Stephen Donnelly: "Packet timestamp errors (2.1.126)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
