<!-- received="Fri Nov  6 03:03:22 1998 EET" -->
<!-- sent="Wed, 4 Nov 1998 23:34:48 +0100" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@bug.ucw.cz" -->
<!-- subject="Re: for comment: multi-keyboard patch" -->
<!-- id="" -->
<!-- inreplyto="199811040352.OAA06191@cargo.anu.edu.au" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: for comment: multi-keyboard patch</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: for comment: multi-keyboard patch</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@bug.ucw.cz"><i>pavel@bug.ucw.cz</i></a>)<br>
<i>Wed, 4 Nov 1998 23:34:48 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#715">[ date ]</a><a href="index.html#715">[ thread ]</a><a href="subject.html#715">[ subject ]</a><a href="author.html#715">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0716.html">Erik Arjan Hendriks: "Severe IDE BM-DMA problems."</a>
<li> <b>Previous message:</b> <a href="0714.html">Alex Belits: "Re: Comments on Microsoft Open Source document"</a>
<li> <b>In reply to:</b> <a href="0389.html">Paul Mackerras: "for comment: multi-keyboard patch"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0746.html">Paul Mackerras: "Re: for comment: multi-keyboard patch"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
<p>
<i>&gt; At present input from all keyboards goes to the current foreground</i><br>
<i>&gt; VC.  Ultimately it would be nice to be able to bind a keyboard, screen</i><br>
<i>&gt; and mouse together into a "console" which would have its own set of</i><br>
<i>&gt; VCs.</i><br>
<p>
It would be very nice, but as of now, you are not able to do anything<br>
like that with mouse, because mice are completely userspace. (Which is<br>
broken, because two programs on different vc's can not share mouse too<br>
well - there will be races with console switching there).<br>
<p>
Anyway, I've merged this patch with my work (key for console blanking,<br>
possibility to plug PS/2 keyboard into mouse port and hook for<br>
keylink). Incremental diff is attached, please take a look. (Any<br>
chance of merging?)<br>
<p>
								Pavel<br>
<p>
--- ./pc_keyb.c	Wed Nov  4 23:31:49 1998<br>
+++ /usr/src/multikey.linux/drivers/char/pc_keyb.c	Wed Nov  4 23:10:41 1998<br>
@@ -12,6 +12,10 @@<br>
  *<br>
  */<br>
 <br>
+/* Uncomment this if you have keyboard in ps/2 port, not mouse */<br>
+<br>
+#define KEYBOARD_IN_PSAUX<br>
+<br>
 #include &lt;linux/config.h&gt;<br>
 <br>
 #include &lt;asm/spinlock.h&gt;<br>
@@ -446,6 +450,52 @@<br>
 	    return 0200;<br>
 }<br>
 <br>
+#ifdef KEYBOARD_IN_PSAUX<br>
+static void *psaux_id;<br>
+<br>
+static char strange_xlat[ 256 ] = {<br>
+/*         0    1    2    3    4    5    6    7    8    9    a    b    c    d    e    f */<br>
+/* 0 */ 0x00,0x43,0x00,0x3f,0x3d,0x3b,0x3c,0x58,0x00,0x44,0x42,0x40,0x3e,0x0f,0x29,0x00,<br>
+/* 1 */ 0x00,  56,0x2a,0x00,  29,0x10,0x02,0x00,0x00,0x00,0x2c,0x1f,0x1e,0x11,0x03,0x00,<br>
+/* 2 */ 0x00,0x2e,0x2d,0x20,0x12,0x05,0x04,0x00,0x00,  57,0x2f,0x21,0x14,0x13,0x06,0x00,<br>
+/* 3 */ 0x00,0x31,0x30,0x23,0x22,0x15,0x07,0x00,0x00,0x00,0x32,0x24,0x16,0x08,0x09,0x00,<br>
+/* 4 */ 0x00,0x33,0x25,0x17,0x18,0x0b,0x0a,0x00,0x00,0x34,0x35,0x26,0x27,0x19,0x0c,0x00,<br>
+/* 5 */ 0x00,0x00,0x28,0x00,0x1a,0x0d,0x00,0x00,0x3a,0x36,0x1c,0x1b,0x00,0x2b,0x00,0x00,<br>
+/* 6 */ 0x00,0x00,0x00,0x00,0x00,0x00,  14,0x00,0x00,0x4f,0x00,0x4b,0x47,0x00,0x00,0x00,<br>
+/* 7 */ 0x52,0x53,0x50,0x00,0x4d,0x48,0x01,0x00,0x57,0x00,0x51,0x00,0x37,0x49,0x46,0x00,<br>
+/* 8 */ 0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,<br>
+/* 9 */ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,<br>
+/* a */ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,<br>
+/* b */ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,<br>
+/* c */ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,<br>
+/* d */ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,<br>
+/* e */ 0xe0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,<br>
+/* f */ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 <br>
+};<br>
+<br>
+static void handle_strangecode(int c)<br>
+{<br>
+	static int or = 0, i;<br>
+<br>
+	switch (c) {<br>
+	case 0xf0:<br>
+		or = 0x80;<br>
+		return;<br>
+	}<br>
+	<br>
+	i = strange_xlat[c];<br>
+	if (!i)<br>
+		printk( "Unknown strangecode %x\n", c );<br>
+#if 0<br>
+	else<br>
+		printk( "Known strangecode %x = %x\n", c, i );<br>
+#endif<br>
+	kbd_handle_scancode( psaux_id, i|or );<br>
+	or = 0;<br>
+}<br>
+#endif<br>
+<br>
+<br>
 static void keyboard_interrupt(int irq, void *dev_id, struct pt_regs *regs)<br>
 {<br>
 	unsigned long flags;<br>
@@ -467,6 +517,9 @@<br>
 			if (aux_count) {<br>
 				int head = queue-&gt;head;<br>
 				queue-&gt;buf[head] = scancode;<br>
+#ifdef KEYBOARD_IN_PSAUX<br>
+				handle_strangecode (scancode);<br>
+#else<br>
 				add_mouse_randomness(scancode);<br>
 				head = (head + 1) &amp; (AUX_BUF_SIZE-1);<br>
 				if (head != queue-&gt;tail) {<br>
@@ -475,6 +528,7 @@<br>
 						kill_fasync(queue-&gt;fasync, SIGIO);<br>
 					wake_up_interruptible(&amp;queue-&gt;proc_list);<br>
 				}<br>
+#endif<br>
 			}<br>
 #endif<br>
 		} else {<br>
@@ -819,9 +873,9 @@<br>
 	}<br>
 	queue-&gt;head = queue-&gt;tail = 0;		/* Flush input queue */<br>
 #ifdef CONFIG_MCA<br>
-	if (request_irq(AUX_IRQ, keyboard_interrupt, MCA_bus ? SA_SHIRQ : 0, "PS/2 Mouse", inode)) {<br>
+	if (request_irq(AUX_IRQ, keyboard_interrupt, MCA_bus ? SA_SHIRQ : 0, "PS/2 Auxiliary", inode)) {<br>
 #else<br>
-	if (request_irq(AUX_IRQ, keyboard_interrupt, 0, "PS/2 Mouse", NULL)) {<br>
+	if (request_irq(AUX_IRQ, keyboard_interrupt, 0, "PS/2 Auxiliary", NULL)) {<br>
 #endif<br>
 		aux_count--;<br>
 		return -EBUSY;<br>
@@ -935,8 +989,12 @@<br>
 <br>
 static int __init psaux_init(void)<br>
 {<br>
+#ifndef KEYBOARD_IN_PSAUX<br>
+	/* This is wrong: if mouse is not present at boot, we'll<br>
+           refuse to use it even after hotplug. BAD. */<br>
 	if (aux_device_present != 0xaa)<br>
 		return -EIO;<br>
+#endif<br>
 <br>
 	printk(KERN_INFO "PS/2 auxiliary pointing device detected -- driver installed.\n");<br>
 	misc_register(&amp;psaux_mouse);<br>
@@ -956,6 +1014,12 @@<br>
 	kbd_write(KBD_CCMD_MOUSE_DISABLE, KBD_CNTL_REG); /* Disable aux device. */<br>
 	kbd_write_cmd(AUX_INTS_OFF); /* Disable controller ints. */<br>
 <br>
+#ifdef KEYBOARD_IN_PSAUX<br>
+	open_aux(NULL, NULL);<br>
+	psaux_id = register_keyboard(&amp;pckbd_operations, NULL, key_maps);<br>
+	if (psaux_id == NULL)<br>
+		printk(KERN_ERR "Couldn't register keyboard in PS/2 mouse port!\n");<br>
+#endif<br>
 	return 0;<br>
 }<br>
 <br>
<p>
<p>
<p>
<pre>
-- 
I'm really <a href="mailto:pavel@atrey.karlin.mff.cuni.cz">pavel@atrey.karlin.mff.cuni.cz</a>. 	   Pavel
Look at <a href="http://atrey.karlin.mff.cuni.cz/~pavel/">http://atrey.karlin.mff.cuni.cz/~pavel/</a> ;-).
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0716.html">Erik Arjan Hendriks: "Severe IDE BM-DMA problems."</a>
<li> <b>Previous message:</b> <a href="0714.html">Alex Belits: "Re: Comments on Microsoft Open Source document"</a>
<li> <b>In reply to:</b> <a href="0389.html">Paul Mackerras: "for comment: multi-keyboard patch"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0746.html">Paul Mackerras: "Re: for comment: multi-keyboard patch"</a>
<!-- reply="end" -->
</ul>
</font></body>
