<!-- received="Thu Nov  5 23:41:35 1998 EET" -->
<!-- sent="Thu, 5 Nov 1998 22:06:50 +0300" -->
<!-- name="Alexander V. Lukyanov" -->
<!-- email="lav@yars.free.net" -->
<!-- subject="Re: linux-2.1.126 hangs Probing PCI bus" -->
<!-- id="" -->
<!-- inreplyto="19981104184931Z154278-5652+2638@vger.rutgers.edu" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: linux-2.1.126 hangs Probing PCI bus</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: linux-2.1.126 hangs Probing PCI bus</h1>
<b>Alexander V. Lukyanov</b> (<a href="mailto:lav@yars.free.net"><i>lav@yars.free.net</i></a>)<br>
<i>Thu, 5 Nov 1998 22:06:50 +0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#685">[ date ]</a><a href="index.html#685">[ thread ]</a><a href="subject.html#685">[ subject ]</a><a href="author.html#685">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0686.html">John Fulmer: "KNFSD and autofs.."</a>
<li> <b>Previous message:</b> <a href="0684.html">Alan Cox: "Re: Dropped frames in video capture process"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; From: Stephen Williams &lt;<a href="mailto:steve@icarus.com">steve@icarus.com</a>&gt;</i><br>
<i>&gt; Date: Wed, 04 Nov 1998 14:53:55 -0800</i><br>
<i>&gt; Subject: linux-2.1.126 hangs Probing PCI bus</i><br>
<i>&gt; </i><br>
<i>&gt; I compiled 2.1.126 (no patches) configure for GENERIC on my PC164.</i><br>
<i>&gt; Most of the drivers are configured as modules, but the AIC7xxx and</i><br>
<i>&gt; CMD646 support are compiled it.</i><br>
<i>&gt; </i><br>
<i>&gt; It hangs right after "Probing PCI bus". I have included output from</i><br>
<i>&gt; lspci -v, in case that is useful. (I'm running 2.1.102 just fine.)</i><br>
<i>&gt; </i><br>
<i>&gt; I compiled with egcs-1.1b from the rawhide RPMS.</i><br>
<p>
I bet you compiled 2.1.102 with other compiler. I had the problem too,<br>
and it turned out to be a timer problem. It only appeared when gcc (or<br>
egcs) produced too good code, and could be solved by inserting little<br>
delay on top of SMC93x_Init function.<br>
<p>
Here is what Richard Henderson says:<br>
% &gt; handle_irq: irq 8 count 91837 cc 1612 @ fffffc0000328744<br>
% &gt; My system: pc164 433Mhz<br>
% <br>
% That is a timer going wild.  A cc that small means it was<br>
% interrupting at 268610 Hz -- about 200 times fast.<br>
% <br>
% This is semi-consistent with other systems in that RTC<br>
% handling seems dreadfully broken at the moment, and I have<br>
% no idea why.<br>
<p>
As I said, inserting udelay(200) fixed that problem, but nobody knows<br>
why. Disabling interrupts in SMC93x_Init fixes the problem too. Here<br>
is what I currently use on PC164/433Mhz/egcs-1.1/linux-2.1.126:<br>
<p>
--- smc37c93x.c.1       Thu Sep 24 17:12:04 1998<br>
+++ smc37c93x.c Thu Sep 24 17:10:46 1998<br>
@@ -242,6 +242,10 @@<br>
 int __init SMC93x_Init(void)<br>
 {<br>
        unsigned long SMCUltraBase;<br>
+       unsigned long flags;<br>
+       int ret;<br>
+<br>
+       __save_and_cli(flags);<br>
 <br>
        if ((SMCUltraBase = SMCDetectUltraIO()) != 0UL) {<br>
                printk("SMC FDC37C93X Ultra I/O Controller found @ 0x%lx\n",<br>
@@ -265,10 +269,12 @@<br>
                SMCReportDeviceStatus(SMCUltraBase);<br>
 #endif<br>
                SMCRunState(SMCUltraBase);<br>
-               return 1;<br>
+               ret = 1;<br>
        }<br>
        else {<br>
                DBG_DEVS(("No SMC FDC37C93X Ultra I/O Controller found\n"));<br>
-               return 0;<br>
+               ret = 0;<br>
        }<br>
+       __restore_flags(flags);<br>
+       return ret;<br>
 }<br>
<p>
   Alexander.<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0686.html">John Fulmer: "KNFSD and autofs.."</a>
<li> <b>Previous message:</b> <a href="0684.html">Alan Cox: "Re: Dropped frames in video capture process"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
