<!-- received="Thu Nov  5 17:25:36 1998 EET" -->
<!-- sent="Thu, 5 Nov 1998 09:43:58 -0500 (EST)" -->
<!-- name="Stephen Frost" -->
<!-- email="sfrost@ns.snowman.net" -->
<!-- subject="Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.95.981104100552.9071F-100000@penguin.transmeta.com" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)</h1>
<b>Stephen Frost</b> (<a href="mailto:sfrost@ns.snowman.net"><i>sfrost@ns.snowman.net</i></a>)<br>
<i>Thu, 5 Nov 1998 09:43:58 -0500 (EST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#631">[ date ]</a><a href="index.html#631">[ thread ]</a><a href="subject.html#631">[ subject ]</a><a href="author.html#631">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0632.html">Stefan Ring: "Re: 10,000 fds, 10,000 tasks"</a>
<li> <b>Previous message:</b> <a href="0630.html">Alan Cox: "Re: 2.3: Designing a better serial subsystem."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Wed, 4 Nov 1998, Linus Torvalds wrote:<br>
<p>
<i>&gt; </i><br>
<i>&gt; </i><br>
<i>&gt; On Wed, 4 Nov 1998, Stephen Frost wrote:</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; 	Is everything that does a 'current-&gt;timeout = jiffies + x;' obsolete and</i><br>
<i>&gt; &gt; needing to be redone as 'schedule_timeout(x);'?</i><br>
<i>&gt; </i><br>
<i>&gt; Yes. However, I've done some of it already. Sending me patches is still a</i><br>
<i>&gt; good idea, though. </i><br>
<i>&gt; </i><br>
<i>&gt; The areas that I haven't done are mainly:</i><br>
<i>&gt;  - non-PC drivers</i><br>
<i>&gt;  - ISDN</i><br>
<i>&gt;  - cdrom drivers</i><br>
<i>&gt;  - some of the more special serial and parallel port drivers</i><br>
<p>
	Okay, here is a patch for the ISDN, non-PC and some of the other<br>
drivers.  There were a couple (mcdx cdrom driver comes to mind) that did<br>
some things w/ current-&gt;timeout values I wasn't sure I followed correctly<br>
so I didn't modify them, someone w/ more experiance w/ those drivers and the<br>
kernel in general will probably have to go through and fix those.<br>
<p>
	Also, I can't guarentee my modifications will even compile, but then,<br>
without them I know it won't compile, so...<br>
<p>
	Here's the patch, there was another for ftape posted not too long ago<br>
by someone else that I didn't include, if you want I'll send that along to you <br>
as well.<br>
<p>
		Stephen<br>
<p>
diff -u --recursive --new-file linux-2.1.127/arch/alpha/kernel/osf_sys.c linux/arch/alpha/kernel/osf_sys.c<br>
--- linux-2.1.127/arch/alpha/kernel/osf_sys.c	Sun Sep 13 13:22:17 1998<br>
+++ linux/arch/alpha/kernel/osf_sys.c	Thu Nov  5 08:24:56 1998<br>
@@ -1306,6 +1306,7 @@<br>
 {<br>
 	struct timeval tmp;<br>
 	unsigned long ticks;<br>
+	unsigned long tmp_timeout;<br>
 <br>
 	if (get_tv32(&amp;tmp, sleep))<br>
 		goto fault;<br>
@@ -1313,18 +1314,17 @@<br>
 	ticks = tmp.tv_usec;<br>
 	ticks = (ticks + (1000000 / HZ) - 1) / (1000000 / HZ);<br>
 	ticks += tmp.tv_sec * HZ;<br>
-	current-&gt;timeout = ticks + jiffies;<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
 <br>
-	schedule();<br>
+	tmp_timeout = schedule_timeout(ticks);<br>
 <br>
 	if (remain) {<br>
 		ticks = jiffies;<br>
-		if (ticks &lt; current-&gt;timeout)<br>
-			ticks = current-&gt;timeout - ticks;<br>
+		if (ticks &lt; tmp_timeout)<br>
+			ticks = tmp_timeout - ticks;<br>
 		else<br>
 			ticks = 0;<br>
-		current-&gt;timeout = 0;<br>
+		tmp_timeout = 0;<br>
 		tmp.tv_sec = ticks / HZ;<br>
 		tmp.tv_usec = ticks % HZ;<br>
 		if (put_tv32(remain, &amp;tmp))<br>
diff -u --recursive --new-file linux-2.1.127/arch/m68k/atari/time.c linux/arch/m68k/atari/time.c<br>
--- linux-2.1.127/arch/m68k/atari/time.c	Sat Jun 13 16:14:32 1998<br>
+++ linux/arch/m68k/atari/time.c	Thu Nov  5 08:25:20 1998<br>
@@ -279,8 +279,7 @@<br>
 <br>
     while( RTC_READ(RTC_FREQ_SELECT) &amp; RTC_UIP ) {<br>
         current-&gt;state = TASK_INTERRUPTIBLE;<br>
-        current-&gt;timeout = jiffies + HWCLK_POLL_INTERVAL;<br>
-        schedule();<br>
+        schedule_timeout(HWCLK_POLL_INTERVAL);<br>
     }<br>
 <br>
     save_flags(flags);<br>
diff -u --recursive --new-file linux-2.1.127/arch/mips/kernel/irixsig.c linux/arch/mips/kernel/irixsig.c<br>
--- linux-2.1.127/arch/mips/kernel/irixsig.c	Tue Oct 20 16:52:54 1998<br>
+++ linux/arch/mips/kernel/irixsig.c	Thu Nov  5 08:29:30 1998<br>
@@ -603,21 +603,22 @@<br>
 			error = -EINVAL;<br>
 			goto out;<br>
 		}<br>
-		expire = timespectojiffies(tp)+(tp-&gt;tv_sec||tp-&gt;tv_nsec)+jiffies;<br>
-		current-&gt;timeout = expire;<br>
+		expire = timespectojiffies(tp)+(tp-&gt;tv_sec||tp-&gt;tv_nsec);<br>
 	}<br>
 <br>
 	while(1) {<br>
 		long tmp = 0;<br>
+		long tmp_timeout = 0;<br>
 <br>
-		current-&gt;state = TASK_INTERRUPTIBLE; schedule();<br>
+		current-&gt;state = TASK_INTERRUPTIBLE;<br>
+		tmp_timeout = schedule_timeout(expire);<br>
 <br>
 		for (i=0; i&lt;=4; i++)<br>
 			tmp |= (current-&gt;signal.sig[i] &amp; kset.sig[i]);<br>
 <br>
 		if (tmp)<br>
 			break;<br>
-		if (tp &amp;&amp; expire &lt;= jiffies) {<br>
+		if (tp &amp;&amp; tmp_timeout &lt;= 0) {<br>
 			timeo = 1;<br>
 			break;<br>
 		}<br>
diff -u --recursive --new-file linux-2.1.127/arch/mips/kernel/sysirix.c linux/arch/mips/kernel/sysirix.c<br>
--- linux-2.1.127/arch/mips/kernel/sysirix.c	Tue Oct 20 16:52:54 1998<br>
+++ linux/arch/mips/kernel/sysirix.c	Thu Nov  5 08:30:54 1998<br>
@@ -1083,10 +1083,11 @@<br>
 {<br>
 	lock_kernel();<br>
 	if(ticks) {<br>
-		current-&gt;timeout = ticks + jiffies;<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
+		schedule_timeout(ticks);<br>
 	}<br>
-	schedule();<br>
+	else<br>
+		schedule();<br>
 	unlock_kernel();<br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.1.127/arch/ppc/8xx_io/uart.c linux/arch/ppc/8xx_io/uart.c<br>
--- linux-2.1.127/arch/ppc/8xx_io/uart.c	Wed Sep 30 13:14:16 1998<br>
+++ linux/arch/ppc/8xx_io/uart.c	Thu Nov  5 09:02:01 1998<br>
@@ -1314,12 +1314,11 @@<br>
 static void send_break(ser_info_t *info, int duration)<br>
 {<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + duration;<br>
 #ifdef SERIAL_DEBUG_SEND_BREAK<br>
 	printk("rs_send_break(%d) jiff=%lu...", duration, jiffies);<br>
 #endif<br>
 	begin_break(info);<br>
-	schedule();<br>
+	schedule_timeout(duration);<br>
 	end_break(info);<br>
 #ifdef SERIAL_DEBUG_SEND_BREAK<br>
 	printk("done jiffies=%lu\n", jiffies);<br>
@@ -1633,8 +1632,7 @@<br>
 	if (info-&gt;blocked_open) {<br>
 		if (info-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(info-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;info-&gt;open_wait);<br>
 	}<br>
@@ -1691,8 +1689,7 @@<br>
 #endif<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
 /*		current-&gt;counter = 0;	 make us low-priority */<br>
-		current-&gt;timeout = jiffies + char_time;<br>
-		schedule();<br>
+		schedule_timeout(char_time);<br>
 		if (signal_pending(current))<br>
 			break;<br>
 		if (timeout &amp;&amp; ((orig_jiffies + timeout) &lt; jiffies))<br>
diff -u --recursive --new-file linux-2.1.127/drivers/block/paride/pcd.c linux/drivers/block/paride/pcd.c<br>
--- linux-2.1.127/drivers/block/paride/pcd.c	Mon Sep 28 13:51:16 1998<br>
+++ linux/drivers/block/paride/pcd.c	Wed Nov  4 11:16:13 1998<br>
@@ -559,8 +559,7 @@<br>
 static void pcd_sleep( int cs )<br>
 <br>
 {       current-&gt;state = TASK_INTERRUPTIBLE;<br>
-        current-&gt;timeout = jiffies + cs;<br>
-        schedule();<br>
+        schedule_timeout(cs);<br>
 }<br>
 <br>
 static int pcd_reset( int unit )<br>
diff -u --recursive --new-file linux-2.1.127/drivers/block/paride/pf.c linux/drivers/block/paride/pf.c<br>
--- linux-2.1.127/drivers/block/paride/pf.c	Mon Sep 28 13:51:16 1998<br>
+++ linux/drivers/block/paride/pf.c	Wed Nov  4 11:16:09 1998<br>
@@ -660,8 +660,7 @@<br>
 static void pf_sleep( int cs )<br>
 <br>
 {       current-&gt;state = TASK_INTERRUPTIBLE;<br>
-        current-&gt;timeout = jiffies + cs;<br>
-        schedule();<br>
+        schedule_timeout(cs);<br>
 }<br>
 <br>
 <br>
diff -u --recursive --new-file linux-2.1.127/drivers/block/paride/pg.c linux/drivers/block/paride/pg.c<br>
--- linux-2.1.127/drivers/block/paride/pg.c	Mon Sep 28 13:51:16 1998<br>
+++ linux/drivers/block/paride/pg.c	Wed Nov  4 11:16:01 1998<br>
@@ -357,8 +357,7 @@<br>
 static void pg_sleep( int cs )<br>
 <br>
 {       current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + cs;<br>
-	schedule();<br>
+	schedule_timeout(cs);<br>
 }<br>
 <br>
 static int pg_wait( int unit, int go, int stop, int tmo, char * msg )<br>
diff -u --recursive --new-file linux-2.1.127/drivers/block/paride/pt.c linux/drivers/block/paride/pt.c<br>
--- linux-2.1.127/drivers/block/paride/pt.c	Mon Sep 28 13:51:16 1998<br>
+++ linux/drivers/block/paride/pt.c	Wed Nov  4 11:15:56 1998<br>
@@ -464,8 +464,7 @@<br>
 static void pt_sleep( int cs )<br>
 <br>
 {       current-&gt;state = TASK_INTERRUPTIBLE;<br>
-        current-&gt;timeout = jiffies + cs;<br>
-        schedule();<br>
+        schedule_timeout(cs);<br>
 }<br>
 <br>
 static int pt_poll_dsc( int unit, int pause, int tmo, char *msg )<br>
diff -u --recursive --new-file linux-2.1.127/drivers/block/swim3.c linux/drivers/block/swim3.c<br>
--- linux-2.1.127/drivers/block/swim3.c	Fri Aug 28 18:18:04 1998<br>
+++ linux/drivers/block/swim3.c	Wed Nov  4 13:34:56 1998<br>
@@ -740,8 +740,7 @@<br>
 			break;<br>
 		}<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + 1;<br>
-		schedule();<br>
+		schedule_timeout(1);<br>
 	}<br>
 	fs-&gt;ejected = 1;<br>
 	release_drive(fs);<br>
@@ -807,8 +806,7 @@<br>
 				break;<br>
 			}<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + 1;<br>
-			schedule();<br>
+			schedule_timeout(1);<br>
 		}<br>
 		if (err == 0 &amp;&amp; (swim3_readbit(fs, SEEK_COMPLETE) == 0<br>
<i> 				 || swim3_readbit(fs, DISK_IN) == 0))</i><br>
@@ -911,8 +909,7 @@<br>
 		if (signal_pending(current))<br>
 			break;<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + 1;<br>
-		schedule();<br>
+		schedule_timeout(1);<br>
 	}<br>
 	ret = swim3_readbit(fs, SEEK_COMPLETE) == 0<br>
<i> 		|| swim3_readbit(fs, DISK_IN) == 0;</i><br>
diff -u --recursive --new-file linux-2.1.127/drivers/cdrom/cdu31a.c linux/drivers/cdrom/cdu31a.c<br>
--- linux-2.1.127/drivers/cdrom/cdu31a.c	Sat Oct 17 18:52:18 1998<br>
+++ linux/drivers/cdrom/cdu31a.c	Wed Nov  4 13:36:34 1998<br>
@@ -409,8 +409,7 @@<br>
    if (cdu31a_irq &lt;= 0)<br>
    {<br>
       current-&gt;state = TASK_INTERRUPTIBLE;<br>
-      current-&gt;timeout = jiffies;<br>
-      schedule();<br>
+      schedule_timeout(0);<br>
    }<br>
    else /* Interrupt driven */<br>
    {<br>
@@ -753,8 +752,7 @@<br>
    }<br>
 <br>
    current-&gt;state = TASK_INTERRUPTIBLE;<br>
-   current-&gt;timeout = jiffies + 2*HZ;<br>
-   schedule();<br>
+   schedule_timeout(2*HZ);<br>
 <br>
    sony_get_toc();<br>
 }<br>
@@ -1012,8 +1010,7 @@<br>
    {<br>
       num_retries++;<br>
       current-&gt;state = TASK_INTERRUPTIBLE;<br>
-      current-&gt;timeout = jiffies + HZ/10; /* Wait .1 seconds on retries */<br>
-      schedule();<br>
+      schedule_timeout(HZ/10); /* Wait .1 seconds on retries */<br>
       goto retry_cd_operation;<br>
    }<br>
 <br>
diff -u --recursive --new-file linux-2.1.127/drivers/cdrom/mcd.c linux/drivers/cdrom/mcd.c<br>
--- linux-2.1.127/drivers/cdrom/mcd.c	Sat Jun 13 16:05:22 1998<br>
+++ linux/drivers/cdrom/mcd.c	Wed Nov  4 13:37:02 1998<br>
@@ -1100,8 +1100,7 @@<br>
                         return -EIO;            /* drive doesn't respond */<br>
                 if ((st &amp; MST_READY) == 0) {    /* no disk? wait a sec... */<br>
                         current-&gt;state = TASK_INTERRUPTIBLE;<br>
-                        current-&gt;timeout = jiffies + HZ;<br>
-                        schedule();<br>
+                        schedule_timeout(HZ);<br>
                 }<br>
         } while (((st &amp; MST_READY) == 0) &amp;&amp; count++ &lt; MCD_RETRY_ATTEMPTS);<br>
 <br>
diff -u --recursive --new-file linux-2.1.127/drivers/cdrom/sbpcd.c linux/drivers/cdrom/sbpcd.c<br>
--- linux-2.1.127/drivers/cdrom/sbpcd.c	Mon Sep 14 14:34:01 1998<br>
+++ linux/drivers/cdrom/sbpcd.c	Thu Nov  5 07:57:59 1998<br>
@@ -843,8 +843,7 @@<br>
 {<br>
 	sti();<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + time;<br>
-	schedule();<br>
+	schedule_timeout(time);<br>
 	sti();<br>
 }<br>
 /*==========================================================================*/<br>
diff -u --recursive --new-file linux-2.1.127/drivers/cdrom/sonycd535.c linux/drivers/cdrom/sonycd535.c<br>
--- linux-2.1.127/drivers/cdrom/sonycd535.c	Mon Aug 24 16:14:10 1998<br>
+++ linux/drivers/cdrom/sonycd535.c	Thu Nov  5 07:58:47 1998<br>
@@ -336,8 +336,7 @@<br>
 {<br>
 	if (sony535_irq_used &lt;= 0) {	/* poll */<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies;<br>
-		schedule();<br>
+		schedule_timeout(0);<br>
 	} else {	/* Interrupt driven */<br>
 		cli();<br>
 		enable_interrupts();<br>
@@ -893,8 +892,7 @@<br>
 						if (readStatus == BAD_STATUS) {<br>
 							/* Sleep for a while, then retry */<br>
 							current-&gt;state = TASK_INTERRUPTIBLE;<br>
-							current-&gt;timeout = jiffies + RETRY_FOR_BAD_STATUS;<br>
-							schedule();<br>
+							schedule_timeout(RETRY_FOR_BAD_STATUS);<br>
 						}<br>
 #if DEBUG &gt; 0<br>
 						printk(CDU535_MESSAGE_NAME<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/pcxx.c linux/drivers/char/pcxx.c<br>
--- linux-2.1.127/drivers/char/pcxx.c	Wed May 20 21:54:37 1998<br>
+++ linux/drivers/char/pcxx.c	Thu Nov  5 08:01:33 1998<br>
@@ -633,8 +633,7 @@<br>
 		if(info-&gt;blocked_open) {<br>
 			if(info-&gt;close_delay) {<br>
 				current-&gt;state = TASK_INTERRUPTIBLE;<br>
-				current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-				schedule();<br>
+				schedule_timeout(info-&gt;close_delay);<br>
 			}<br>
 			wake_up_interruptible(&amp;info-&gt;open_wait);<br>
 		}<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/radio-sf16fmi.c linux/drivers/char/radio-sf16fmi.c<br>
--- linux-2.1.127/drivers/char/radio-sf16fmi.c	Wed Nov  4 11:08:52 1998<br>
+++ linux/drivers/char/radio-sf16fmi.c	Thu Nov  5 08:02:10 1998<br>
@@ -82,8 +82,7 @@<br>
 	outbits(8, 0xC0, myport);<br>
 	/* it is better than udelay(140000), isn't it? */<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + HZ/7;<br>
-	schedule();<br>
+	schedule_timeout(HZ/7);<br>
 	/* ignore signals, we really should restore volume */<br>
 	if (dev-&gt;curvol) fmi_unmute(myport);<br>
 	return 0;<br>
@@ -100,8 +99,7 @@<br>
 	outb(val | 0x10, myport);<br>
 	/* it is better than udelay(140000), isn't it? */<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + HZ/7;<br>
-	schedule();<br>
+	schedule_timeout(HZ/7);<br>
 	/* do not do it..., 140ms is very looong time to get signal in real program <br>
 	if (signal_pending(current))<br>
 	    return -EINTR;<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/riscom8.c linux/drivers/char/riscom8.c<br>
--- linux-2.1.127/drivers/char/riscom8.c	Wed May  6 13:56:03 1998<br>
+++ linux/drivers/char/riscom8.c	Thu Nov  5 08:02:42 1998<br>
@@ -1172,8 +1172,7 @@<br>
 		timeout = jiffies+HZ;<br>
 		while(port-&gt;IER &amp; IER_TXEMPTY)  {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + port-&gt;timeout;<br>
-			schedule();<br>
+			schedule_timeout(port-&gt;timeout);<br>
 			if (jiffies &gt; timeout)<br>
 				break;<br>
 		}<br>
@@ -1189,8 +1188,7 @@<br>
 	if (port-&gt;blocked_open) {<br>
 		if (port-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + port-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(port-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;port-&gt;open_wait);<br>
 	}<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/rocket.c linux/drivers/char/rocket.c<br>
--- linux-2.1.127/drivers/char/rocket.c	Tue Sep  1 13:32:36 1998<br>
+++ linux/drivers/char/rocket.c	Thu Nov  5 08:03:52 1998<br>
@@ -1181,8 +1181,7 @@<br>
 	if (info-&gt;blocked_open) {<br>
 		if (info-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(info-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;info-&gt;open_wait);<br>
 	} else {<br>
@@ -1269,10 +1268,9 @@<br>
 static void send_break(	struct r_port * info, int duration)<br>
 {<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + duration;<br>
 	cli();<br>
 	sSendBreak(&amp;info-&gt;channel);<br>
-	schedule();<br>
+	schedule_timeout(duration);<br>
 	sClrBreak(&amp;info-&gt;channel);<br>
 	sti();<br>
 }<br>
@@ -1666,8 +1664,7 @@<br>
 #endif<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		current-&gt;counter = 0;	/* make us low-priority */<br>
-		current-&gt;timeout = jiffies + check_time;<br>
-		schedule();<br>
+		schedule_timeout(check_time);<br>
 		if (signal_pending(current))<br>
 			break;<br>
 	}<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/saa5249.c linux/drivers/char/saa5249.c<br>
--- linux-2.1.127/drivers/char/saa5249.c	Tue Oct  6 12:39:49 1998<br>
+++ linux/drivers/char/saa5249.c	Thu Nov  5 08:04:24 1998<br>
@@ -242,8 +242,7 @@<br>
 	recalc_sigpending(current);<br>
 	spin_unlock_irq(&amp;current-&gt;sigmask_lock);<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + delay;<br>
-	schedule();<br>
+	schedule_timeout(delay);<br>
 <br>
 	spin_lock_irq(&amp;current-&gt;sigmask_lock);<br>
 	current-&gt;blocked = oldblocked;<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/serial167.c linux/drivers/char/serial167.c<br>
--- linux-2.1.127/drivers/char/serial167.c	Mon Oct  5 17:12:12 1998<br>
+++ linux/drivers/char/serial167.c	Thu Nov  5 08:04:44 1998<br>
@@ -1952,8 +1952,7 @@<br>
     if (info-&gt;blocked_open) {<br>
 	if (info-&gt;close_delay) {<br>
 	    current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	    current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-	    schedule();<br>
+	    schedule_timeout(info-&gt;close_delay);<br>
 	}<br>
 	wake_up_interruptible(&amp;info-&gt;open_wait);<br>
     }<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/specialix.c linux/drivers/char/specialix.c<br>
--- linux-2.1.127/drivers/char/specialix.c	Wed Nov  4 11:08:52 1998<br>
+++ linux/drivers/char/specialix.c	Thu Nov  5 08:05:21 1998<br>
@@ -1551,8 +1551,7 @@<br>
 		timeout = jiffies+HZ;<br>
 		while(port-&gt;IER &amp; IER_TXEMPTY) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + port-&gt;timeout;<br>
-			schedule();<br>
+			schedule_timeout(port-&gt;timeout);<br>
 			if (jiffies &gt; timeout) {<br>
 				printk (KERN_INFO "Timeout waiting for close\n");<br>
 				break;<br>
@@ -1571,8 +1570,7 @@<br>
 	if (port-&gt;blocked_open) {<br>
 		if (port-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + port-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(port-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;port-&gt;open_wait);<br>
 	}<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/stallion.c linux/drivers/char/stallion.c<br>
--- linux-2.1.127/drivers/char/stallion.c	Fri Oct 23 11:26:04 1998<br>
+++ linux/drivers/char/stallion.c	Thu Nov  5 08:05:36 1998<br>
@@ -1072,8 +1072,7 @@<br>
 #endif<br>
 	if (len &gt; 0) {<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + len;<br>
-		schedule();<br>
+		schedule_timeout(len);<br>
 		current-&gt;state = TASK_RUNNING;<br>
 	}<br>
 }<br>
diff -u --recursive --new-file linux-2.1.127/drivers/char/tpqic02.c linux/drivers/char/tpqic02.c<br>
--- linux-2.1.127/drivers/char/tpqic02.c	Fri Oct  9 14:56:59 1998<br>
+++ linux/drivers/char/tpqic02.c	Thu Nov  5 08:06:45 1998<br>
@@ -588,9 +588,10 @@<br>
 		/* not ready and no exception &amp;&amp; timeout not expired yet */<br>
 	while (((stat = inb_p(QIC02_STAT_PORT) &amp; QIC02_STAT_MASK) == QIC02_STAT_MASK) &amp;&amp; (jiffies&lt;spin_t)) {<br>
 		/* be `nice` to other processes on long operations... */<br>
-		current-&gt;timeout = jiffies + 3*HZ/10;	/* nap 0.30 sec between checks, */<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		schedule();		 /* but could be woken up earlier by signals... */<br>
+		/* nap 0.30 sec between checks, */<br>
+		/* but could be woken up earlier by signals... */<br>
+		schedule_timeout(3*HZ/10);<br>
 	}<br>
 <br>
 	/* don't use jiffies for this test because it may have changed by now */<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/act2000/act2000_isa.c linux/drivers/isdn/act2000/act2000_isa.c<br>
--- linux-2.1.127/drivers/isdn/act2000/act2000_isa.c	Thu May 21 17:24:06 1998<br>
+++ linux/drivers/isdn/act2000/act2000_isa.c	Thu Nov  5 08:34:29 1998<br>
@@ -61,8 +61,7 @@<br>
 {<br>
         sti();<br>
         current-&gt;state = TASK_INTERRUPTIBLE;<br>
-        current-&gt;timeout = jiffies + t;<br>
-        schedule();<br>
+        schedule_timeout(t);<br>
         sti();<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/avmb1/b1capi.c linux/drivers/isdn/avmb1/b1capi.c<br>
--- linux-2.1.127/drivers/isdn/avmb1/b1capi.c	Wed Apr  1 19:20:57 1998<br>
+++ linux/drivers/isdn/avmb1/b1capi.c	Thu Nov  5 08:34:58 1998<br>
@@ -965,9 +965,8 @@<br>
 <br>
 		while (card-&gt;cardstate != CARD_RUNNING) {<br>
 <br>
-			current-&gt;timeout = jiffies + HZ / 10;	/* 0.1 sec */<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			schedule();<br>
+			schedule_timeout(HZ/10);	/* 0.1 sec */<br>
 <br>
 			if (signal_pending(current))<br>
 				return -EINTR;<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/arcofi.c linux/drivers/isdn/hisax/arcofi.c<br>
--- linux-2.1.127/drivers/isdn/hisax/arcofi.c	Wed Apr  1 19:20:57 1998<br>
+++ linux/drivers/isdn/hisax/arcofi.c	Thu Nov  5 08:35:34 1998<br>
@@ -40,8 +40,7 @@<br>
 	while (cnt &amp;&amp; !test_bit(HW_MON1_TX_END, &amp;cs-&gt;HW_Flags)) {<br>
 		cnt--;<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + (10 * HZ) / 1000;	/* Timeout 10ms */<br>
-		schedule();<br>
+		schedule_timeout((10*HZ)/1000);	/* Timeout 10ms */<br>
 	}<br>
 	restore_flags(flags);<br>
 	sprintf(tmp, "arcofi tout %d", cnt);<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/asuscom.c linux/drivers/isdn/hisax/asuscom.c<br>
--- linux-2.1.127/drivers/isdn/hisax/asuscom.c	Wed Apr  1 19:20:57 1998<br>
+++ linux/drivers/isdn/hisax/asuscom.c	Thu Nov  5 08:36:03 1998<br>
@@ -201,12 +201,10 @@<br>
 	save_flags(flags);<br>
 	sti();<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 1;<br>
-	schedule();<br>
+	schedule_timeout(1);<br>
 	byteout(cs-&gt;hw.asus.adr, 0);	/* Reset Off */<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 1;<br>
-	schedule();<br>
+	schedule_timeout(1);<br>
 	restore_flags(flags);<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/diva.c linux/drivers/isdn/hisax/diva.c<br>
--- linux-2.1.127/drivers/isdn/hisax/diva.c	Wed Apr  1 19:20:58 1998<br>
+++ linux/drivers/isdn/hisax/diva.c	Thu Nov  5 08:36:49 1998<br>
@@ -241,13 +241,11 @@<br>
 	cs-&gt;hw.diva.ctrl_reg = 0;        /* Reset On */<br>
 	byteout(cs-&gt;hw.diva.ctrl, cs-&gt;hw.diva.ctrl_reg);<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + (10 * HZ) / 1000;	/* Timeout 10ms */<br>
-	schedule();<br>
+	schedule_timeout((10*HZ)/1000);	/* Timeout 10ms */<br>
 	cs-&gt;hw.diva.ctrl_reg |= DIVA_RESET;  /* Reset Off */<br>
 	byteout(cs-&gt;hw.diva.ctrl, cs-&gt;hw.diva.ctrl_reg);<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + (10 * HZ) / 1000;	/* Timeout 10ms */<br>
-	schedule();<br>
+	schedule_timeout((10*HZ)/1000);	/* Timeout 10ms */<br>
 	if (cs-&gt;subtyp == DIVA_ISA)<br>
 		cs-&gt;hw.diva.ctrl_reg |= DIVA_ISA_LED_A;<br>
 	else<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/elsa.c linux/drivers/isdn/hisax/elsa.c<br>
--- linux-2.1.127/drivers/isdn/hisax/elsa.c	Wed Apr  1 19:20:58 1998<br>
+++ linux/drivers/isdn/hisax/elsa.c	Thu Nov  5 08:37:49 1998<br>
@@ -450,12 +450,10 @@<br>
 		sti();<br>
 		writereg(cs-&gt;hw.elsa.ale, cs-&gt;hw.elsa.isac, IPAC_POTA2, 0x20);<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + (10 * HZ) / 1000;	/* Timeout 10ms */<br>
-		schedule();<br>
+		schedule_timeout((10*HZ)/1000);	/* Timeout 10ms */<br>
 		writereg(cs-&gt;hw.elsa.ale, cs-&gt;hw.elsa.isac, IPAC_POTA2, 0x00);<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + (10 * HZ) / 1000;	/* Timeout 10ms */<br>
-		schedule();<br>
+		schedule_timeout((10*HZ)/1000);	/* Timeout 10ms */<br>
 		writereg(cs-&gt;hw.elsa.ale, cs-&gt;hw.elsa.isac, IPAC_MASK, 0xc0);<br>
 		schedule();<br>
 		restore_flags(flags);<br>
@@ -658,8 +656,7 @@<br>
 			} else<br>
 				return(0);<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + (110 * HZ) / 1000;		/* Timeout 110ms */<br>
-			schedule();<br>
+			schedule_timeout((110*HZ)/1000);		/* Timeout 110ms */<br>
 			restore_flags(flags);<br>
 			cs-&gt;hw.elsa.ctrl_reg &amp;= ~ELSA_ENA_TIMER_INT;<br>
 			byteout(cs-&gt;hw.elsa.ctrl, cs-&gt;hw.elsa.ctrl_reg);<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/netjet.c linux/drivers/isdn/hisax/netjet.c<br>
--- linux-2.1.127/drivers/isdn/hisax/netjet.c	Wed Apr  1 19:21:02 1998<br>
+++ linux/drivers/isdn/hisax/netjet.c	Thu Nov  5 08:38:21 1998<br>
@@ -971,13 +971,11 @@<br>
 	cs-&gt;hw.njet.ctrl_reg = 0xff;  /* Reset On */<br>
 	byteout(cs-&gt;hw.njet.base + NETJET_CTRL, cs-&gt;hw.njet.ctrl_reg);<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + (10 * HZ) / 1000;	/* Timeout 10ms */<br>
-	schedule();<br>
+	schedule_timeout((10*HZ)/1000);	/* Timeout 10ms */<br>
 	cs-&gt;hw.njet.ctrl_reg = 0x00;  /* Reset Off and status read clear */<br>
 	byteout(cs-&gt;hw.njet.base + NETJET_CTRL, cs-&gt;hw.njet.ctrl_reg);<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + (10 * HZ) / 1000;	/* Timeout 10ms */<br>
-	schedule();<br>
+	schedule_timeout((10*HZ)/1000);	/* Timeout 10ms */<br>
 	restore_flags(flags);<br>
 	cs-&gt;hw.njet.auxd = 0;<br>
 	cs-&gt;hw.njet.dmactrl = 0;<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/sedlbauer.c linux/drivers/isdn/hisax/sedlbauer.c<br>
--- linux-2.1.127/drivers/isdn/hisax/sedlbauer.c	Wed Apr  1 19:21:02 1998<br>
+++ linux/drivers/isdn/hisax/sedlbauer.c	Thu Nov  5 08:38:42 1998<br>
@@ -242,12 +242,10 @@<br>
 		save_flags(flags);<br>
 		sti();<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + 1;<br>
-		schedule();<br>
+		schedule_timeout(1);<br>
 		byteout(cs-&gt;hw.sedl.reset_off, 0);	/* Reset Off */<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + 1;<br>
-		schedule();<br>
+		schedule_timeout(1);<br>
 		restore_flags(flags);<br>
 	}<br>
 }<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/sportster.c linux/drivers/isdn/hisax/sportster.c<br>
--- linux-2.1.127/drivers/isdn/hisax/sportster.c	Wed Apr  1 19:21:02 1998<br>
+++ linux/drivers/isdn/hisax/sportster.c	Thu Nov  5 08:39:10 1998<br>
@@ -165,13 +165,11 @@<br>
 	save_flags(flags);<br>
 	sti();<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 1;<br>
-	schedule();<br>
+	schedule_timeout(1);<br>
 	cs-&gt;hw.spt.res_irq &amp;= ~SPORTSTER_RESET; /* Reset Off */<br>
 	byteout(cs-&gt;hw.spt.cfg_reg + SPORTSTER_RES_IRQ, cs-&gt;hw.spt.res_irq);<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 1;<br>
-	schedule();<br>
+	schedule_timeout(1);<br>
 	restore_flags(flags);<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/teleint.c linux/drivers/isdn/hisax/teleint.c<br>
--- linux-2.1.127/drivers/isdn/hisax/teleint.c	Wed Apr  1 19:21:02 1998<br>
+++ linux/drivers/isdn/hisax/teleint.c	Thu Nov  5 08:39:31 1998<br>
@@ -246,13 +246,11 @@<br>
 	save_flags(flags);<br>
 	sti();<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 3;<br>
-	schedule();<br>
+	schedule_timeout(3);<br>
 	cs-&gt;hw.hfc.cirm &amp;= ~HFC_RESET;<br>
 	byteout(cs-&gt;hw.hfc.addr | 1, cs-&gt;hw.hfc.cirm);	/* Reset Off */<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 1;<br>
-	schedule();<br>
+	schedule_timeout(1);<br>
 	restore_flags(flags);<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/hisax/teles3c.c linux/drivers/isdn/hisax/teles3c.c<br>
--- linux-2.1.127/drivers/isdn/hisax/teles3c.c	Wed Apr  1 19:21:02 1998<br>
+++ linux/drivers/isdn/hisax/teles3c.c	Thu Nov  5 08:40:05 1998<br>
@@ -79,13 +79,11 @@<br>
 	save_flags(flags);<br>
 	sti();<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 3;<br>
-	schedule();<br>
+	schedule_timeout(3);<br>
 	cs-&gt;hw.hfcD.cirm = HFCD_MEM8K;<br>
 	cs-&gt;BC_Write_Reg(cs, HFCD_DATA, HFCD_CIRM, cs-&gt;hw.hfcD.cirm);	/* Reset Off */<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 1;<br>
-	schedule();<br>
+	schedule_timeout(1);<br>
 	cs-&gt;hw.hfcD.cirm |= HFCD_INTB;<br>
 	cs-&gt;BC_Write_Reg(cs, HFCD_DATA, HFCD_CIRM, cs-&gt;hw.hfcD.cirm);	/* INT B */<br>
 	cs-&gt;BC_Write_Reg(cs, HFCD_DATA, HFCD_CLKDEL, 0x0e);<br>
@@ -136,8 +134,7 @@<br>
 			save_flags(flags);<br>
 			sti();<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + (80*HZ)/1000;<br>
-			schedule();<br>
+			schedule_timeout((80*HZ)/1000);<br>
 			cs-&gt;hw.hfcD.ctmt |= HFCD_TIM800;<br>
 			cs-&gt;BC_Write_Reg(cs, HFCD_DATA, HFCD_CTMT, cs-&gt;hw.hfcD.ctmt); <br>
 			cs-&gt;BC_Write_Reg(cs, HFCD_DATA, HFCD_MST_MODE, cs-&gt;hw.hfcD.mst_m);<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/icn/icn.c linux/drivers/isdn/icn/icn.c<br>
--- linux-2.1.127/drivers/isdn/icn/icn.c	Thu May 21 17:24:06 1998<br>
+++ linux/drivers/isdn/icn/icn.c	Thu Nov  5 08:41:24 1998<br>
@@ -914,8 +914,7 @@<br>
 			printk(KERN_DEBUG "Loader %d TO?\n", cardnumber);<br>
 #endif<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + ICN_BOOT_TIMEOUT1;<br>
-			schedule();<br>
+			schedule_timeout(ICN_BOOT_TIMEOUT1);<br>
 		} else {<br>
 #ifdef BOOT_DEBUG<br>
 			printk(KERN_DEBUG "Loader %d OK\n", cardnumber);<br>
@@ -941,8 +940,7 @@<br>
   printk(KERN_DEBUG "SLEEP(%d)\n",slsec); \<br>
   while (slsec) { \<br>
     current-&gt;state = TASK_INTERRUPTIBLE; \<br>
-    current-&gt;timeout = jiffies + HZ; \<br>
-    schedule(); \<br>
+    schedule_timeout(HZ); \<br>
     slsec--; \<br>
   } \<br>
 }<br>
@@ -1104,8 +1102,7 @@<br>
 				return -EIO;<br>
 			}<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + 10;<br>
-			schedule();<br>
+			schedule_timeout(10);<br>
 		}<br>
 	}<br>
 	writeb(0x20, &amp;sbuf_n);<br>
@@ -1129,8 +1126,7 @@<br>
 			printk(KERN_DEBUG "Proto TO?\n");<br>
 #endif<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + ICN_BOOT_TIMEOUT1;<br>
-			schedule();<br>
+			schedule_timeout(ICN_BOOT_TIMEOUT1);<br>
 		} else {<br>
 			if ((card-&gt;secondhalf) || (!card-&gt;doubleS0)) {<br>
 #ifdef BOOT_DEBUG<br>
@@ -1425,11 +1421,9 @@<br>
 						if (!card-&gt;leased) {<br>
 							card-&gt;leased = 1;<br>
 							while (card-&gt;ptype == ISDN_PTYPE_UNKNOWN) {<br>
-								current-&gt;timeout = jiffies + ICN_BOOT_TIMEOUT1;<br>
-								schedule();<br>
+								schedule_timeout(ICN_BOOT_TIMEOUT1);<br>
 							}<br>
-							current-&gt;timeout = jiffies + ICN_BOOT_TIMEOUT1;<br>
-							schedule();<br>
+							schedule_timeout(ICN_BOOT_TIMEOUT1);<br>
 							sprintf(cbuf, "00;FV2ON\n01;EAZ%c\n02;EAZ%c\n",<br>
 								(a &amp; 1)?'1':'C', (a &amp; 2)?'2':'C');<br>
 							i = icn_writecmd(cbuf, strlen(cbuf), 0, card);<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/sc/init.c linux/drivers/isdn/sc/init.c<br>
--- linux-2.1.127/drivers/isdn/sc/init.c	Wed Apr  1 19:21:04 1998<br>
+++ linux/drivers/isdn/sc/init.c	Thu Nov  5 08:42:10 1998<br>
@@ -165,8 +165,7 @@<br>
 			pr_debug("Doing a SAFE probe reset\n");<br>
 			outb(0xFF, io[b] + RESET_OFFSET);<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + milliseconds(10000);<br>
-			schedule();<br>
+			schedule_timeout(milliseconds(10000));<br>
 		}<br>
 		pr_debug("RAM Base for board %d is 0x%x, %s probe\n", b, ram[b],<br>
 			ram[b] == 0 ? "will" : "won't");<br>
@@ -514,8 +513,7 @@<br>
 	 */<br>
 	outb(PRI_BASEPG_VAL, pgport);<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + HZ;<br>
-	schedule();<br>
+	schedule_timeout(HZ);<br>
 	sig = readl(rambase + SIG_OFFSET);<br>
 	pr_debug("Looking for a signature, got 0x%x\n", sig);<br>
 #if 0<br>
@@ -535,8 +533,7 @@<br>
 	 */<br>
 	outb(BRI_BASEPG_VAL, pgport);<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + HZ;<br>
-	schedule();<br>
+	schedule_timeout(HZ);<br>
 	sig = readl(rambase + SIG_OFFSET);<br>
 	pr_debug("Looking for a signature, got 0x%x\n", sig);<br>
 #if 0<br>
@@ -571,8 +568,7 @@<br>
 	x = 0;<br>
 	while((inb(iobase + FIFOSTAT_OFFSET) &amp; RF_HAS_DATA) &amp;&amp; x &lt; 100) {<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + 1;<br>
-		schedule();<br>
+		schedule_timeout(1);<br>
 		x++;<br>
 	}<br>
 	if(x == 100) {<br>
diff -u --recursive --new-file linux-2.1.127/drivers/isdn/sc/message.c linux/drivers/isdn/sc/message.c<br>
--- linux-2.1.127/drivers/isdn/sc/message.c	Wed Apr  1 19:21:04 1998<br>
+++ linux/drivers/isdn/sc/message.c	Thu Nov  5 08:42:26 1998<br>
@@ -267,8 +267,7 @@<br>
 	/* wait for the response */<br>
 	while (tries &lt; timeout) {<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + 1; <br>
-		schedule();<br>
+		schedule_timeout(1);<br>
 		<br>
 		pr_debug("SAR waiting..\n");<br>
 <br>
diff -u --recursive --new-file linux-2.1.127/drivers/macintosh/macserial.c linux/drivers/macintosh/macserial.c<br>
--- linux-2.1.127/drivers/macintosh/macserial.c	Tue Aug  4 19:08:05 1998<br>
+++ linux/drivers/macintosh/macserial.c	Thu Nov  5 08:07:17 1998<br>
@@ -1264,8 +1264,7 @@<br>
 	if (info-&gt;blocked_open) {<br>
 		if (info-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(info-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;info-&gt;open_wait);<br>
 	}<br>
@@ -1301,8 +1300,7 @@<br>
 	while ((read_zsreg(info-&gt;zs_channel, 1) &amp; ALL_SNT) == 0) {<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		current-&gt;counter = 0;	/* make us low-priority */<br>
-		current-&gt;timeout = jiffies + char_time;<br>
-		schedule();<br>
+		schedule_timeout(char_time);<br>
 		if (signal_pending(current))<br>
 			break;<br>
 		if (timeout &amp;&amp; ((orig_jiffies + timeout) &lt; jiffies))<br>
diff -u --recursive --new-file linux-2.1.127/drivers/macintosh/mediabay.c linux/drivers/macintosh/mediabay.c<br>
--- linux-2.1.127/drivers/macintosh/mediabay.c	Fri May  8 03:25:50 1998<br>
+++ linux/drivers/macintosh/mediabay.c	Thu Nov  5 08:07:42 1998<br>
@@ -184,8 +184,7 @@<br>
 <br>
 		prev = media_bay_id;<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + 1;<br>
-		schedule();<br>
+		schedule_timeout(1);<br>
 		if (signal_pending(current))<br>
 			return 0;<br>
 	}<br>
diff -u --recursive --new-file linux-2.1.127/drivers/net/cs89x0.c linux/drivers/net/cs89x0.c<br>
--- linux-2.1.127/drivers/net/cs89x0.c	Fri Feb 20 21:28:22 1998<br>
+++ linux/drivers/net/cs89x0.c	Thu Nov  5 08:07:57 1998<br>
@@ -403,8 +403,7 @@<br>
 <br>
 	/* wait 30 ms */<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + 3;<br>
-	schedule();<br>
+	schedule_timeout(3);<br>
 <br>
 	if (lp-&gt;chip_type != CS8900) {<br>
 		/* Hardware problem requires PNP registers to be reconfigured after a reset */<br>
diff -u --recursive --new-file linux-2.1.127/drivers/net/sktr.c linux/drivers/net/sktr.c<br>
--- linux-2.1.127/drivers/net/sktr.c	Fri Oct  9 14:56:59 1998<br>
+++ linux/drivers/net/sktr.c	Thu Nov  5 08:09:48 1998<br>
@@ -1526,11 +1526,10 @@<br>
 {<br>
 	long tmp;<br>
 <br>
-	tmp = jiffies + time/(1000000/HZ);<br>
+	tmp = time/(1000000/HZ);<br>
 	do {<br>
-		current-&gt;timeout	= tmp;<br>
 		current-&gt;state 		= TASK_INTERRUPTIBLE;<br>
-		schedule();<br>
+		tmp = schedule_timeout(tmp);<br>
 	} while(tmp &gt; jiffies);<br>
 <br>
 	return;<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sbus/char/pcikbd.c linux/drivers/sbus/char/pcikbd.c<br>
--- linux-2.1.127/drivers/sbus/char/pcikbd.c	Wed Nov  4 11:08:53 1998<br>
+++ linux/drivers/sbus/char/pcikbd.c	Thu Nov  5 08:42:52 1998<br>
@@ -691,8 +691,7 @@<br>
 		    == AUX_STAT_OBF)<br>
 			pcimouse_inb(pcimouse_iobase + KBD_DATA_REG);<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		current-&gt;timeout = jiffies + (5*HZ + 99) / 100;<br>
-		schedule();<br>
+		schedule_timeout((5*HZ + 99)/100);<br>
 		retries++;<br>
 	}<br>
 	return (retries &lt; MAX_RETRIES);<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sbus/char/sab82532.c linux/drivers/sbus/char/sab82532.c<br>
--- linux-2.1.127/drivers/sbus/char/sab82532.c	Wed Nov  4 11:08:54 1998<br>
+++ linux/drivers/sbus/char/sab82532.c	Thu Nov  5 08:43:21 1998<br>
@@ -1629,8 +1629,7 @@<br>
 	if (info-&gt;blocked_open) {<br>
 		if (info-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(info-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;info-&gt;open_wait);<br>
 	}<br>
@@ -1674,8 +1673,7 @@<br>
 	while (info-&gt;xmit_cnt || !info-&gt;all_sent) {<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		current-&gt;counter = 0;<br>
-		current-&gt;timeout = jiffies + char_time;<br>
-		schedule();<br>
+		schedule_timeout(char_time);<br>
 		if (signal_pending(current))<br>
 			break;<br>
 		if (timeout &amp;&amp; (orig_jiffies + timeout) &lt; jiffies)<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sbus/char/su.c linux/drivers/sbus/char/su.c<br>
--- linux-2.1.127/drivers/sbus/char/su.c	Wed Nov  4 11:08:54 1998<br>
+++ linux/drivers/sbus/char/su.c	Thu Nov  5 08:43:49 1998<br>
@@ -1744,8 +1744,7 @@<br>
 	if (info-&gt;blocked_open) {<br>
 		if (info-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(info-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;info-&gt;open_wait);<br>
 	}<br>
@@ -1797,8 +1796,7 @@<br>
 #endif<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		current-&gt;counter = 0;	/* make us low-priority */<br>
-		current-&gt;timeout = jiffies + char_time;<br>
-		schedule();<br>
+		schedule_timeout(char_time);<br>
 		if (signal_pending(current))<br>
 			break;<br>
 		if (timeout &amp;&amp; ((orig_jiffies + timeout) &lt; jiffies))<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sbus/char/zs.c linux/drivers/sbus/char/zs.c<br>
--- linux-2.1.127/drivers/sbus/char/zs.c	Wed Nov  4 11:08:54 1998<br>
+++ linux/drivers/sbus/char/zs.c	Thu Nov  5 08:45:41 1998<br>
@@ -1354,10 +1354,9 @@<br>
 	if (!info-&gt;port)<br>
 		return;<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + duration;<br>
 	cli();<br>
 	write_zsreg(info-&gt;zs_channel, 5, (info-&gt;curregs[5] | SND_BRK));<br>
-	schedule();<br>
+	schedule_timeout(duration);<br>
 	write_zsreg(info-&gt;zs_channel, 5, info-&gt;curregs[5]);<br>
 	sti();<br>
 }<br>
@@ -1543,8 +1542,7 @@<br>
 	if (info-&gt;blocked_open) {<br>
 		if (info-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(info-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;info-&gt;open_wait);<br>
 	}<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sgi/char/sgiserial.c linux/drivers/sgi/char/sgiserial.c<br>
--- linux-2.1.127/drivers/sgi/char/sgiserial.c	Fri May  8 03:23:41 1998<br>
+++ linux/drivers/sgi/char/sgiserial.c	Thu Nov  5 08:46:12 1998<br>
@@ -1279,10 +1279,9 @@<br>
 	if (!info-&gt;port)<br>
 		return;<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + duration;<br>
 	cli();<br>
 	write_zsreg(info-&gt;zs_channel, 5, (info-&gt;curregs[5] | SND_BRK));<br>
-	schedule();<br>
+	schedule_timeout(duration);<br>
 	write_zsreg(info-&gt;zs_channel, 5, info-&gt;curregs[5]);<br>
 	sti();<br>
 }<br>
@@ -1483,8 +1482,7 @@<br>
 	if (info-&gt;blocked_open) {<br>
 		if (info-&gt;close_delay) {<br>
 			current-&gt;state = TASK_INTERRUPTIBLE;<br>
-			current-&gt;timeout = jiffies + info-&gt;close_delay;<br>
-			schedule();<br>
+			schedule_timeout(info-&gt;close_delay);<br>
 		}<br>
 		wake_up_interruptible(&amp;info-&gt;open_wait);<br>
 	}<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sound/cs4232.c linux/drivers/sound/cs4232.c<br>
--- linux-2.1.127/drivers/sound/cs4232.c	Wed Jul 22 16:45:52 1998<br>
+++ linux/drivers/sound/cs4232.c	Thu Nov  5 08:10:19 1998<br>
@@ -96,9 +96,7 @@<br>
 static void sleep(unsigned howlong)<br>
 {<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + howlong;<br>
-	schedule();<br>
-	current-&gt;timeout = 0;<br>
+	schedule_timeout(howlong);<br>
 }<br>
 <br>
 int probe_cs4232(struct address_info *hw_config)<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sound/es1370.c linux/drivers/sound/es1370.c<br>
--- linux-2.1.127/drivers/sound/es1370.c	Wed Nov  4 11:08:56 1998<br>
+++ linux/drivers/sound/es1370.c	Thu Nov  5 08:14:37 1998<br>
@@ -1017,11 +1017,8 @@<br>
                 }<br>
 		tmo = (count * HZ) / dac1_samplerate[(s-&gt;ctrl &amp; CTRL_WTSRSEL) &gt;&gt; CTRL_SH_WTSRSEL];<br>
 		tmo &gt;&gt;= sample_shift[(s-&gt;sctrl &amp; SCTRL_P1FMT) &gt;&gt; SCTRL_SH_P1FMT];<br>
-		current-&gt;timeout = jiffies + (tmo ? tmo : 1);<br>
-                schedule();<br>
-		if (tmo &amp;&amp; !current-&gt;timeout)<br>
+		if (tmo &amp;&amp; !schedule_timeout(two ? two : 1))<br>
 			printk(KERN_DEBUG "es1370: dma timed out??\n");<br>
-		current-&gt;timeout = 0;<br>
         }<br>
         remove_wait_queue(&amp;s-&gt;dma_dac1.wait, &amp;wait);<br>
         current-&gt;state = TASK_RUNNING;<br>
@@ -1055,11 +1052,9 @@<br>
                 }<br>
 		tmo = (count * HZ) / DAC2_DIVTOSR((s-&gt;ctrl &amp; CTRL_PCLKDIV) &gt;&gt; CTRL_SH_PCLKDIV);<br>
 		tmo &gt;&gt;= sample_shift[(s-&gt;sctrl &amp; SCTRL_P2FMT) &gt;&gt; SCTRL_SH_P2FMT];<br>
-		current-&gt;timeout = jiffies + (tmo ? tmo : 1);<br>
-                schedule();<br>
-		if (tmo &amp;&amp; !current-&gt;timeout)<br>
+                schedule_timeout(two ? two : 1);<br>
+		if (tmo &amp;&amp; !schedule_timeout(two ? two : 1))<br>
 			printk(KERN_DEBUG "es1370: dma timed out??\n");<br>
-		current-&gt;timeout = 0;<br>
         }<br>
         remove_wait_queue(&amp;s-&gt;dma_dac2.wait, &amp;wait);<br>
         current-&gt;state = TASK_RUNNING;<br>
@@ -2201,11 +2196,8 @@<br>
 				return -EBUSY;<br>
 			}<br>
 			tmo = (count * HZ) / 3100;<br>
-			current-&gt;timeout = tmo ? jiffies + tmo : 0;<br>
-			schedule();<br>
-			if (tmo &amp;&amp; !current-&gt;timeout)<br>
+			if (tmo &amp;&amp; !schedule_timeout(two ? tmo : 0))<br>
 				printk(KERN_DEBUG "es1370: midi timed out??\n");<br>
-			current-&gt;timeout = 0;<br>
 		}<br>
 		remove_wait_queue(&amp;s-&gt;midi.owait, &amp;wait);<br>
 		current-&gt;state = TASK_RUNNING;<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sound/es1371.c linux/drivers/sound/es1371.c<br>
--- linux-2.1.127/drivers/sound/es1371.c	Fri Sep  4 18:32:27 1998<br>
+++ linux/drivers/sound/es1371.c	Thu Nov  5 08:15:52 1998<br>
@@ -1462,11 +1462,8 @@<br>
                 }<br>
 		tmo = (count * HZ) / s-&gt;dac1rate;<br>
 		tmo &gt;&gt;= sample_shift[(s-&gt;sctrl &amp; SCTRL_P1FMT) &gt;&gt; SCTRL_SH_P1FMT];<br>
-		current-&gt;timeout = jiffies + (tmo ? tmo : 1);<br>
-                schedule();<br>
-		if (tmo &amp;&amp; !current-&gt;timeout)<br>
+		if (tmo &amp;&amp; !schedule_timeout(tmo ? tmo : 1))<br>
 			printk(KERN_DEBUG "es1371: dma timed out??\n");<br>
-		current-&gt;timeout = 0;<br>
         }<br>
         remove_wait_queue(&amp;s-&gt;dma_dac1.wait, &amp;wait);<br>
         current-&gt;state = TASK_RUNNING;<br>
@@ -1500,11 +1497,8 @@<br>
                 }<br>
 		tmo = (count * HZ) / s-&gt;dac2rate;<br>
 		tmo &gt;&gt;= sample_shift[(s-&gt;sctrl &amp; SCTRL_P2FMT) &gt;&gt; SCTRL_SH_P2FMT];<br>
-		current-&gt;timeout = jiffies + (tmo ? tmo : 1);<br>
-                schedule();<br>
-		if (tmo &amp;&amp; !current-&gt;timeout)<br>
+		if (tmo &amp;&amp; !schedule_timeout(tmo ? tmo : 1))<br>
 			printk(KERN_DEBUG "es1371: dma timed out??\n");<br>
-		current-&gt;timeout = 0;<br>
         }<br>
         remove_wait_queue(&amp;s-&gt;dma_dac2.wait, &amp;wait);<br>
         current-&gt;state = TASK_RUNNING;<br>
@@ -2635,11 +2629,8 @@<br>
 				return -EBUSY;<br>
 			}<br>
 			tmo = (count * HZ) / 3100;<br>
-			current-&gt;timeout = tmo ? jiffies + tmo : 0;<br>
-			schedule();<br>
-			if (tmo &amp;&amp; !current-&gt;timeout)<br>
+			if (tmo &amp;&amp; !schedule_timeout(tmo ? tmo : 0))<br>
 				printk(KERN_DEBUG "es1371: midi timed out??\n");<br>
-			current-&gt;timeout = 0;<br>
 		}<br>
 		remove_wait_queue(&amp;s-&gt;midi.owait, &amp;wait);<br>
 		current-&gt;state = TASK_RUNNING;<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sound/maui.c linux/drivers/sound/maui.c<br>
--- linux-2.1.127/drivers/sound/maui.c	Thu May 14 13:33:17 1998<br>
+++ linux/drivers/sound/maui.c	Thu Nov  5 08:16:42 1998<br>
@@ -81,10 +81,8 @@<br>
 	{<br>
 		if (inb(HOST_STAT_PORT) &amp; mask)<br>
 			return 1;<br>
-		current-&gt;timeout = jiffies + HZ / 10;<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
-		schedule();<br>
-		current-&gt;timeout = 0;<br>
+		schedule_timeout(HZ/10);<br>
 		if (signal_pending(current))<br>
 			return 0;<br>
 	}<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sound/sgalaxy.c linux/drivers/sound/sgalaxy.c<br>
--- linux-2.1.127/drivers/sound/sgalaxy.c	Sat Oct 17 18:33:46 1998<br>
+++ linux/drivers/sound/sgalaxy.c	Thu Nov  5 08:17:55 1998<br>
@@ -29,9 +29,7 @@<br>
 static void sleep( unsigned howlong )<br>
 {<br>
 	current-&gt;state   = TASK_INTERRUPTIBLE;<br>
-	current-&gt;timeout = jiffies + howlong;<br>
-	schedule();<br>
-	current-&gt;timeout = 0;<br>
+	schedule_timeout(howlong);<br>
 }<br>
 <br>
 #define DPORT 0x80<br>
diff -u --recursive --new-file linux-2.1.127/drivers/sound/sonicvibes.c linux/drivers/sound/sonicvibes.c<br>
--- linux-2.1.127/drivers/sound/sonicvibes.c	Fri Sep  4 18:32:27 1998<br>
+++ linux/drivers/sound/sonicvibes.c	Thu Nov  5 08:18:55 1998<br>
@@ -1245,11 +1245,8 @@<br>
                 }<br>
 		tmo = (count * HZ) / s-&gt;ratedac;<br>
 		tmo &gt;&gt;= sample_shift[(s-&gt;fmt &gt;&gt; SV_CFMT_ASHIFT) &amp; SV_CFMT_MASK];<br>
-		current-&gt;timeout = jiffies + (tmo ? tmo : 1);<br>
-                schedule();<br>
-		if (tmo &amp;&amp; !current-&gt;timeout)<br>
+		if (tmo &amp;&amp; !schedule_timeout(tmo ? tmo : 1))<br>
 			printk(KERN_DEBUG "sv: dma timed out??\n");<br>
-		current-&gt;timeout = 0;<br>
         }<br>
         remove_wait_queue(&amp;s-&gt;dma_dac.wait, &amp;wait);<br>
         current-&gt;state = TASK_RUNNING;<br>
@@ -2025,11 +2022,8 @@<br>
 				return -EBUSY;<br>
 			}<br>
 			tmo = (count * HZ) / 3100;<br>
-			current-&gt;timeout = tmo ? jiffies + tmo : 0;<br>
-			schedule();<br>
-			if (tmo &amp;&amp; !current-&gt;timeout)<br>
+			if (tmo &amp;&amp; !schedule_timeout(tmo ? tmo : 0))<br>
 				printk(KERN_DEBUG "sv: midi timed out??\n");<br>
-			current-&gt;timeout = 0;<br>
 		}<br>
 		remove_wait_queue(&amp;s-&gt;midi.owait, &amp;wait);<br>
 		current-&gt;state = TASK_RUNNING;<br>
diff -u --recursive --new-file linux-2.1.127/fs/ncpfs/sock.c linux/fs/ncpfs/sock.c<br>
--- linux-2.1.127/fs/ncpfs/sock.c	Fri Mar  6 20:37:42 1998<br>
+++ linux/fs/ncpfs/sock.c	Thu Nov  5 09:07:49 1998<br>
@@ -94,7 +94,7 @@<br>
 	poll_table wait_table;<br>
 	struct poll_table_entry entry;<br>
 	int init_timeout, max_timeout;<br>
-	int timeout;<br>
+	int timeout; long tmp_timeout;<br>
 	int retrans;<br>
 	int major_timeout_seen;<br>
 	int acknowledge_seen;<br>
@@ -182,17 +182,16 @@<br>
 				}<br>
 				timeout = max_timeout;<br>
 			}<br>
-			current-&gt;timeout = jiffies + timeout;<br>
-			schedule();<br>
+			tmp_timout = schedule_timeout(timeout);<br>
 			remove_wait_queue(entry.wait_address, &amp;entry.wait);<br>
 			fput(file);<br>
 			current-&gt;state = TASK_RUNNING;<br>
 			if (signal_pending(current)) {<br>
-				current-&gt;timeout = 0;<br>
+				tmp_timout = 0;<br>
 				result = -ERESTARTSYS;<br>
 				break;<br>
 			}<br>
-			if (!current-&gt;timeout) {<br>
+			if (!tmp_timout) {<br>
 				if (n &lt; retrans)<br>
 					continue;<br>
 				if (server-&gt;m.flags &amp; NCP_MOUNT_SOFT) {<br>
@@ -209,7 +208,7 @@<br>
 				major_timeout_seen = 1;<br>
 				continue;<br>
 			} else<br>
-				current-&gt;timeout = 0;<br>
+				tmp_timeout = 0;<br>
 		} else if (wait_table.nr) {<br>
 			remove_wait_queue(entry.wait_address, &amp;entry.wait);<br>
 			fput(file);<br>
diff -u --recursive --new-file linux-2.1.127/net/appletalk/ddp.c linux/net/appletalk/ddp.c<br>
--- linux-2.1.127/net/appletalk/ddp.c	Thu Aug 27 22:33:08 1998<br>
+++ linux/net/appletalk/ddp.c	Thu Nov  5 08:22:59 1998<br>
@@ -383,9 +383,8 @@<br>
 						/*<br>
 						 * Defer 1/10th<br>
 						 */<br>
-						current-&gt;timeout = jiffies + (HZ/10);<br>
 						current-&gt;state = TASK_INTERRUPTIBLE;<br>
-						schedule();<br>
+						schedule_timeout(HZ/10);<br>
 						if(atif-&gt;status &amp; ATIF_PROBE_FAIL)<br>
 							break;<br>
 					}<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0632.html">Stefan Ring: "Re: 10,000 fds, 10,000 tasks"</a>
<li> <b>Previous message:</b> <a href="0630.html">Alan Cox: "Re: 2.3: Designing a better serial subsystem."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
