<!-- received="Thu Nov  5 17:06:17 1998 EET" -->
<!-- sent="Thu, 5 Nov 1998 15:34:05 +0100 (CET)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@e-mind.com" -->
<!-- subject="Re: parport driver broken in 2.1.127-pre7?" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.96.981105144941.2740A-100000@dragon.bogus" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: parport driver broken in 2.1.127-pre7?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: parport driver broken in 2.1.127-pre7?</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@e-mind.com"><i>andrea@e-mind.com</i></a>)<br>
<i>Thu, 5 Nov 1998 15:34:05 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#627">[ date ]</a><a href="index.html#627">[ thread ]</a><a href="subject.html#627">[ subject ]</a><a href="author.html#627">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0628.html">Riley Williams: "Re: Verifying the kernel"</a>
<li> <b>Previous message:</b> <a href="0626.html">Stephen C. Tweedie: "Re: Volume Managers in Linux"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Thu, 5 Nov 1998, Andrea Arcangeli wrote:<br>
<p>
<i>&gt;And here the patch that implement the ioctl (against pre-2.1.127-6):</i><br>
<p>
Woops, excuse me, the volatile flags was neeed... here the correct patch<br>
again against pre-2.1.127-6:<br>
<p>
Index: linux/drivers/char/lp.c<br>
diff -u linux/drivers/char/lp.c:1.1.1.4 linux/drivers/char/lp.c:1.1.1.1.12.7<br>
--- linux/drivers/char/lp.c:1.1.1.4	Wed Nov  4 13:06:06 1998<br>
+++ linux/drivers/char/lp.c	Thu Nov  5 14:52:13 1998<br>
@@ -21,7 +21,8 @@<br>
  * Full efficient handling of printer with buggy irq handshake (now I have<br>
  * understood the meaning of the strange handshake). This is done sending new<br>
  * characters if the interrupt is just happened, even if the printer say to<br>
- * be still BUSY. This is needed at least with Epson Stylus Color.<br>
+ * be still BUSY. This is needed at least with Epson Stylus Color but<br>
+ * to be safe you must enable this _needed_ feature via ioctl.<br>
  * I also fixed the irq on the rising edge of the strobe problem.<br>
  *				Andrea Arcangeli, 15 Oct 1998<br>
  */<br>
@@ -225,25 +226,36 @@<br>
 		lp_yield(minor);<br>
 <br>
 		status = r_str(minor);<br>
-		/*<br>
-		 * On Epson Stylus Color we must continue even if LP_READY()<br>
-		 * is false to be efficient. This way is backwards<br>
-		 * compatible with old not-buggy printers. -arca<br>
-		 */<br>
-		if (LP_NO_ERROR(status) &amp;&amp;<br>
-		    ((lp_table[minor].irq_detected &amp;&amp; LP_NO_ACKING(status)) ||<br>
-		     LP_READY(status)))<br>
-			break;<br>
-		/*<br>
-		 * To have a chance to sleep on the interrupt we should break<br>
-		 * the polling loop ASAP. Unfortunately there seems to be<br>
-		 * some hardware that underperform so we leave this<br>
-		 * configurable at runtime. So when printing with irqs<br>
-		 * `tunelp /dev/lp0 -c 1' is a must to take the full<br>
-		 * advantage of the irq. -arca<br>
-		 */<br>
-		if (++count == LP_CHAR(minor))<br>
-			return 0;<br>
+		if (lp_table[minor].trustirq)<br>
+		{<br>
+			/*<br>
+			 * On Epson Stylus Color we must continue even if<br>
+			 * LP_READY() is false to be efficient. This way<br>
+			 * _should_ be backwards compatible with old<br>
+			 * not-buggy printers but it isn' t. -arca<br>
+			 */<br>
+			if (LP_NO_ERROR(status) &amp;&amp;<br>
+			    ((lp_table[minor].irq_detected &amp;&amp;<br>
+			      LP_NO_ACKING(status)) ||<br>
+			     LP_READY(status)))<br>
+				break;<br>
+			if (!LP_POLLED(minor) || ++count == LP_CHAR(minor))<br>
+				return 0;<br>
+		} else {<br>
+			if (LP_NO_ERROR(status) &amp;&amp; LP_READY(status))<br>
+				break;<br>
+			/*<br>
+			 * To have a chance to sleep on the interrupt we<br>
+			 * should break the polling loop ASAP. Unfortunately<br>
+			 * there seems to be some hardware that underperform<br>
+			 * so we leave this configurable at runtime. So when<br>
+			 * printing with irqs `tunelp /dev/lp0 -c 1' should<br>
+			 * be a must to take the full advantage of the<br>
+			 * irq. -arca<br>
+			 */<br>
+			if (++count == LP_CHAR(minor))<br>
+				return 0;<br>
+		}<br>
 	}<br>
 <br>
 	w_dtr(minor, lpchar);<br>
@@ -731,12 +743,17 @@<br>
 			if (copy_to_user((int *) arg, &amp;status, sizeof(int)))<br>
 				return -EFAULT;<br>
 			break;<br>
+ 		case LPTRUSTIRQ:<br>
+			if (arg)<br>
+				lp_table[minor].trustirq = 1;<br>
+			else<br>
+				lp_table[minor].trustirq = 0;<br>
+			break;<br>
 		default:<br>
 			retval = -EINVAL;<br>
 	}<br>
 	return retval;<br>
 }<br>
-<br>
 <br>
 static struct file_operations lp_fops = {<br>
 	lp_lseek,<br>
Index: linux/include/linux/lp.h<br>
diff -u linux/include/linux/lp.h:1.1.1.4 linux/include/linux/lp.h:1.1.1.1.12.4<br>
--- linux/include/linux/lp.h:1.1.1.4	Wed Nov  4 13:09:24 1998<br>
+++ linux/include/linux/lp.h	Thu Nov  5 15:32:39 1998<br>
@@ -67,7 +67,7 @@<br>
 			    or 0 for polling (no IRQ) */<br>
 #define LPGETIRQ 0x0606  /* get the current IRQ number */<br>
 #define LPWAIT   0x0608  /* corresponds to LP_INIT_WAIT */<br>
-#ifdef LP_NEED_CAREFUL<br>
+#if 0<br>
 #define LPCAREFUL   0x0609  /* call with TRUE arg to require out-of-paper, off-<br>
 			    line, and error indicators good on all writes,<br>
 			    FALSE to ignore them.  Default is ignore. */<br>
@@ -80,6 +80,9 @@<br>
 #define LPGETSTATS  0x060d  /* get statistics (struct lp_stats) */<br>
 #endif<br>
 #define LPGETFLAGS  0x060e  /* get status flags */<br>
+#define LPTRUSTIRQ  0x060f  /* cause lp to trust or not the irq, this is needed<br>
+			     * to give a sense to the irq printing at least<br>
+			     * for Epson Stylus Color */<br>
 <br>
 /* timeout for printk'ing a timeout, in jiffies (100ths of a second).<br>
    This is also used for re-checking error conditions if LP_ABORT is<br>
@@ -129,6 +132,7 @@<br>
 	volatile unsigned int irq_detected:1;<br>
 	volatile unsigned int irq_missed:1;<br>
 	unsigned int polled:1;<br>
+	unsigned int trustirq:1;<br>
 };<br>
 <br>
 /*<br>
<p>
<p>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0628.html">Riley Williams: "Re: Verifying the kernel"</a>
<li> <b>Previous message:</b> <a href="0626.html">Stephen C. Tweedie: "Re: Volume Managers in Linux"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
