<!-- received="Thu Nov  5 16:42:31 1998 EET" -->
<!-- sent="Thu, 5 Nov 1998 15:11:58 +0100 (CET)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@e-mind.com" -->
<!-- subject="Re: parport driver broken in 2.1.127-pre7?" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.96.981105134310.835B-100000@dragon.bogus" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: parport driver broken in 2.1.127-pre7?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: parport driver broken in 2.1.127-pre7?</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@e-mind.com"><i>andrea@e-mind.com</i></a>)<br>
<i>Thu, 5 Nov 1998 15:11:58 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#623">[ date ]</a><a href="index.html#623">[ thread ]</a><a href="subject.html#623">[ subject ]</a><a href="author.html#623">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0624.html">Alan Cox: "Re: Comments on Microsoft Open Source document"</a>
<li> <b>Previous message:</b> <a href="0622.html">Alan Cox: "Re: [OFFTOPIC] Re: Hello Chinese student"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Thu, 5 Nov 1998, Andrea Arcangeli wrote:<br>
<p>
<i>&gt;On Thu, 5 Nov 1998, Andrea Arcangeli wrote:</i><br>
<i>&gt;</i><br>
<i>&gt;&gt;I' ll send to you a patch ASAP that should fix your problem (I just know</i><br>
<i>&gt;</i><br>
<i>&gt;Here the patch that should fix your problem:</i><br>
<p>
I implemented the trustirq ioctl now.<br>
<p>
This minimal proggy allow me to set/unset the trustirq flag at runtime.<br>
<p>
#define	LPTRUSTIRQ  0x060f<br>
<p>
main(int argc, char **argv)<br>
{<br>
	int fd = open("/dev/lp0");<br>
	ioctl(fd, LPTRUSTIRQ, argc - 1);<br>
}<br>
<p>
And here the patch that implement the ioctl (against pre-2.1.127-6):<br>
<p>
Index: linux/drivers/char/lp.c<br>
diff -u linux/drivers/char/lp.c:1.1.1.4 linux/drivers/char/lp.c:1.1.1.1.12.7<br>
--- linux/drivers/char/lp.c:1.1.1.4	Wed Nov  4 13:06:06 1998<br>
+++ linux/drivers/char/lp.c	Thu Nov  5 14:52:13 1998<br>
@@ -21,7 +21,8 @@<br>
  * Full efficient handling of printer with buggy irq handshake (now I have<br>
  * understood the meaning of the strange handshake). This is done sending new<br>
  * characters if the interrupt is just happened, even if the printer say to<br>
- * be still BUSY. This is needed at least with Epson Stylus Color.<br>
+ * be still BUSY. This is needed at least with Epson Stylus Color but<br>
+ * to be safe you must enable this _needed_ feature via ioctl.<br>
  * I also fixed the irq on the rising edge of the strobe problem.<br>
  *				Andrea Arcangeli, 15 Oct 1998<br>
  */<br>
@@ -225,25 +226,36 @@<br>
 		lp_yield(minor);<br>
 <br>
 		status = r_str(minor);<br>
-		/*<br>
-		 * On Epson Stylus Color we must continue even if LP_READY()<br>
-		 * is false to be efficient. This way is backwards<br>
-		 * compatible with old not-buggy printers. -arca<br>
-		 */<br>
-		if (LP_NO_ERROR(status) &amp;&amp;<br>
-		    ((lp_table[minor].irq_detected &amp;&amp; LP_NO_ACKING(status)) ||<br>
-		     LP_READY(status)))<br>
-			break;<br>
-		/*<br>
-		 * To have a chance to sleep on the interrupt we should break<br>
-		 * the polling loop ASAP. Unfortunately there seems to be<br>
-		 * some hardware that underperform so we leave this<br>
-		 * configurable at runtime. So when printing with irqs<br>
-		 * `tunelp /dev/lp0 -c 1' is a must to take the full<br>
-		 * advantage of the irq. -arca<br>
-		 */<br>
-		if (++count == LP_CHAR(minor))<br>
-			return 0;<br>
+		if (lp_table[minor].trustirq)<br>
+		{<br>
+			/*<br>
+			 * On Epson Stylus Color we must continue even if<br>
+			 * LP_READY() is false to be efficient. This way<br>
+			 * _should_ be backwards compatible with old<br>
+			 * not-buggy printers but it isn' t. -arca<br>
+			 */<br>
+			if (LP_NO_ERROR(status) &amp;&amp;<br>
+			    ((lp_table[minor].irq_detected &amp;&amp;<br>
+			      LP_NO_ACKING(status)) ||<br>
+			     LP_READY(status)))<br>
+				break;<br>
+			if (!LP_POLLED(minor) || ++count == LP_CHAR(minor))<br>
+				return 0;<br>
+		} else {<br>
+			if (LP_NO_ERROR(status) &amp;&amp; LP_READY(status))<br>
+				break;<br>
+			/*<br>
+			 * To have a chance to sleep on the interrupt we<br>
+			 * should break the polling loop ASAP. Unfortunately<br>
+			 * there seems to be some hardware that underperform<br>
+			 * so we leave this configurable at runtime. So when<br>
+			 * printing with irqs `tunelp /dev/lp0 -c 1' should<br>
+			 * be a must to take the full advantage of the<br>
+			 * irq. -arca<br>
+			 */<br>
+			if (++count == LP_CHAR(minor))<br>
+				return 0;<br>
+		}<br>
 	}<br>
 <br>
 	w_dtr(minor, lpchar);<br>
@@ -731,12 +743,17 @@<br>
 			if (copy_to_user((int *) arg, &amp;status, sizeof(int)))<br>
 				return -EFAULT;<br>
 			break;<br>
+ 		case LPTRUSTIRQ:<br>
+			if (arg)<br>
+				lp_table[minor].trustirq = 1;<br>
+			else<br>
+				lp_table[minor].trustirq = 0;<br>
+			break;<br>
 		default:<br>
 			retval = -EINVAL;<br>
 	}<br>
 	return retval;<br>
 }<br>
-<br>
 <br>
 static struct file_operations lp_fops = {<br>
 	lp_lseek,<br>
Index: linux/include/linux/lp.h<br>
diff -u linux/include/linux/lp.h:1.1.1.4 linux/include/linux/lp.h:1.1.1.1.12.3<br>
--- linux/include/linux/lp.h:1.1.1.4	Wed Nov  4 13:09:24 1998<br>
+++ linux/include/linux/lp.h	Thu Nov  5 14:48:29 1998<br>
@@ -67,7 +67,7 @@<br>
 			    or 0 for polling (no IRQ) */<br>
 #define LPGETIRQ 0x0606  /* get the current IRQ number */<br>
 #define LPWAIT   0x0608  /* corresponds to LP_INIT_WAIT */<br>
-#ifdef LP_NEED_CAREFUL<br>
+#if 0<br>
 #define LPCAREFUL   0x0609  /* call with TRUE arg to require out-of-paper, off-<br>
 			    line, and error indicators good on all writes,<br>
 			    FALSE to ignore them.  Default is ignore. */<br>
@@ -80,6 +80,9 @@<br>
 #define LPGETSTATS  0x060d  /* get statistics (struct lp_stats) */<br>
 #endif<br>
 #define LPGETFLAGS  0x060e  /* get status flags */<br>
+#define LPTRUSTIRQ  0x060f  /* cause lp to trust or not the irq, this is needed<br>
+			     * to give a sense to the irq printing at least<br>
+			     * for Epson Stylus Color */<br>
 <br>
 /* timeout for printk'ing a timeout, in jiffies (100ths of a second).<br>
    This is also used for re-checking error conditions if LP_ABORT is<br>
@@ -126,9 +129,10 @@<br>
 #endif<br>
 	struct wait_queue *wait_q;<br>
 	unsigned int last_error;<br>
-	volatile unsigned int irq_detected:1;<br>
-	volatile unsigned int irq_missed:1;<br>
+	unsigned int irq_detected:1;<br>
+	unsigned int irq_missed:1;<br>
 	unsigned int polled:1;<br>
+	unsigned int trustirq:1;<br>
 };<br>
 <br>
 /*<br>
<p>
<p>
<p>
<p>
I' ll try to explain why Epson Stylus Color need to trust the irq.<br>
<p>
____<br>
BUSY<br>
_________________        ____________________<br>
___             |        |<br>
ACK             ----------<br>
____________________  _______________________<br>
<i>                    | |</i><br>
                    ---<br>
                       ---<br>
<i>		       | |</i><br>
		  *polling loop time*<br>
<p>
The problem is that the printer generate the ACK (and so the irq) very<br>
very soon. Once the irq is been generated lp doesn' t sleep on the irq<br>
anymore and continue to poll the BUSY flag because it knows that the<br>
printer will be ready very very soon. The problem is that polling so fast<br>
(in the *polling loop time*), causes lp to _overload_ the machine (this<br>
doesn' t harm because lp always schedule if need_resched is set, but it' s<br>
really stupid). <br>
<p>
irq (if LP_NO_ACKING() is true) and so, on such printers, we can send the<br>
next char a bit after the irq avoiding such stupid polling loop.<br>
<p>
Not buggy printers should handle that `trustirq' feature fine too because<br>
the specs say that after ACK is removed BUSY should be sure just removed<br>
from ages too. Unfortunately that' s not true as Peter pointed out ;-). So<br>
we need an ioctl that allow the admin to select on which printer trust the<br>
irq (and handle the full advantage of the irq). The overloading of the<br>
machine in system time change from 80/90% to 20/30% here, so if you don'<br>
t use trustirq, on some printers it' s better that you use polling... <br>
<p>
It would be nice if somebody would update tunelp to the new lp (note also<br>
that LP_CAREFUL is been removed from the kernel, because checking for the<br>
careful flag is slower than being careful all the time). I can do that<br>
myself if nobody else is interested to do that.<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0624.html">Alan Cox: "Re: Comments on Microsoft Open Source document"</a>
<li> <b>Previous message:</b> <a href="0622.html">Alan Cox: "Re: [OFFTOPIC] Re: Hello Chinese student"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
