<!-- received="Thu Nov  5 15:26:58 1998 EET" -->
<!-- sent="Thu, 5 Nov 1998 13:46:03 +0100 (CET)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@e-mind.com" -->
<!-- subject="Re: parport driver broken in 2.1.127-pre7?" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.96.981105131725.707A-100000@dragon.bogus" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: parport driver broken in 2.1.127-pre7?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: parport driver broken in 2.1.127-pre7?</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@e-mind.com"><i>andrea@e-mind.com</i></a>)<br>
<i>Thu, 5 Nov 1998 13:46:03 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#613">[ date ]</a><a href="index.html#613">[ thread ]</a><a href="subject.html#613">[ subject ]</a><a href="author.html#613">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0614.html">Andrej Presern: "Re: Random Register Contents"</a>
<li> <b>Previous message:</b> <a href="0612.html">David G Hamblen: "Dreadful xfer rates and TCPv4 bad checksum in 2.1.1xx with PPP"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Thu, 5 Nov 1998, Andrea Arcangeli wrote:<br>
<p>
<i>&gt;I' ll send to you a patch ASAP that should fix your problem (I just know</i><br>
<p>
Here the patch that should fix your problem:<br>
<p>
Index: lp.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/drivers/char/lp.c,v<br>
retrieving revision 1.1.1.1.12.5<br>
diff -u -r1.1.1.1.12.5 lp.c<br>
--- lp.c	1998/11/04 13:28:23	1.1.1.1.12.5<br>
+++ lp.c	1998/11/05 12:41:50<br>
@@ -21,7 +21,9 @@<br>
  * Full efficient handling of printer with buggy irq handshake (now I have<br>
  * understood the meaning of the strange handshake). This is done sending new<br>
  * characters if the interrupt is just happened, even if the printer say to<br>
- * be still BUSY. This is needed at least with Epson Stylus Color.<br>
+ * be still BUSY. This is needed at least with Epson Stylus Color but<br>
+ * to be safe you must #define LP_EPSON_STYLUS_COLOR by hand to take advantage<br>
+ * of this.<br>
  * I also fixed the irq on the rising edge of the strobe problem.<br>
  *				Andrea Arcangeli, 15 Oct 1998<br>
  */<br>
@@ -116,6 +118,7 @@<br>
 <br>
 /* if you have more than 3 printers, remember to increase LP_NO */<br>
 #define LP_NO 3<br>
+#undef LP_EPSON_STYLUS_COLOR<br>
 <br>
 struct lp_struct lp_table[LP_NO] =<br>
 {<br>
@@ -225,25 +228,32 @@<br>
 		lp_yield(minor);<br>
 <br>
 		status = r_str(minor);<br>
+#ifdef LP_EPSON_STYLUS_COLOR<br>
 		/*<br>
 		 * On Epson Stylus Color we must continue even if LP_READY()<br>
-		 * is false to be efficient. This way is backwards<br>
-		 * compatible with old not-buggy printers. -arca<br>
+		 * is false to be efficient. This way _should_ be backwards<br>
+		 * compatible with old not-buggy printers but it isn' t. -arca<br>
 		 */<br>
 		if (LP_NO_ERROR(status) &amp;&amp;<br>
 		    ((lp_table[minor].irq_detected &amp;&amp; LP_NO_ACKING(status)) ||<br>
 		     LP_READY(status)))<br>
 			break;<br>
+		if (!LP_POLLED(minor) || ++count == LP_CHAR(minor))<br>
+			return 0;<br>
+#else<br>
+		if (LP_NO_ERROR(status) &amp;&amp; LP_READY(status))<br>
+			break;<br>
 		/*<br>
 		 * To have a chance to sleep on the interrupt we should break<br>
 		 * the polling loop ASAP. Unfortunately there seems to be<br>
 		 * some hardware that underperform so we leave this<br>
 		 * configurable at runtime. So when printing with irqs<br>
-		 * `tunelp /dev/lp0 -c 1' is a must to take the full<br>
+		 * `tunelp /dev/lp0 -c 1' should be a must to take the full<br>
 		 * advantage of the irq. -arca<br>
 		 */<br>
 		if (++count == LP_CHAR(minor))<br>
 			return 0;<br>
+#endif<br>
 	}<br>
 <br>
 	w_dtr(minor, lpchar);<br>
<p>
<p>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0614.html">Andrej Presern: "Re: Random Register Contents"</a>
<li> <b>Previous message:</b> <a href="0612.html">David G Hamblen: "Dreadful xfer rates and TCPv4 bad checksum in 2.1.1xx with PPP"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
