<!-- received="Thu Nov  5 12:50:34 1998 EET" -->
<!-- sent="Thu, 5 Nov 1998 11:39:20 +0100 (MET)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)" -->
<!-- id="" -->
<!-- inreplyto="current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Thu, 5 Nov 1998 11:39:20 +0100 (MET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#597">[ date ]</a><a href="index.html#597">[ thread ]</a><a href="subject.html#597">[ subject ]</a><a href="author.html#597">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0598.html">Alexander Viro: "[FIX] Re: nasty inode leak in 2.1.125? details"</a>
<li> <b>Previous message:</b> <a href="0596.html">Benjamin Herrenschmidt: "Re: Comments on Microsoft Open Source document"</a>
<li> <b>Maybe in reply to:</b> <a href="0477.html">Stephen Frost: "current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0656.html">Matthias Welwarsky: "Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
In-Reply-To: &lt;108510665@toto.iv&gt;<br>
X-Mailer: VM 6.61 under Emacs 19.34.1<br>
<p>
Linus Torvalds writes:<br>
<i> &gt; On Wed, 4 Nov 1998, Stephen Frost wrote:</i><br>
<i> &gt; &gt; </i><br>
<i> &gt; &gt; 	Is everything that does a 'current-&gt;timeout = jiffies + x;' obsolete and</i><br>
<i> &gt; &gt; needing to be redone as 'schedule_timeout(x);'?</i><br>
<i> &gt; </i><br>
<i> &gt; Yes. However, I've done some of it already. Sending me patches is still a</i><br>
<i> &gt; good idea, though. </i><br>
<p>
Here's a patch for ftape which broke in pre-2.1.127-7.<br>
It seems to fix ftape for me, at least it compiles and<br>
basic operations (mt, tar cf, and tar xvf) seem to work.<br>
Caveat: ftape seems to want to issue repeated timeouts until<br>
certain events (usually an interrupt or expiration of a<br>
maximum time slice) so the diffs required a wee bit of though.<br>
I'm cc:ing this to the ftape maintainer (Claus-Justus Heine)<br>
so he can look them over.<br>
<p>
<p>
/Mikael<br>
<p>
<p>
--- linux-2.1.127-pre7/drivers/char/ftape/lowlevel/fdc-io.c.~1~	Mon Jun  8 22:32:26 1998<br>
+++ linux-2.1.127-pre7/drivers/char/ftape/lowlevel/fdc-io.c	Thu Nov  5 02:41:35 1998<br>
@@ -388,6 +388,7 @@<br>
 	struct wait_queue wait = {current, NULL};<br>
 	sigset_t old_sigmask;	<br>
 	static int resetting = 0;<br>
+	long timeout;<br>
 	TRACE_FUN(ft_t_fdc_dma);<br>
 <br>
 #if LINUX_VERSION_CODE &gt;= KERNEL_VER(2,0,16)<br>
@@ -400,7 +401,7 @@<br>
 	}<br>
 #endif<br>
 	/* timeout time will be up to USPT microseconds too long ! */<br>
-	current-&gt;timeout = jiffies + (1000 * time + FT_USPT - 1) / FT_USPT;<br>
+	timeout = (1000 * time + FT_USPT - 1) / FT_USPT;<br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
 <br>
 	spin_lock_irq(&amp;current-&gt;sigmask_lock);<br>
@@ -411,7 +412,7 @@<br>
 <br>
 	add_wait_queue(&amp;ftape_wait_intr, &amp;wait);<br>
 	while (!ft_interrupt_seen &amp;&amp; current-&gt;state != TASK_RUNNING) {<br>
-		schedule();	/* sets TASK_RUNNING on timeout */<br>
+		timeout = schedule_timeout(timeout);	/* sets TASK_RUNNING on timeout */<br>
         }<br>
 <br>
 	spin_lock_irq(&amp;current-&gt;sigmask_lock);<br>
@@ -433,7 +434,6 @@<br>
 	 */<br>
 	current-&gt;state = TASK_RUNNING; <br>
 	if (ft_interrupt_seen) { /* woken up by interrupt */<br>
-		current-&gt;timeout = 0;	  /* interrupt hasn't cleared this */<br>
 		ft_interrupt_seen = 0;<br>
 		TRACE_EXIT 0;<br>
 	}<br>
--- linux-2.1.127-pre7/drivers/char/ftape/lowlevel/ftape-io.c.~1~	Tue Dec  2 18:33:16 1997<br>
+++ linux-2.1.127-pre7/drivers/char/ftape/lowlevel/ftape-io.c	Thu Nov  5 02:16:53 1998<br>
@@ -93,13 +93,12 @@<br>
 		unsigned int ticks = (time + FT_USPT - 1) / FT_USPT;<br>
 <br>
 		TRACE(ft_t_any, "%d msec, %d ticks", time/1000, ticks);<br>
-		current-&gt;timeout = jiffies + ticks;<br>
 		current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		save_flags(flags);<br>
 		sti();<br>
 		do {<br>
 			while (current-&gt;state != TASK_RUNNING) {<br>
-				schedule();<br>
+				ticks = schedule_timeout(ticks);<br>
 			}<br>
 			/*  Mmm. Isn't current-&gt;blocked == 0xffffffff ?<br>
 			 */<br>
@@ -108,7 +107,7 @@<br>
 				      "awoken by non-blocked signal :-(");<br>
 				break;	/* exit on signal */<br>
 			}<br>
-		} while (current-&gt;timeout &gt; 0);<br>
+		} while (ticks &gt; 0);<br>
 		restore_flags(flags);<br>
 	}<br>
 	TRACE_EXIT;<br>
--- linux-2.1.127-pre7/drivers/char/ftape/zftape/zftape-buffers.c.~1~	Tue Nov 25 23:45:28 1997<br>
+++ linux-2.1.127-pre7/drivers/char/ftape/zftape/zftape-buffers.c	Thu Nov  5 02:19:55 1998<br>
@@ -122,9 +122,8 @@<br>
 	void *new;<br>
 <br>
 	while ((new = kmalloc(size, GFP_KERNEL)) == NULL) {<br>
-		current-&gt;timeout = HZ/10;<br>
 		current-&gt;state   = TASK_INTERRUPTIBLE;<br>
-		schedule();<br>
+		schedule_timeout(HZ/10);<br>
 	}<br>
 	memset(new, 0, size);<br>
 	used_memory += size;<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0598.html">Alexander Viro: "[FIX] Re: nasty inode leak in 2.1.125? details"</a>
<li> <b>Previous message:</b> <a href="0596.html">Benjamin Herrenschmidt: "Re: Comments on Microsoft Open Source document"</a>
<li> <b>Maybe in reply to:</b> <a href="0477.html">Stephen Frost: "current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0656.html">Matthias Welwarsky: "Re: current-&gt;timeout = jiffies + ?  -&gt; schedule_timeout(?)"</a>
<!-- reply="end" -->
</ul>
</font></body>
