<!-- received="Wed Nov  4 18:12:56 1998 EET" -->
<!-- sent="Wed, 4 Nov 1998 16:36:27 +0100" -->
<!-- name="Alain RICHARD" -->
<!-- email="alain_richard@equation.fr" -->
<!-- subject="NIPQUAD endian problem solved (patch included)" -->
<!-- id="v04020a03b26622ada753@[192.168.240.10]" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: NIPQUAD endian problem solved (patch included)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>NIPQUAD endian problem solved (patch included)</h1>
<b>Alain RICHARD</b> (<a href="mailto:alain_richard@equation.fr"><i>alain_richard@equation.fr</i></a>)<br>
<i>Wed, 4 Nov 1998 16:36:27 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#464">[ date ]</a><a href="index.html#464">[ thread ]</a><a href="subject.html#464">[ subject ]</a><a href="author.html#464">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0465.html">Johan Myreen: "Re: Erratic PS/2 Mouse in 2.1.126"</a>
<li> <b>Previous message:</b> <a href="0463.html">Andrea Arcangeli: "latest schedule_timeout() updates"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The NIPQUAD macro in the linux/kernel.h header that is faulty on big endian<br>
machines (PPC, Sparcs, m68k). It is used mainly in the firewalling code to<br>
print TCP/IP address in the form 192.9.200.1 in debugging messages (kernel<br>
messages). I don't know if it is used for other purpose. On big endian<br>
machines, the above address is badly printed as 1.200.9.192.<br>
<p>
It seems there was several attempts to correct this beavior that were<br>
removed because Linus don't agree with the bad code generated on little<br>
endian machines. The patch I propose is working both on little and big<br>
endian machines and also seems to produce better code on i386 processor<br>
that the original macro.<br>
<p>
I suggest the following new NIPQUADok macro to replace the broken NIPQUAD<br>
macro :<br>
<p>
#define NIPQUAD(addr) \<br>
        ((unsigned char *)&amp;addr)[0], \<br>
        ((unsigned char *)&amp;addr)[1], \<br>
        ((unsigned char *)&amp;addr)[2], \<br>
        ((unsigned char *)&amp;addr)[3]<br>
<p>
<p>
At the assembly level produced (using -O3) on the intel machine :<br>
<p>
#<br>
# code generated by the current macro<br>
#<br>
<p>
        movl %edx,%eax<br>
        shrl $24,%eax<br>
        pushl %eax<br>
        movl %edx,%eax<br>
        shrl $16,%eax<br>
        andl $255,%eax<br>
        pushl %eax<br>
        movl %edx,%eax<br>
        shrl $8,%eax<br>
        andl $255,%eax<br>
        pushl %eax<br>
        movzbl %dl,%edx<br>
        pushl %edx<br>
        pushl $.LC1<br>
        call printf<br>
<p>
#<br>
# code generated by the new macro<br>
#<br>
<p>
        movzbl -1(%ebp),%eax<br>
        pushl %eax<br>
        movzbl -2(%ebp),%eax<br>
        pushl %eax<br>
        movzbl -3(%ebp),%eax<br>
        pushl %eax<br>
        movzbl -4(%ebp),%eax<br>
        pushl %eax<br>
        pushl $.LC1<br>
        call printf<br>
<p>
<p>
This shows that the new macro is also better when looking at the generated<br>
code.<br>
<p>
I hope this will be included in the next kernel sub-release.<br>
<p>
Regards,<br>
<p>
diff -u linux-2.1.126/include/linux/kernel.h linux/include/linux/kernel.h<br>
--- linux-2.1.126/include/linux/kernel.h        Wed Oct 14 10:47:52 1998<br>
+++ linux/include/linux/kernel.h        Wed Oct 28 19:07:31 1998<br>
@@ -69,10 +69,10 @@<br>
  */<br>
<p>
 #define NIPQUAD(addr) \<br>
-       (int)(((addr) &gt;&gt; 0)  &amp; 0xff), \<br>
-       (int)(((addr) &gt;&gt; 8)  &amp; 0xff), \<br>
-       (int)(((addr) &gt;&gt; 16) &amp; 0xff), \<br>
-       (int)(((addr) &gt;&gt; 24) &amp; 0xff)<br>
+       ((unsigned char *)&amp;addr)[0], \<br>
+       ((unsigned char *)&amp;addr)[1], \<br>
+       ((unsigned char *)&amp;addr)[2], \<br>
+       ((unsigned char *)&amp;addr)[3]<br>
<p>
 #endif /* __KERNEL__ */<br>
<p>
------------------------------------------------<br>
Alain RICHARD &lt;<a href="mailto:alain_richard@equation.fr">mailto:alain_richard@equation.fr</a>&gt;<br>
EQUATION SA &lt;<a href="http://www.equation.fr">http://www.equation.fr</a>&gt;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0465.html">Johan Myreen: "Re: Erratic PS/2 Mouse in 2.1.126"</a>
<li> <b>Previous message:</b> <a href="0463.html">Andrea Arcangeli: "latest schedule_timeout() updates"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
