<!-- received="Wed Nov  4 16:44:15 1998 EET" -->
<!-- sent="Wed, 4 Nov 1998 15:14:33 +0100 (CET)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@e-mind.com" -->
<!-- subject="Re: [patch] my latest oom stuff" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.95.981103164444.4813E-100000@penguin.transmeta.com" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: [patch] my latest oom stuff</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: [patch] my latest oom stuff</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@e-mind.com"><i>andrea@e-mind.com</i></a>)<br>
<i>Wed, 4 Nov 1998 15:14:33 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#450">[ date ]</a><a href="index.html#450">[ thread ]</a><a href="subject.html#450">[ subject ]</a><a href="author.html#450">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0451.html">Greaves Tristan TM: "RE: 2.1.126 - x.x.x.x sent an invalid ICMP error to a broadcast"</a>
<li> <b>Previous message:</b> <a href="0449.html">Lyle Seaman: "RE: Volume Managers in Linux"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Tue, 3 Nov 1998, Linus Torvalds wrote:<br>
<p>
<i>&gt;It also feels pretty good under other load. Do you concur?</i><br>
<p>
The OOM problem seems solved fine after the merging. The only thing is<br>
that I think you missed the GFP_USER in the swapin stage (at the end of<br>
swap_state.c). I' ve seen that you fixed also some of my not very clever<br>
schedule_timeout() usage, that' s very good, thanks ;-). <br>
<p>
This patch implements my kswapd, add a sense to the swap cache find stats<br>
and fix the last GFP_USER. I think that my kswapd is very better than<br>
yours since you depends on the fact that your machine swapout many pages<br>
in 10msec. It' s not good to depens in function of time (if we must run in<br>
any kind of hardware). And I don' t agree with playing with p-&gt;counter.<br>
The kswapd-run-all-the-time is no more an issue if you don' t play with<br>
p-&gt;counter and without the RT flag (and scheduling() between<br>
do_try_to_free_pages() if resched is needed of course ;-).<br>
<p>
Index: linux/mm/swap_state.c<br>
diff -u linux/mm/swap_state.c:1.1.1.2 linux/mm/swap_state.c:1.1.1.1.14.6<br>
--- linux/mm/swap_state.c:1.1.1.2	Sat Oct 24 15:42:51 1998<br>
+++ linux/mm/swap_state.c	Wed Nov  4 14:59:40 1998<br>
@@ -310,9 +334,14 @@<br>
 	 */<br>
 	found_page = lookup_swap_cache(entry);<br>
 	if (found_page)<br>
+	{<br>
+#ifdef	SWAP_CACHE_INFO<br>
+		swap_cache_find_success++;<br>
+#endif<br>
 		goto out;<br>
+	}<br>
 <br>
-	new_page_addr = __get_free_page(GFP_KERNEL);<br>
+	new_page_addr = __get_free_page(GFP_USER);<br>
 	if (!new_page_addr)<br>
 		goto out;	/* Out of memory */<br>
 	new_page = mem_map + MAP_NR(new_page_addr);<br>
@@ -322,7 +351,20 @@<br>
 	 */<br>
 	found_page = lookup_swap_cache(entry);<br>
 	if (found_page)<br>
+	{<br>
+#ifdef	SWAP_CACHE_INFO<br>
+		swap_cache_find_success++;<br>
+#endif<br>
 		goto out_free_page;<br>
+	}<br>
+<br>
+#ifdef	SWAP_CACHE_INFO<br>
+	/*<br>
+	 * Not found in the swap cache.<br>
+	 */<br>
+	swap_cache_find_total++;<br>
+#endif<br>
+<br>
 	/*<br>
 	 * Make sure the swap entry is still in use.<br>
 	 */<br>
Index: linux/mm/vmscan.c<br>
diff -u linux/mm/vmscan.c:1.1.1.7 linux/mm/vmscan.c:1.1.1.2.4.35<br>
--- linux/mm/vmscan.c:1.1.1.7	Wed Nov  4 13:09:43 1998<br>
+++ linux/mm/vmscan.c	Wed Nov  4 14:28:45 1998<br>
@@ -7,6 +7,8 @@<br>
  *  kswapd added: 7.1.96  sct<br>
  *  Removed kswapd_ctl limits, and swap out as many pages as needed<br>
  *  to bring the system back to freepages.high: 2.4.97, Rik van Riel.<br>
+ *  Removed RT priority from kswapd. Now kswapd schedule() and runs as a normal<br>
+ *  process with dynamic priority in F(free_memory). 1998  Andrea Arcangeli<br>
  *  Version: $Id: vmscan.c,v 1.5 1998/02/23 22:14:28 sct Exp $<br>
  */<br>
 <br>
@@ -29,12 +31,6 @@<br>
 #include &lt;asm/pgtable.h&gt;<br>
 <br>
 /* <br>
- * How often do we do a pageout scan during normal conditions?<br>
- * Default is four times a second.<br>
- */<br>
-int swapout_interval = HZ / 4;<br>
-<br>
-/* <br>
  * The wait queue for waking up the pageout daemon:<br>
  */<br>
 struct task_struct * kswapd_task = NULL;<br>
@@ -445,7 +441,7 @@<br>
 	kmem_cache_reap(gfp_mask);<br>
 <br>
 	if (buffer_over_borrow() || pgcache_over_borrow())<br>
-		shrink_mmap(i, gfp_mask);<br>
+		state = 0;<br>
 <br>
 	switch (state) {<br>
 		do {<br>
@@ -489,6 +485,51 @@<br>
        printk ("Starting kswapd v%.*s\n", i, s);<br>
 }<br>
 <br>
+static long kswapd_priority(int free_memory)<br>
+{<br>
+	long priority;<br>
+	switch (free_memory)<br>
+	{<br>
+	case 0:<br>
+		priority = DEF_PRIORITY &lt;&lt; 1;<br>
+		break;<br>
+	case 2:<br>
+		priority = DEF_PRIORITY &gt;&gt; 1;<br>
+		break;<br>
+	default:<br>
+		priority = DEF_PRIORITY;<br>
+	}<br>
+	return priority;<br>
+}<br>
+<br>
+#define	kswapd_renice(freemem)					\<br>
+	(kswapd_task-&gt;priority = kswapd_priority(freemem))<br>
+<br>
+#define	kswapd_done(freemem)						\<br>
+	(freemem == 2 &amp;&amp; buffer_under_max() &amp;&amp; pgcache_under_max())<br>
+<br>
+#define	kswapd_schedule()			\<br>
+	do {					\<br>
+		if (kswapd_task-&gt;need_resched)	\<br>
+			schedule();		\<br>
+	} while(0)<br>
+<br>
+static void kswapd_engine(void)<br>
+{<br>
+	int free_memory = free_memory_available();<br>
+	for (;;)<br>
+	{<br>
+		kswapd_renice(free_memory);<br>
+		do_try_to_free_page(0);<br>
+		if (kswapd_done(free_memory_available()))<br>
+			break;<br>
+		kswapd_schedule();<br>
+		free_memory = free_memory_available();<br>
+		if (kswapd_done(free_memory))<br>
+			break;<br>
+	}<br>
+}<br>
+<br>
 /*<br>
  * The background pageout daemon.<br>
  * Started as a kernel thread from the init process.<br>
@@ -508,13 +549,6 @@<br>
 	lock_kernel();<br>
 <br>
 	/*<br>
-	 * Set the base priority to something smaller than a<br>
-	 * regular process. We will scale up the priority<br>
-	 * dynamically depending on how much memory we need.<br>
-	 */<br>
-	current-&gt;priority = (DEF_PRIORITY * 2) / 3;<br>
-<br>
-	/*<br>
 	 * Tell the memory management that we're a "memory allocator",<br>
 	 * and that if we need more memory we should get access to it<br>
 	 * regardless (see "try_to_free_pages()"). "kswapd" should<br>
@@ -531,20 +565,16 @@<br>
 	init_swap_timer();<br>
 	kswapd_task = current;<br>
 	while (1) {<br>
-		unsigned long end_time;<br>
-<br>
-		current-&gt;state = TASK_INTERRUPTIBLE;<br>
+/*  		run_task_queue(&amp;tq_disk); */<br>
 		flush_signals(current);<br>
-		run_task_queue(&amp;tq_disk);<br>
+		/*<br>
+		 * Remeber to enable up the swap tick before go to sleep.<br>
+		 */<br>
+		timer_active |= 1&lt;&lt;SWAP_TIMER;<br>
+		current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		schedule();<br>
 		swapstats.wakeups++;<br>
-<br>
-		/* max one hundreth of a second */<br>
-		end_time = jiffies + (HZ-1)/100;<br>
-		do {<br>
-			if (!do_try_to_free_page(0))<br>
-				break;<br>
-		} while (time_before_eq(jiffies,end_time));<br>
+		kswapd_engine();<br>
 	}<br>
 	/* As if we could ever get here - maybe we want to make this killable */<br>
 	kswapd_task = NULL;<br>
@@ -581,20 +611,12 @@<br>
 	return retval;<br>
 }<br>
 <br>
-/*<br>
- * Wake up kswapd according to the priority<br>
- *	0 - no wakeup<br>
- *	1 - wake up as a low-priority process<br>
- *	2 - wake up as a normal process<br>
- *	3 - wake up as an almost real-time process<br>
- *<br>
- * This plays mind-games with the "goodness()"<br>
- * function in kernel/sched.c.<br>
- */<br>
-static inline void kswapd_wakeup(struct task_struct *p, int priority)<br>
+static inline void kswapd_wakeup(int free_memory)<br>
 {<br>
-	if (priority) {<br>
-		p-&gt;counter = p-&gt;priority &lt;&lt; priority;<br>
+	struct task_struct *p = kswapd_task;<br>
+	if (p &amp;&amp; p-&gt;state &amp; TASK_INTERRUPTIBLE)<br>
+	{<br>
+		p-&gt;priority = kswapd_priority(free_memory);<br>
 		wake_up_process(p);<br>
 	}<br>
 }<br>
@@ -604,41 +626,16 @@<br>
  */<br>
 void swap_tick(void)<br>
 {<br>
-	struct task_struct *p = kswapd_task;<br>
-<br>
+	int free_memory = free_memory_available();<br>
 	/*<br>
-	 * Only bother to try to wake kswapd up<br>
-	 * if the task exists and can be woken.<br>
+	 * Schedule for wakeup if there isn't lots<br>
+	 * of free memory or if there is too much<br>
+	 * of it used for buffers or pgcache.<br>
 	 */<br>
-	if (p &amp;&amp; (p-&gt;state &amp; TASK_INTERRUPTIBLE)) {<br>
-		unsigned int pages;<br>
-		int want_wakeup;<br>
-<br>
-		/*<br>
-		 * Schedule for wakeup if there isn't lots<br>
-		 * of free memory or if there is too much<br>
-		 * of it used for buffers or pgcache.<br>
-		 *<br>
-		 * "want_wakeup" is our priority: 0 means<br>
-		 * not to wake anything up, while 3 means<br>
-		 * that we'd better give kswapd a realtime<br>
-		 * priority.<br>
-		 */<br>
-		want_wakeup = 0;<br>
-		if (buffer_over_max() || pgcache_over_max())<br>
-			want_wakeup = 1;<br>
-		pages = nr_free_pages;<br>
-		if (pages &lt; freepages.high)<br>
-			want_wakeup = 1;<br>
-		if (pages &lt; freepages.low)<br>
-			want_wakeup = 2;<br>
-		if (pages &lt; freepages.min)<br>
-			want_wakeup = 3;<br>
-	<br>
-		kswapd_wakeup(p,want_wakeup);<br>
-	}<br>
-<br>
-	timer_active |= (1&lt;&lt;SWAP_TIMER);<br>
+	if (free_memory != 2 || buffer_over_max() || pgcache_over_max())<br>
+		kswapd_wakeup(free_memory);<br>
+	else<br>
+		timer_active |= (1&lt;&lt;SWAP_TIMER);<br>
 }<br>
 <br>
 /* <br>
<p>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0451.html">Greaves Tristan TM: "RE: 2.1.126 - x.x.x.x sent an invalid ICMP error to a broadcast"</a>
<li> <b>Previous message:</b> <a href="0449.html">Lyle Seaman: "RE: Volume Managers in Linux"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
