<!-- received="Wed Nov  4 08:48:45 1998 EET" -->
<!-- sent="Wed, 04 Nov 1998 17:03:04 +1100" -->
<!-- name="Stephen.Rothwell@nec.com.au" -->
<!-- email="Stephen.Rothwell@nec.com.au" -->
<!-- subject="[PATCH] fix for buggy GCC and rwlock_t" -->
<!-- id="199811040603.RAA22517@oak.sdc.nec.com.au" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] fix for buggy GCC and rwlock_t</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] fix for buggy GCC and rwlock_t</h1>
<a href="mailto:Stephen.Rothwell@nec.com.au"><i>Stephen.Rothwell@nec.com.au</i></a><br>
<i>Wed, 04 Nov 1998 17:03:04 +1100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#399">[ date ]</a><a href="index.html#399">[ thread ]</a><a href="subject.html#399">[ subject ]</a><a href="author.html#399">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0400.html">Linus Torvalds: "Re: [patch] my latest oom stuff"</a>
<li> <b>Previous message:</b> <a href="0398.html">Rik van Riel: "Re: [patch] my latest oom stuff"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus,<br>
<p>
Someone else mentioned this previously, but rwlock_t in the<br>
UP case needs the same tratment as spinlock_t in order to compile<br>
with gcc 2.7.2.3.<br>
<p>
Cheers,<br>
Stephen<br>
<pre>
--
Stephen Rothwell                    <a href="mailto:Stephen.Rothwell@nec.com.au">Stephen.Rothwell@nec.com.au</a>
NEC Australia                       Phone:  +61-2-62508747
Information Systems Group           Fax:    +61-2-62508746
Canberra, Australia                 Mobile: +61-417-575843
<p>
--- linux-2.1.127-6/include/asm-i386/spinlock.h	Wed Nov  4 16:52:57 1998
+++ linux/include/asm-i386/spinlock.h	Wed Nov  4 16:57:41 1998
@@ -88,9 +88,16 @@
  * can "mix" irq-safe locks - any writer needs to get a
  * irq-safe write-lock, but readers can get non-irqsafe
  * read-locks.
+ *
+ * Gcc-2.7.x has a nasty bug with empty initializers.
  */
-typedef struct { } rwlock_t;
-#define RW_LOCK_UNLOCKED (rwlock_t) { }
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)
+  typedef struct { } rwlock_t;
+  #define RW_LOCK_UNLOCKED (rwlock_t) { }
+#else
+  typedef struct { int gcc_is_buggy; } rwlock_t;
+  #define RW_LOCK_UNLOCKED (rwlock_t) { 0 }
+#endif
 
 #define read_lock(lock)		do { } while(0)
 #define read_unlock(lock)	do { } while(0)
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0400.html">Linus Torvalds: "Re: [patch] my latest oom stuff"</a>
<li> <b>Previous message:</b> <a href="0398.html">Rik van Riel: "Re: [patch] my latest oom stuff"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
