<!-- received="Wed Nov  4 07:36:08 1998 EET" -->
<!-- sent="Wed, 4 Nov 1998 14:52:59 +1100" -->
<!-- name="Paul Mackerras" -->
<!-- email="paulus@cs.anu.edu.au" -->
<!-- subject="for comment: multi-keyboard patch" -->
<!-- id="199811040352.OAA06191@cargo.anu.edu.au" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: for comment: multi-keyboard patch</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>for comment: multi-keyboard patch</h1>
<b>Paul Mackerras</b> (<a href="mailto:paulus@cs.anu.edu.au"><i>paulus@cs.anu.edu.au</i></a>)<br>
<i>Wed, 4 Nov 1998 14:52:59 +1100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#389">[ date ]</a><a href="index.html#389">[ thread ]</a><a href="subject.html#389">[ subject ]</a><a href="author.html#389">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0390.html">Chip Salzenberg: "Patch for 2.1.127-pre6 and gcc 2.7.x"</a>
<li> <b>Previous message:</b> <a href="0388.html">Alex Buell: "New DoS via SAK?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0445.html">Alan Cox: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0445.html">Alan Cox: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0707.html">Pavel Machek: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0715.html">Pavel Machek: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0746.html">Paul Mackerras: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0809.html">Stephen Lee: "Re: for comment: multi-keyboard patch"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I'm working with Inaky Gonzalez on USB keyboard support.  The current<br>
keyboard driver in linux really only allows one keyboard, or at best<br>
one type of keyboard.  I have hacked the keyboard driver to allow<br>
multiple keyboards of different types (patch at the end of this<br>
message).  I have added register_keyboard() and unregister_keyboard()<br>
functions which are used to create new keyboard instances and specify<br>
sets of low-level keyboard operations to be used with them.<br>
<p>
I have also hacked the PC and mac low-level keyboard drivers to work<br>
with the new scheme.  Other low-level keyboard drivers should still<br>
work using some compatibility stuff I put in keyboard.c.<br>
<p>
At present input from all keyboards goes to the current foreground<br>
VC.  Ultimately it would be nice to be able to bind a keyboard, screen<br>
and mouse together into a "console" which would have its own set of<br>
VCs.<br>
<p>
Comments, anyone?<br>
<p>
Paul.<br>
<p>
<p>
diff -ur linux/Documentation/Configure.help linux-pmac/Documentation/Configure.help<br>
--- linux/Documentation/Configure.help	Tue Oct 27 16:32:16 1998<br>
+++ linux-pmac/Documentation/Configure.help	Wed Oct 28 15:32:07 1998<br>
@@ -9064,12 +9064,14 @@<br>
 Support for PowerMac keyboard<br>
 CONFIG_MAC_KEYBOARD<br>
   This option allows you to use an ADB keyboard attached to your<br>
-  machine. Note that this disables any other (ie. PS/2) keyboard<br>
-  support, even if your machine is physically capable of using both<br>
-  at the same time.<br>
-  <br>
-  If you use an ADB keyboard (4 pin connector), say Y here.<br>
-  If you use a PS/2 keyboard (6 pin connector), say N here.<br>
+  machine.  Say Y if you have a Power Macintosh or a CHRP machine<br>
+  with an ADB keyboard.<br>
+<br>
+Support for PC-style keyboard<br>
+CONFIG_PC_KEYBOARD<br>
+  This option allows you to use a PC-style or PS/2-style keyboard<br>
+  attached to your machine.  PReP and some CHRP machines have this<br>
+  style of keyboard; say Y if you have such a machine.<br>
 <br>
 Support for PowerMac floppy<br>
 CONFIG_MAC_FLOPPY<br>
diff -ur linux/arch/ppc/config.in linux-pmac/arch/ppc/config.in<br>
--- linux/arch/ppc/config.in	Tue Oct 20 11:07:47 1998<br>
+++ linux-pmac/arch/ppc/config.in	Sat Oct 24 18:11:24 1998<br>
@@ -61,6 +61,7 @@<br>
 tristate 'Kernel support for MISC binaries' CONFIG_BINFMT_MISC<br>
 tristate 'Kernel support for JAVA binaries (obsolete)' CONFIG_BINFMT_JAVA<br>
 <br>
+bool 'PC-style keyboard support' CONFIG_PC_KEYBOARD<br>
 tristate 'Parallel port support' CONFIG_PARPORT<br>
 if [ "$CONFIG_PARPORT" != "n" ]; then<br>
   dep_tristate '   PC-style hardware' CONFIG_PARPORT_PC $CONFIG_PARPORT<br>
diff -ur linux/drivers/char/Makefile linux-pmac/drivers/char/Makefile<br>
--- linux/drivers/char/Makefile	Tue Oct 27 16:44:51 1998<br>
+++ linux-pmac/drivers/char/Makefile	Tue Nov  3 15:49:37 1998<br>
@@ -42,7 +42,7 @@<br>
 <br>
 ifndef CONFIG_SUN_KEYBOARD<br>
 ifdef CONFIG_VT<br>
-L_OBJS += keyboard.o<br>
+LX_OBJS += keyboard.o<br>
 endif<br>
  ifneq ($(ARCH),m68k)<br>
   ifndef CONFIG_MBX<br>
@@ -51,7 +51,8 @@<br>
  endif<br>
 else<br>
 ifdef CONFIG_PCI<br>
-L_OBJS += defkeymap.o keyboard.o<br>
+L_OBJS += defkeymap.o<br>
+LX_OBJS += keyboard.o<br>
 endif<br>
 endif<br>
 <br>
diff -ur linux/drivers/char/keyboard.c linux-pmac/drivers/char/keyboard.c<br>
--- linux/drivers/char/keyboard.c	Thu Oct  1 22:36:47 1998<br>
+++ linux-pmac/drivers/char/keyboard.c	Tue Nov  3 15:48:30 1998<br>
@@ -31,6 +31,7 @@<br>
 #include &lt;linux/string.h&gt;<br>
 #include &lt;linux/random.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
+#include &lt;linux/malloc.h&gt;<br>
 <br>
 #include &lt;asm/keyboard.h&gt;<br>
 #include &lt;asm/bitops.h&gt;<br>
@@ -71,35 +72,56 @@<br>
 }<br>
 <br>
 /*<br>
- * global state includes the following, and various static variables<br>
- * in this module: prev_scancode, shift_state, diacr, npadch, dead_key_next.<br>
- * (last_console is now a global variable)<br>
+ * Per-keyboard state.<br>
+ * At present all keyboards are connected to the current fg_console -<br>
+ * this needs to be generalized a bit.<br>
  */<br>
+struct keyboard_state {<br>
+	struct keyboard_state *next;<br>
+	struct kbd_ll_operations *k_op;<br>
+	void		*devid;<br>
+	ushort		**key_maps;<br>
+	struct kbd_struct *kbd;<br>
+	struct tty_struct *tty;<br>
+	int		last_scancode;<br>
+	struct timer_list repeat_timer;<br>
+	int		repeat_timer_running;<br>
+	int		dead_key_next;<br>
+	int		shift_state;<br>
+	int		npadch;		/* -1 or number assembled on pad */<br>
+#ifdef CONFIG_MAGIC_SYSRQ<br>
+	int		sysrq_pressed;<br>
+#endif<br>
+	char		rep;		/* flag telling character repeat */<br>
+	unsigned char	diacr;<br>
+	unsigned char	k_down[NR_SHIFT];	/* shift state counters.. */<br>
+	unsigned long	key_down[256/BITS_PER_LONG]; /* keyboard key bitmap */<br>
+};<br>
 <br>
-/* shift state counters.. */<br>
-static unsigned char k_down[NR_SHIFT] = {0, };<br>
-/* keyboard key bitmap */<br>
-static unsigned long key_down[256/BITS_PER_LONG] = { 0, };<br>
+/*<br>
+ * List of all keyboards (and a spinlock for it).<br>
+ */<br>
+static struct keyboard_state *all_kbds;<br>
+static spinlock_t all_kbds_lock = SPIN_LOCK_UNLOCKED;<br>
 <br>
-static int dead_key_next = 0;<br>
 /* <br>
  * In order to retrieve the shift_state (for the mouse server), either<br>
  * the variable must be global, or a new procedure must be created to <br>
  * return the value. I chose the former way.<br>
+ * This now reflects the shift_state of the last keyboard<br>
+ * whose shift_state changed - paulus.<br>
  */<br>
 int shift_state = 0;<br>
-static int npadch = -1;			/* -1 or number assembled on pad */<br>
-static unsigned char diacr = 0;<br>
-static char rep = 0;			/* flag telling character repeat */<br>
+<br>
 struct kbd_struct kbd_table[MAX_NR_CONSOLES];<br>
 static struct tty_struct **ttytab;<br>
-static struct kbd_struct * kbd = kbd_table;<br>
-static struct tty_struct * tty = NULL;<br>
 <br>
-void compute_shiftstate(void);<br>
+void kbd_compute_shiftstate(struct keyboard_state *);<br>
 <br>
-typedef void (*k_hand)(unsigned char value, char up_flag);<br>
-typedef void (k_handfn)(unsigned char value, char up_flag);<br>
+typedef void (*k_hand)(struct keyboard_state *, unsigned char value,<br>
+		       char up_flag);<br>
+typedef void (k_handfn)(struct keyboard_state *, unsigned char value,<br>
+			char up_flag);<br>
 <br>
 static k_handfn<br>
 	do_self, do_fn, do_spec, do_pad, do_dead, do_cons, do_cur, do_shift,<br>
@@ -116,16 +138,17 @@<br>
 <br>
 #define TYPES_ALLOWED_IN_RAW_MODE ((1 &lt;&lt; KT_SPEC) | (1 &lt;&lt; KT_SHIFT))<br>
 <br>
-typedef void (*void_fnp)(void);<br>
-typedef void (void_fn)(void);<br>
+typedef void (*void_fnp)(struct keyboard_state *);<br>
+typedef void (void_fn)(struct keyboard_state *);<br>
 <br>
 static void_fn do_null, enter, show_ptregs, send_intr, lastcons, caps_toggle,<br>
 	num, hold, scroll_forw, scroll_back, boot_it, caps_on, compose,<br>
-	SAK, decr_console, incr_console, spawn_console, bare_num;<br>
+	SAK, decr_console, incr_console, spawn_console, bare_num,<br>
+	do_show_mem, do_show_state;<br>
 <br>
 static void_fnp spec_fn_table[] = {<br>
-	do_null,	enter,		show_ptregs,	show_mem,<br>
-	show_state,	send_intr,	lastcons,	caps_toggle,<br>
+	do_null,	enter,		show_ptregs,	do_show_mem,<br>
+	do_show_state,	send_intr,	lastcons,	caps_toggle,<br>
 	num,		hold,		scroll_forw,	scroll_back,<br>
 	boot_it,	caps_on,	compose,	SAK,<br>
 	decr_console,	incr_console,	spawn_console,	bare_num<br>
@@ -143,33 +166,28 @@<br>
 <br>
 const int NR_TYPES = SIZE(max_vals);<br>
 <br>
-/* N.B. drivers/macintosh/mac_keyb.c needs to call put_queue */<br>
-void put_queue(int);<br>
-static unsigned char handle_diacr(unsigned char);<br>
+static void put_queue(struct tty_struct *, int);<br>
+static unsigned char handle_diacr(struct keyboard_state *, unsigned char);<br>
 <br>
 /* kbd_pt_regs - set by keyboard_interrupt(), used by show_ptregs() */<br>
 struct pt_regs * kbd_pt_regs;<br>
 <br>
-#ifdef CONFIG_MAGIC_SYSRQ<br>
-static int sysrq_pressed;<br>
-#endif<br>
-<br>
 /*<br>
  * Many other routines do put_queue, but I think either<br>
  * they produce ASCII, or they produce some user-assigned<br>
  * string, and in both cases we might assume that it is<br>
  * in utf-8 already.<br>
  */<br>
-void to_utf8(ushort c) {<br>
+void to_utf8(struct tty_struct *tty, ushort c) {<br>
     if (c &lt; 0x80)<br>
-	put_queue(c);			/*  0*******  */<br>
+	put_queue(tty, c);			/*  0*******  */<br>
     else if (c &lt; 0x800) {<br>
-	put_queue(0xc0 | (c &gt;&gt; 6)); 	/*  110***** 10******  */<br>
-	put_queue(0x80 | (c &amp; 0x3f));<br>
+	put_queue(tty, 0xc0 | (c &gt;&gt; 6)); 	/*  110***** 10******  */<br>
+	put_queue(tty, 0x80 | (c &amp; 0x3f));<br>
     } else {<br>
-	put_queue(0xe0 | (c &gt;&gt; 12)); 	/*  1110**** 10****** 10******  */<br>
-	put_queue(0x80 | ((c &gt;&gt; 6) &amp; 0x3f));<br>
-	put_queue(0x80 | (c &amp; 0x3f));<br>
+	put_queue(tty, 0xe0 | (c &gt;&gt; 12)); 	/*  1110**** 10****** 10******  */<br>
+	put_queue(tty, 0x80 | ((c &gt;&gt; 6) &amp; 0x3f));<br>
+	put_queue(tty, 0x80 | (c &amp; 0x3f));<br>
     }<br>
     /* UTF-8 is defined for words of up to 31 bits,<br>
        but we need only 16 bits here */<br>
@@ -178,76 +196,123 @@<br>
 /*<br>
  * Translation of escaped scancodes to keycodes.<br>
  * This is now user-settable (for machines were it makes sense).<br>
+ * (XXX It doesn't make much sense with multiple keyboards :-()<br>
  */<br>
 <br>
 int setkeycode(unsigned int scancode, unsigned int keycode)<br>
 {<br>
-    return kbd_setkeycode(scancode, keycode);<br>
+	struct keyboard_state *ks;<br>
+	int err = 0;<br>
+<br>
+	spin_lock(&amp;all_kbds_lock);<br>
+	for (ks = all_kbds; ks != NULL &amp;&amp; err == 0; ks = ks-&gt;next)<br>
+		if (ks-&gt;key_maps == key_maps)<br>
+			err = ks-&gt;k_op-&gt;setkeycode(ks-&gt;devid, scancode, keycode);<br>
+	spin_unlock(&amp;all_kbds_lock);<br>
+	return err;<br>
 }<br>
 <br>
+/* XXX and this makes even less sense... :-* */<br>
 int getkeycode(unsigned int scancode)<br>
 {<br>
-    return kbd_getkeycode(scancode);<br>
+	struct keyboard_state *ks = all_kbds;<br>
+<br>
+	if (ks == NULL)<br>
+		return -ENODEV;<br>
+	return ks-&gt;k_op-&gt;getkeycode(ks-&gt;devid, scancode);<br>
 }<br>
 <br>
-void handle_scancode(unsigned char scancode)<br>
+static void kbd_repeat(unsigned long devid)<br>
+{<br>
+	struct keyboard_state *ks = (struct keyboard_state *) devid;<br>
+	unsigned long flags;<br>
+<br>
+	save_flags(flags);<br>
+	cli();<br>
+	ks-&gt;repeat_timer_running = 0;<br>
+	kbd_handle_scancode((void *)ks, ks-&gt;last_scancode);<br>
+	restore_flags(flags);<br>
+}<br>
+<br>
+void kbd_handle_scancode(void *kbdid, int scancode)<br>
 {<br>
+	struct keyboard_state *ks = (struct keyboard_state *) kbdid;<br>
 	unsigned char keycode;<br>
 	char up_flag;				 /* 0 or 0200 */<br>
-	char raw_mode;<br>
+	char raw_mode, rep;<br>
+	struct kbd_struct *kbd;<br>
+	struct tty_struct *tty;<br>
 <br>
 	do_poke_blanked_console = 1;<br>
 	mark_bh(CONSOLE_BH);<br>
 	add_keyboard_randomness(scancode);<br>
 <br>
-	tty = ttytab? ttytab[fg_console]: NULL;<br>
- 	kbd = kbd_table + fg_console;<br>
+	if (ks-&gt;repeat_timer_running) {<br>
+		del_timer(&amp;ks-&gt;repeat_timer);<br>
+		ks-&gt;repeat_timer_running = 0;<br>
+	}<br>
+<br>
+	ks-&gt;tty = tty = ttytab? ttytab[fg_console]: NULL;<br>
+	ks-&gt;kbd = kbd = kbd_table + fg_console;<br>
 	if ((raw_mode = (kbd-&gt;kbdmode == VC_RAW))) {<br>
- 		put_queue(scancode);<br>
+ 		put_queue(tty, scancode);<br>
 		/* we do not return yet, because we want to maintain<br>
 		   the key_down array, so that we have the correct<br>
 		   values when finishing RAW mode or when changing VT's */<br>
  	}<br>
 <br>
-	if (!kbd_pretranslate(scancode, raw_mode))<br>
-	    return;<br>
+	if (!ks-&gt;k_op-&gt;pretranslate(ks-&gt;devid, scancode, raw_mode))<br>
+		return;<br>
+<br>
  	/*<br>
 	 *  Convert scancode to keycode<br>
  	 */<br>
 	up_flag = (scancode &amp; 0200);<br>
  	scancode &amp;= 0x7f;<br>
 <br>
-	if (!kbd_translate(scancode, &amp;keycode, raw_mode))<br>
-	    return;<br>
+	if (!ks-&gt;k_op-&gt;translate(ks-&gt;devid, scancode, &amp;keycode, raw_mode))<br>
+		return;<br>
 <br>
 	/*<br>
 	 * At this point the variable `keycode' contains the keycode.<br>
-	 * Note: the keycode must not be 0 (++Geert: on m68k 0 is valid).<br>
 	 * We keep track of the up/down status of the key, and<br>
 	 * return the keycode if in MEDIUMRAW mode.<br>
 	 */<br>
 <br>
 	if (up_flag) {<br>
 		rep = 0;<br>
- 		if(!test_and_clear_bit(keycode, key_down))<br>
-		    up_flag = kbd_unexpected_up(keycode);<br>
+ 		if (!test_and_clear_bit(keycode, ks-&gt;key_down))<br>
+			up_flag = ks-&gt;k_op-&gt;unexpected_up(ks-&gt;devid, keycode);<br>
 	} else<br>
- 		rep = test_and_set_bit(keycode, key_down);<br>
+ 		rep = test_and_set_bit(keycode, ks-&gt;key_down);<br>
+	ks-&gt;rep = rep;<br>
+<br>
+	if (!raw_mode &amp;&amp; !up_flag<br>
+	    &amp;&amp; ks-&gt;k_op-&gt;dont_repeat &amp;&amp; !ks-&gt;k_op-&gt;dont_repeat[keycode]) {<br>
+		ks-&gt;last_scancode = scancode;<br>
+		ks-&gt;repeat_timer.function = kbd_repeat;<br>
+		ks-&gt;repeat_timer.data = (unsigned long) ks;<br>
+		ks-&gt;repeat_timer.expires = jiffies +<br>
+		    (rep? ks-&gt;k_op-&gt;repeat_delay: ks-&gt;k_op-&gt;repeat_initial);<br>
+		add_timer(&amp;ks-&gt;repeat_timer);<br>
+		ks-&gt;repeat_timer_running = 1;<br>
+	}<br>
 <br>
 #ifdef CONFIG_MAGIC_SYSRQ		/* Handle the SysRq Hack */<br>
-	if (keycode == SYSRQ_KEY) {<br>
-		sysrq_pressed = !up_flag;<br>
+	if (keycode == ks-&gt;k_op-&gt;sysrq_key) {<br>
+		ks-&gt;sysrq_pressed = !up_flag;<br>
 		return;<br>
-	} else if (sysrq_pressed) {<br>
+	} else if (ks-&gt;sysrq_pressed) {<br>
 		if (!up_flag)<br>
-			handle_sysrq(kbd_sysrq_xlate[keycode], kbd_pt_regs, kbd, tty);<br>
+			handle_sysrq(ks-&gt;k_op-&gt;sysrq_xlate[keycode],<br>
+				     kbd_pt_regs, kbd, tty);<br>
 		return;<br>
 	}<br>
 #endif<br>
 <br>
 	if (kbd-&gt;kbdmode == VC_MEDIUMRAW) {<br>
 		/* soon keycodes will require more than one byte */<br>
- 		put_queue(keycode + up_flag);<br>
+ 		put_queue(tty, keycode + up_flag);<br>
 		raw_mode = 1;	/* Most key classes will be ignored */<br>
  	}<br>
 <br>
@@ -271,8 +336,8 @@<br>
 		u_char type;<br>
 <br>
 		/* the XOR below used to be an OR */<br>
-		int shift_final = shift_state ^ kbd-&gt;lockstate ^ kbd-&gt;slockstate;<br>
-		ushort *key_map = key_maps[shift_final];<br>
+		int shift_final = ks-&gt;shift_state ^ kbd-&gt;lockstate ^ kbd-&gt;slockstate;<br>
+		ushort *key_map = ks-&gt;key_maps[shift_final];<br>
 <br>
 		if (key_map != NULL) {<br>
 			keysym = key_map[keycode];<br>
@@ -285,36 +350,36 @@<br>
 			    if (type == KT_LETTER) {<br>
 				type = KT_LATIN;<br>
 				if (vc_kbd_led(kbd, VC_CAPSLOCK)) {<br>
-				    key_map = key_maps[shift_final ^ (1&lt;&lt;KG_SHIFT)];<br>
+				    key_map = ks-&gt;key_maps[shift_final ^ (1&lt;&lt;KG_SHIFT)];<br>
 				    if (key_map)<br>
 				      keysym = key_map[keycode];<br>
 				}<br>
 			    }<br>
-			    (*key_handler[type])(keysym &amp; 0xff, up_flag);<br>
+			    (*key_handler[type])(ks, keysym &amp; 0xff, up_flag);<br>
 			    if (type != KT_SLOCK)<br>
 			      kbd-&gt;slockstate = 0;<br>
 			} else {<br>
 			    /* maybe only if (kbd-&gt;kbdmode == VC_UNICODE) ? */<br>
 			    if (!up_flag &amp;&amp; !raw_mode)<br>
-			      to_utf8(keysym);<br>
+			      to_utf8(tty, keysym);<br>
 			}<br>
 		} else {<br>
 			/* maybe beep? */<br>
 			/* we have at least to update shift_state */<br>
 #if 1			/* how? two almost equivalent choices follow */<br>
-			compute_shiftstate();<br>
+			kbd_compute_shiftstate(ks);<br>
 #else<br>
-			keysym = U(plain_map[keycode]);<br>
+			keysym = U(ks-&gt;key_maps[0][keycode]);<br>
 			type = KTYP(keysym);<br>
 			if (type == KT_SHIFT)<br>
-			  (*key_handler[type])(keysym &amp; 0xff, up_flag);<br>
+			  (*key_handler[type])(ks, keysym &amp; 0xff, up_flag);<br>
 #endif<br>
 		}<br>
 	}<br>
 }<br>
 <br>
 <br>
-void put_queue(int ch)<br>
+static void put_queue(struct tty_struct *tty, int ch)<br>
 {<br>
 	wake_up(&amp;keypress_wait);<br>
 	if (tty) {<br>
@@ -323,7 +388,7 @@<br>
 	}<br>
 }<br>
 <br>
-static void puts_queue(char *cp)<br>
+static void puts_queue(struct tty_struct *tty, char *cp)<br>
 {<br>
 	wake_up(&amp;keypress_wait);<br>
 	if (!tty)<br>
@@ -336,49 +401,61 @@<br>
 	con_schedule_flip(tty);<br>
 }<br>
 <br>
-static void applkey(int key, char mode)<br>
+static void applkey(struct tty_struct *tty, int key, char mode)<br>
 {<br>
 	static char buf[] = { 0x1b, 'O', 0x00, 0x00 };<br>
 <br>
 	buf[1] = (mode ? 'O' : '[');<br>
 	buf[2] = key;<br>
-	puts_queue(buf);<br>
+	puts_queue(tty, buf);<br>
 }<br>
 <br>
-static void enter(void)<br>
+static void enter(struct keyboard_state *ks)<br>
 {<br>
-	if (diacr) {<br>
-		put_queue(diacr);<br>
-		diacr = 0;<br>
+	if (ks-&gt;diacr) {<br>
+		put_queue(ks-&gt;tty, ks-&gt;diacr);<br>
+		ks-&gt;diacr = 0;<br>
 	}<br>
-	put_queue(13);<br>
-	if (vc_kbd_mode(kbd,VC_CRLF))<br>
-		put_queue(10);<br>
+	put_queue(ks-&gt;tty, 13);<br>
+	if (vc_kbd_mode(ks-&gt;kbd, VC_CRLF))<br>
+		put_queue(ks-&gt;tty, 10);<br>
 }<br>
 <br>
-static void caps_toggle(void)<br>
+static void caps_toggle(struct keyboard_state *ks)<br>
 {<br>
-	if (rep)<br>
+	if (ks-&gt;rep)<br>
 		return;<br>
-	chg_vc_kbd_led(kbd, VC_CAPSLOCK);<br>
+	chg_vc_kbd_led(ks-&gt;kbd, VC_CAPSLOCK);<br>
 }<br>
 <br>
-static void caps_on(void)<br>
+static void caps_on(struct keyboard_state *ks)<br>
 {<br>
-	if (rep)<br>
+	if (ks-&gt;rep)<br>
 		return;<br>
-	set_vc_kbd_led(kbd, VC_CAPSLOCK);<br>
+	set_vc_kbd_led(ks-&gt;kbd, VC_CAPSLOCK);<br>
 }<br>
 <br>
-static void show_ptregs(void)<br>
+static void show_ptregs(struct keyboard_state *ks)<br>
 {<br>
 	if (kbd_pt_regs)<br>
 		show_regs(kbd_pt_regs);<br>
 }<br>
 <br>
-static void hold(void)<br>
+static void do_show_mem(struct keyboard_state *ks)<br>
+{<br>
+	show_mem();<br>
+}<br>
+<br>
+static void do_show_state(struct keyboard_state *ks)<br>
 {<br>
-	if (rep || !tty)<br>
+	show_state();<br>
+}<br>
+<br>
+static void hold(struct keyboard_state *ks)<br>
+{<br>
+	struct tty_struct *tty = ks-&gt;tty;<br>
+<br>
+	if (ks-&gt;rep || !tty)<br>
 		return;<br>
 <br>
 	/*<br>
@@ -392,12 +469,12 @@<br>
 		stop_tty(tty);<br>
 }<br>
 <br>
-static void num(void)<br>
+static void num(struct keyboard_state *ks)<br>
 {<br>
-	if (vc_kbd_mode(kbd,VC_APPLIC))<br>
-		applkey('P', 1);<br>
+	if (vc_kbd_mode(ks-&gt;kbd, VC_APPLIC))<br>
+		applkey(ks-&gt;tty, 'P', 1);<br>
 	else<br>
-		bare_num();<br>
+		bare_num(ks);<br>
 }<br>
 <br>
 /*<br>
@@ -406,19 +483,19 @@<br>
  * Bind this to NumLock if you prefer that the NumLock key always<br>
  * changes the NumLock flag.<br>
  */<br>
-static void bare_num(void)<br>
+static void bare_num(struct keyboard_state *ks)<br>
 {<br>
-	if (!rep)<br>
-		chg_vc_kbd_led(kbd,VC_NUMLOCK);<br>
+	if (!ks-&gt;rep)<br>
+		chg_vc_kbd_led(ks-&gt;kbd, VC_NUMLOCK);<br>
 }<br>
 <br>
-static void lastcons(void)<br>
+static void lastcons(struct keyboard_state *ks)<br>
 {<br>
 	/* switch to the last used console, ChN */<br>
 	set_console(last_console);<br>
 }<br>
 <br>
-static void decr_console(void)<br>
+static void decr_console(struct keyboard_state *ks)<br>
 {<br>
 	int i;<br>
  <br>
@@ -431,7 +508,7 @@<br>
 	set_console(i);<br>
 }<br>
 <br>
-static void incr_console(void)<br>
+static void incr_console(struct keyboard_state *ks)<br>
 {<br>
 	int i;<br>
 <br>
@@ -444,45 +521,49 @@<br>
 	set_console(i);<br>
 }<br>
 <br>
-static void send_intr(void)<br>
+static void send_intr(struct keyboard_state *ks)<br>
 {<br>
+	struct tty_struct *tty = ks-&gt;tty;<br>
+<br>
 	if (!tty)<br>
 		return;<br>
 	tty_insert_flip_char(tty, 0, TTY_BREAK);<br>
 	con_schedule_flip(tty);<br>
 }<br>
 <br>
-static void scroll_forw(void)<br>
+static void scroll_forw(struct keyboard_state *ks)<br>
 {<br>
 	scrollfront(0);<br>
 }<br>
 <br>
-static void scroll_back(void)<br>
+static void scroll_back(struct keyboard_state *ks)<br>
 {<br>
 	scrollback(0);<br>
 }<br>
 <br>
-static void boot_it(void)<br>
+static void boot_it(struct keyboard_state *ks)<br>
 {<br>
 	ctrl_alt_del();<br>
 }<br>
 <br>
-static void compose(void)<br>
+static void compose(struct keyboard_state *ks)<br>
 {<br>
-	dead_key_next = 1;<br>
+	ks-&gt;dead_key_next = 1;<br>
 }<br>
 <br>
 int spawnpid, spawnsig;<br>
 <br>
-static void spawn_console(void)<br>
+static void spawn_console(struct keyboard_state *ks)<br>
 {<br>
         if (spawnpid)<br>
 	   if(kill_proc(spawnpid, spawnsig, 1))<br>
 	     spawnpid = 0;<br>
 }<br>
 <br>
-static void SAK(void)<br>
+static void SAK(struct keyboard_state *ks)<br>
 {<br>
+	struct tty_struct *tty = ks-&gt;tty;<br>
+<br>
 	/*<br>
 	 * SAK should also work in all raw modes and reset<br>
 	 * them properly.<br>
@@ -495,17 +576,19 @@<br>
 #endif<br>
 }<br>
 <br>
-static void do_ignore(unsigned char value, char up_flag)<br>
+static void do_ignore(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 }<br>
 <br>
-static void do_null()<br>
+static void do_null(struct keyboard_state *ks)<br>
 {<br>
-	compute_shiftstate();<br>
+	kbd_compute_shiftstate(ks);<br>
 }<br>
 <br>
-static void do_spec(unsigned char value, char up_flag)<br>
+static void do_spec(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
+	struct kbd_struct *kbd = ks-&gt;kbd;<br>
+<br>
 	if (up_flag)<br>
 		return;<br>
 	if (value &gt;= SIZE(spec_fn_table))<br>
@@ -513,29 +596,29 @@<br>
 	if ((kbd-&gt;kbdmode == VC_RAW || kbd-&gt;kbdmode == VC_MEDIUMRAW) &amp;&amp;<br>
 	    !(SPECIALS_ALLOWED_IN_RAW_MODE &amp; (1 &lt;&lt; value)))<br>
 		return;<br>
-	spec_fn_table[value]();<br>
+	spec_fn_table[value](ks);<br>
 }<br>
 <br>
-static void do_lowercase(unsigned char value, char up_flag)<br>
+static void do_lowercase(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	printk(KERN_ERR "keyboard.c: do_lowercase was called - impossible\n");<br>
 }<br>
 <br>
-static void do_self(unsigned char value, char up_flag)<br>
+static void do_self(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	if (up_flag)<br>
 		return;		/* no action, if this is a key release */<br>
 <br>
-	if (diacr)<br>
-		value = handle_diacr(value);<br>
+	if (ks-&gt;diacr)<br>
+		value = handle_diacr(ks, value);<br>
 <br>
-	if (dead_key_next) {<br>
-		dead_key_next = 0;<br>
-		diacr = value;<br>
+	if (ks-&gt;dead_key_next) {<br>
+		ks-&gt;dead_key_next = 0;<br>
+		ks-&gt;diacr = value;<br>
 		return;<br>
 	}<br>
 <br>
-	put_queue(value);<br>
+	put_queue(ks-&gt;tty, value);<br>
 }<br>
 <br>
 #define A_GRAVE  '`'<br>
@@ -548,10 +631,10 @@<br>
 	{A_GRAVE, A_ACUTE, A_CFLEX, A_TILDE, A_DIAER, A_CEDIL };<br>
 <br>
 /* Obsolete - for backwards compatibility only */<br>
-static void do_dead(unsigned char value, char up_flag)<br>
+static void do_dead(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	value = ret_diacr[value];<br>
-	do_dead2(value,up_flag);<br>
+	do_dead2(ks, value, up_flag);<br>
 }<br>
 <br>
 /*<br>
@@ -559,12 +642,12 @@<br>
  * dead keys modifying the same character. Very useful<br>
  * for Vietnamese.<br>
  */<br>
-static void do_dead2(unsigned char value, char up_flag)<br>
+static void do_dead2(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	if (up_flag)<br>
 		return;<br>
 <br>
-	diacr = (diacr ? handle_diacr(value) : value);<br>
+	ks-&gt;diacr = (ks-&gt;diacr ? handle_diacr(ks, value) : value);<br>
 }<br>
 <br>
 <br>
@@ -575,12 +658,12 @@<br>
  * Otherwise, conclude that DIACR was not combining after all,<br>
  * queue it and return CH.<br>
  */<br>
-unsigned char handle_diacr(unsigned char ch)<br>
+unsigned char handle_diacr(struct keyboard_state *ks, unsigned char ch)<br>
 {<br>
-	int d = diacr;<br>
+	int d = ks-&gt;diacr;<br>
 	int i;<br>
 <br>
-	diacr = 0;<br>
+	ks-&gt;diacr = 0;<br>
 <br>
 	for (i = 0; i &lt; accent_table_size; i++) {<br>
 		if (accent_table[i].diacr == d &amp;&amp; accent_table[i].base == ch)<br>
@@ -590,30 +673,31 @@<br>
 	if (ch == ' ' || ch == d)<br>
 		return d;<br>
 <br>
-	put_queue(d);<br>
+	put_queue(ks-&gt;tty, d);<br>
 	return ch;<br>
 }<br>
 <br>
-static void do_cons(unsigned char value, char up_flag)<br>
+static void do_cons(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	if (up_flag)<br>
 		return;<br>
 	set_console(value);<br>
 }<br>
 <br>
-static void do_fn(unsigned char value, char up_flag)<br>
+static void do_fn(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	if (up_flag)<br>
 		return;<br>
 	if (value &lt; SIZE(func_table)) {<br>
 		if (func_table[value])<br>
-			puts_queue(func_table[value]);<br>
+			puts_queue(ks-&gt;tty, func_table[value]);<br>
 	} else<br>
 		printk(KERN_ERR "do_fn called with value=%d\n", value);<br>
 }<br>
 <br>
-static void do_pad(unsigned char value, char up_flag)<br>
+static void do_pad(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
+	struct kbd_struct *kbd = ks-&gt;kbd;<br>
 	static const char *pad_chars = "0123456789+-*/\015,.?()";<br>
 	static const char *app_map = "pqrstuvwxylSRQMnnmPQ";<br>
 <br>
@@ -621,8 +705,8 @@<br>
 		return;		/* no action, if this is a key release */<br>
 <br>
 	/* kludge... shift forces cursor/number keys */<br>
-	if (vc_kbd_mode(kbd,VC_APPLIC) &amp;&amp; !k_down[KG_SHIFT]) {<br>
-		applkey(app_map[value], 1);<br>
+	if (vc_kbd_mode(kbd,VC_APPLIC) &amp;&amp; !ks-&gt;k_down[KG_SHIFT]) {<br>
+		applkey(ks-&gt;tty, app_map[value], 1);<br>
 		return;<br>
 	}<br>
 <br>
@@ -630,59 +714,60 @@<br>
 		switch (value) {<br>
 			case KVAL(K_PCOMMA):<br>
 			case KVAL(K_PDOT):<br>
-				do_fn(KVAL(K_REMOVE), 0);<br>
+				do_fn(ks, KVAL(K_REMOVE), 0);<br>
 				return;<br>
 			case KVAL(K_P0):<br>
-				do_fn(KVAL(K_INSERT), 0);<br>
+				do_fn(ks, KVAL(K_INSERT), 0);<br>
 				return;<br>
 			case KVAL(K_P1):<br>
-				do_fn(KVAL(K_SELECT), 0);<br>
+				do_fn(ks, KVAL(K_SELECT), 0);<br>
 				return;<br>
 			case KVAL(K_P2):<br>
-				do_cur(KVAL(K_DOWN), 0);<br>
+				do_cur(ks, KVAL(K_DOWN), 0);<br>
 				return;<br>
 			case KVAL(K_P3):<br>
-				do_fn(KVAL(K_PGDN), 0);<br>
+				do_fn(ks, KVAL(K_PGDN), 0);<br>
 				return;<br>
 			case KVAL(K_P4):<br>
-				do_cur(KVAL(K_LEFT), 0);<br>
+				do_cur(ks, KVAL(K_LEFT), 0);<br>
 				return;<br>
 			case KVAL(K_P6):<br>
-				do_cur(KVAL(K_RIGHT), 0);<br>
+				do_cur(ks, KVAL(K_RIGHT), 0);<br>
 				return;<br>
 			case KVAL(K_P7):<br>
-				do_fn(KVAL(K_FIND), 0);<br>
+				do_fn(ks, KVAL(K_FIND), 0);<br>
 				return;<br>
 			case KVAL(K_P8):<br>
-				do_cur(KVAL(K_UP), 0);<br>
+				do_cur(ks, KVAL(K_UP), 0);<br>
 				return;<br>
 			case KVAL(K_P9):<br>
-				do_fn(KVAL(K_PGUP), 0);<br>
+				do_fn(ks, KVAL(K_PGUP), 0);<br>
 				return;<br>
 			case KVAL(K_P5):<br>
-				applkey('G', vc_kbd_mode(kbd, VC_APPLIC));<br>
+				applkey(ks-&gt;tty, 'G', vc_kbd_mode(kbd, VC_APPLIC));<br>
 				return;<br>
 		}<br>
 <br>
-	put_queue(pad_chars[value]);<br>
+	put_queue(ks-&gt;tty, pad_chars[value]);<br>
 	if (value == KVAL(K_PENTER) &amp;&amp; vc_kbd_mode(kbd, VC_CRLF))<br>
-		put_queue(10);<br>
+		put_queue(ks-&gt;tty, 10);<br>
 }<br>
 <br>
-static void do_cur(unsigned char value, char up_flag)<br>
+static void do_cur(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	static const char *cur_chars = "BDCA";<br>
 	if (up_flag)<br>
 		return;<br>
 <br>
-	applkey(cur_chars[value], vc_kbd_mode(kbd,VC_CKMODE));<br>
+	applkey(ks-&gt;tty, cur_chars[value], vc_kbd_mode(ks-&gt;kbd,VC_CKMODE));<br>
 }<br>
 <br>
-static void do_shift(unsigned char value, char up_flag)<br>
+static void do_shift(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
-	int old_state = shift_state;<br>
+	struct kbd_struct *kbd = ks-&gt;kbd;<br>
+	int old_state = ks-&gt;shift_state;<br>
 <br>
-	if (rep)<br>
+	if (ks-&gt;rep)<br>
 		return;<br>
 <br>
 	/* Mimic typewriter:<br>
@@ -696,23 +781,23 @@<br>
 	if (up_flag) {<br>
 		/* handle the case that two shift or control<br>
 		   keys are depressed simultaneously */<br>
-		if (k_down[value])<br>
-			k_down[value]--;<br>
+		if (ks-&gt;k_down[value])<br>
+			ks-&gt;k_down[value]--;<br>
 	} else<br>
-		k_down[value]++;<br>
+		ks-&gt;k_down[value]++;<br>
 <br>
-	if (k_down[value])<br>
-		shift_state |= (1 &lt;&lt; value);<br>
+	if (ks-&gt;k_down[value])<br>
+		ks-&gt;shift_state |= (1 &lt;&lt; value);<br>
 	else<br>
-		shift_state &amp;= ~ (1 &lt;&lt; value);<br>
+		ks-&gt;shift_state &amp;= ~ (1 &lt;&lt; value);<br>
 <br>
 	/* kludge */<br>
-	if (up_flag &amp;&amp; shift_state != old_state &amp;&amp; npadch != -1) {<br>
+	if (up_flag &amp;&amp; ks-&gt;shift_state != old_state &amp;&amp; ks-&gt;npadch != -1) {<br>
 		if (kbd-&gt;kbdmode == VC_UNICODE)<br>
-		  to_utf8(npadch &amp; 0xffff);<br>
+			to_utf8(ks-&gt;tty, ks-&gt;npadch &amp; 0xffff);<br>
 		else<br>
-		  put_queue(npadch &amp; 0xff);<br>
-		npadch = -1;<br>
+			put_queue(ks-&gt;tty, ks-&gt;npadch &amp; 0xff);<br>
+		ks-&gt;npadch = -1;<br>
 	}<br>
 }<br>
 <br>
@@ -721,42 +806,55 @@<br>
 /* maybe called when keymap is undefined, so that shiftkey release is seen */<br>
 void compute_shiftstate(void)<br>
 {<br>
+	struct keyboard_state *ks;<br>
+<br>
+	spin_lock(&amp;all_kbds_lock);<br>
+	for (ks = all_kbds; ks != NULL; ks = ks-&gt;next)<br>
+		kbd_compute_shiftstate(ks);<br>
+	spin_unlock(&amp;all_kbds_lock);<br>
+}<br>
+<br>
+void kbd_compute_shiftstate(struct keyboard_state *ks)<br>
+{<br>
 	int i, j, k, sym, val;<br>
 <br>
-	shift_state = 0;<br>
-	for(i=0; i &lt; SIZE(k_down); i++)<br>
-	  k_down[i] = 0;<br>
-<br>
-	for(i=0; i &lt; SIZE(key_down); i++)<br>
-	  if(key_down[i]) {	/* skip this word if not a single bit on */<br>
-	    k = i*BITS_PER_LONG;<br>
-	    for(j=0; j&lt;BITS_PER_LONG; j++,k++)<br>
-	      if(test_bit(k, key_down)) {<br>
-		sym = U(plain_map[k]);<br>
-		if(KTYP(sym) == KT_SHIFT) {<br>
-		  val = KVAL(sym);<br>
-		  if (val == KVAL(K_CAPSSHIFT))<br>
-		    val = KVAL(K_SHIFT);<br>
-		  k_down[val]++;<br>
-		  shift_state |= (1&lt;&lt;val);<br>
+	ks-&gt;shift_state = 0;<br>
+	for (i = 0; i &lt; SIZE(ks-&gt;k_down); i++)<br>
+		ks-&gt;k_down[i] = 0;<br>
+<br>
+	for (i = 0; i &lt; SIZE(ks-&gt;key_down); i++) {<br>
+		if (ks-&gt;key_down[i] == 0)<br>
+			continue; /* skip this word if not a single bit on */<br>
+		k = i * BITS_PER_LONG;<br>
+		for (j = 0; j &lt; BITS_PER_LONG; j++, k++) {<br>
+			if (test_bit(k, ks-&gt;key_down) == 0)<br>
+				continue;<br>
+			sym = U(ks-&gt;key_maps[0][k]);<br>
+			if (KTYP(sym) == KT_SHIFT) {<br>
+				val = KVAL(sym);<br>
+				if (val == KVAL(K_CAPSSHIFT))<br>
+					val = KVAL(K_SHIFT);<br>
+				ks-&gt;k_down[val]++;<br>
+				ks-&gt;shift_state |= (1&lt;&lt;val);<br>
+			}<br>
 		}<br>
-	      }<br>
-	  }<br>
+	}<br>
+	shift_state = ks-&gt;shift_state;	/* XXX */<br>
 }<br>
 <br>
-static void do_meta(unsigned char value, char up_flag)<br>
+static void do_meta(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	if (up_flag)<br>
 		return;<br>
 <br>
-	if (vc_kbd_mode(kbd, VC_META)) {<br>
-		put_queue('\033');<br>
-		put_queue(value);<br>
+	if (vc_kbd_mode(ks-&gt;kbd, VC_META)) {<br>
+		put_queue(ks-&gt;tty, '\033');<br>
+		put_queue(ks-&gt;tty, value);<br>
 	} else<br>
-		put_queue(value | 0x80);<br>
+		put_queue(ks-&gt;tty, value | 0x80);<br>
 }<br>
 <br>
-static void do_ascii(unsigned char value, char up_flag)<br>
+static void do_ascii(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
 	int base;<br>
 <br>
@@ -764,30 +862,30 @@<br>
 		return;<br>
 <br>
 	if (value &lt; 10)    /* decimal input of code, while Alt depressed */<br>
-	    base = 10;<br>
+		base = 10;<br>
 	else {       /* hexadecimal input of code, while AltGr depressed */<br>
-	    value -= 10;<br>
-	    base = 16;<br>
+		value -= 10;<br>
+		base = 16;<br>
 	}<br>
 <br>
-	if (npadch == -1)<br>
-	  npadch = value;<br>
+	if (ks-&gt;npadch == -1)<br>
+		ks-&gt;npadch = value;<br>
 	else<br>
-	  npadch = npadch * base + value;<br>
+		ks-&gt;npadch = ks-&gt;npadch * base + value;<br>
 }<br>
 <br>
-static void do_lock(unsigned char value, char up_flag)<br>
+static void do_lock(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
-	if (up_flag || rep)<br>
+	if (up_flag || ks-&gt;rep)<br>
 		return;<br>
-	chg_vc_kbd_lock(kbd, value);<br>
+	chg_vc_kbd_lock(ks-&gt;kbd, value);<br>
 }<br>
 <br>
-static void do_slock(unsigned char value, char up_flag)<br>
+static void do_slock(struct keyboard_state *ks, unsigned char value, char up_flag)<br>
 {<br>
-	if (up_flag || rep)<br>
+	if (up_flag || ks-&gt;rep)<br>
 		return;<br>
-	chg_vc_kbd_slock(kbd, value);<br>
+	chg_vc_kbd_slock(ks-&gt;kbd, value);<br>
 }<br>
 <br>
 /*<br>
@@ -799,8 +897,8 @@<br>
 static unsigned char ledstate = 0xff; /* undefined */<br>
 static unsigned char ledioctl;<br>
 <br>
-unsigned char getledstate(void) {<br>
-    return ledstate;<br>
+unsigned char getledstate() {<br>
+	return ledstate;<br>
 }<br>
 <br>
 void setledstate(struct kbd_struct *kbd, unsigned int led) {<br>
@@ -876,13 +974,74 @@<br>
 static void kbd_bh(void)<br>
 {<br>
 	unsigned char leds = getleds();<br>
+	struct keyboard_state *ks;<br>
 <br>
 	if (leds != ledstate) {<br>
 		ledstate = leds;<br>
-		kbd_leds(leds);<br>
+		spin_lock(&amp;all_kbds_lock);<br>
+		for (ks = all_kbds; ks != NULL; ks = ks-&gt;next)<br>
+			ks-&gt;k_op-&gt;leds(ks, leds);<br>
+		spin_unlock(&amp;all_kbds_lock);<br>
 	}<br>
 }<br>
 <br>
+#ifndef NEW_STYLE_KEYBOARD<br>
+int oldkbd_setkeycode(void *devid, unsigned int scancode, unsigned int keycode)<br>
+{<br>
+	return kbd_setkeycode(scancode, keycode);<br>
+}<br>
+<br>
+int oldkbd_getkeycode(void *devid, unsigned int scancode)<br>
+{<br>
+	return kbd_getkeycode(scancode);<br>
+}<br>
+<br>
+int oldkbd_pretranslate(void *devid, unsigned char scancode, char raw_mode)<br>
+{<br>
+	return kbd_pretranslate(scancode, raw_mode);<br>
+}<br>
+<br>
+int oldkbd_translate(void *devid, unsigned char scancode,<br>
+		     unsigned char *keycode, char raw_mode)<br>
+{<br>
+	return kbd_translate(scancode, keycode, raw_mode);<br>
+}<br>
+<br>
+int oldkbd_unexpected_up(void *devid, unsigned char keycode)<br>
+{<br>
+	return kbd_unexpected_up(keycode);<br>
+}<br>
+<br>
+void oldkbd_leds(void *devid, unsigned char leds)<br>
+{<br>
+	return kbd_leds(leds);<br>
+}<br>
+<br>
+struct kbd_ll_operations oldkbd_operations = {<br>
+	oldkbd_setkeycode,<br>
+	oldkbd_getkeycode,<br>
+	oldkbd_pretranslate,<br>
+	oldkbd_translate,<br>
+	oldkbd_unexpected_up,<br>
+	oldkbd_leds,<br>
+#ifdef CONFIG_MAGIC_SYSRQ<br>
+	SYSRQ_KEY,<br>
+	kbd_sysrq_xlate,<br>
+#else<br>
+	-1, NULL,<br>
+#endif<br>
+	0, 0, NULL<br>
+};<br>
+<br>
+void *old_kbdid;<br>
+<br>
+void handle_scancode(unsigned char scancode)<br>
+{<br>
+	if (old_kbdid)<br>
+		kbd_handle_scancode(old_kbdid, scancode);<br>
+}<br>
+#endif /* NEW_STYLE_KEYBOARD */<br>
+<br>
 __initfunc(int kbd_init(void))<br>
 {<br>
 	int i;<br>
@@ -902,7 +1061,54 @@<br>
 	ttytab = console_driver.table;<br>
 <br>
 	kbd_init_hw();<br>
+<br>
+#ifndef NEW_STYLE_KEYBOARD<br>
+	old_kbdid = register_keyboard(oldkbd_operations, NULL, key_maps);<br>
+#endif /* NEW_STYLE_KEYBOARD */<br>
+<br>
 	init_bh(KEYBOARD_BH, kbd_bh);<br>
 	mark_bh(KEYBOARD_BH);<br>
 	return 0;<br>
 }<br>
+<br>
+void *register_keyboard(struct kbd_ll_operations *ops, void *devid,<br>
+			ushort **key_maps)<br>
+{<br>
+	struct keyboard_state *ks, **ksp;<br>
+<br>
+	ks = (struct keyboard_state *) kmalloc(sizeof(*ks), GFP_KERNEL);<br>
+	if (ks == 0)<br>
+		return NULL;<br>
+	memset(ks, 0, sizeof(*ks));<br>
+<br>
+	ks-&gt;next = NULL;<br>
+	ks-&gt;k_op = ops;<br>
+	ks-&gt;devid = devid;<br>
+	ks-&gt;key_maps = key_maps;<br>
+	ks-&gt;npadch = -1;<br>
+<br>
+	spin_lock(&amp;all_kbds_lock);<br>
+	for (ksp = &amp;all_kbds; *ksp != NULL; ksp = &amp;(*ksp)-&gt;next)<br>
+		;<br>
+	*ksp = ks;<br>
+	spin_unlock(&amp;all_kbds_lock);<br>
+<br>
+	return (void *) ks;<br>
+}<br>
+<br>
+void unregister_keyboard(void *kbdid)<br>
+{<br>
+	struct keyboard_state **ksp;<br>
+<br>
+	spin_lock(&amp;all_kbds_lock);<br>
+	for (ksp = &amp;all_kbds; *ksp != NULL; ksp = &amp;(*ksp)-&gt;next) {<br>
+		if (*ksp == kbdid) {<br>
+			*ksp = (*ksp)-&gt;next;<br>
+			kfree(kbdid);<br>
+			break;<br>
+		}<br>
+	}<br>
+}<br>
+<br>
+EXPORT_SYMBOL (register_keyboard);<br>
+EXPORT_SYMBOL (unregister_keyboard);<br>
diff -ur linux/drivers/char/pc_keyb.c linux-pmac/drivers/char/pc_keyb.c<br>
--- linux/drivers/char/pc_keyb.c	Tue Oct 27 16:45:38 1998<br>
+++ linux-pmac/drivers/char/pc_keyb.c	Wed Oct 28 15:38:11 1998<br>
@@ -24,6 +24,7 @@<br>
 #include &lt;linux/init.h&gt;<br>
 #include &lt;linux/kbd_ll.h&gt;<br>
 #include &lt;linux/delay.h&gt;<br>
+#include &lt;linux/keyboard.h&gt;<br>
 #include &lt;linux/random.h&gt;<br>
 #include &lt;linux/poll.h&gt;<br>
 #include &lt;linux/miscdevice.h&gt;<br>
@@ -52,6 +53,8 @@<br>
 	"\206\207\210\211\212\000\000789-456+1"		/* 0x40 - 0x4f */<br>
 	"230\177\000\000\213\214\000\000\000\000\000\000\000\000\000\000" /* 0x50 - 0x5f */<br>
 	"\r\000/";					/* 0x60 - 0x6f */<br>
+#else<br>
+#define pckbd_sysrq_xlate	NULL<br>
 #endif<br>
 <br>
 static void kbd_write(int address, int data);<br>
@@ -85,6 +88,30 @@<br>
 #endif<br>
 #endif /* CONFIG_PSMOUSE */<br>
 <br>
+extern int pckbd_setkeycode(void *, unsigned int scancode,<br>
+			    unsigned int keycode);<br>
+extern int pckbd_getkeycode(void *, unsigned int scancode);<br>
+extern int pckbd_pretranslate(void *, unsigned char scancode, char raw_mode);<br>
+extern int pckbd_translate(void *, unsigned char scancode,<br>
+			   unsigned char *keycode, char raw_mode);<br>
+extern char pckbd_unexpected_up(void *, unsigned char keycode);<br>
+extern void pckbd_leds(void *, unsigned char leds);<br>
+#define SYSRQ_KEY 0x54<br>
+<br>
+struct kbd_ll_operations pckbd_operations = {<br>
+	pckbd_setkeycode,<br>
+	pckbd_getkeycode,<br>
+	pckbd_pretranslate,<br>
+	pckbd_translate,<br>
+	pckbd_unexpected_up,<br>
+	pckbd_leds,<br>
+	SYSRQ_KEY,<br>
+	pckbd_sysrq_xlate,<br>
+	0, 0, NULL<br>
+};<br>
+<br>
+static void *pckbd_id;<br>
+<br>
 /*<br>
  * Wait for keyboard controller input buffer is empty.<br>
  *<br>
@@ -237,7 +264,7 @@<br>
 <br>
 static unsigned int prev_scancode = 0;   /* remember E0, E1 */<br>
 <br>
-int pckbd_setkeycode(unsigned int scancode, unsigned int keycode)<br>
+int pckbd_setkeycode(void *devid, unsigned int scancode, unsigned int keycode)<br>
 {<br>
 	if (scancode &lt; SC_LIM || scancode &gt; 255 || keycode &gt; 127)<br>
 	  return -EINVAL;<br>
@@ -248,7 +275,7 @@<br>
 	return 0;<br>
 }<br>
 <br>
-int pckbd_getkeycode(unsigned int scancode)<br>
+int pckbd_getkeycode(void *devid, unsigned int scancode)<br>
 {<br>
 	return<br>
 	  (scancode &lt; SC_LIM || scancode &gt; 255) ? -EINVAL :<br>
@@ -308,7 +335,7 @@<br>
 	return 1;<br>
 }<br>
 <br>
-int pckbd_pretranslate(unsigned char scancode, char raw_mode)<br>
+int pckbd_pretranslate(void *devid, unsigned char scancode, char raw_mode)<br>
 {<br>
 	if (scancode == 0xff) {<br>
 		/* in scancode mode 1, my ESC key generates 0xff */<br>
@@ -330,8 +357,8 @@<br>
  	return 1;<br>
 }<br>
 <br>
-int pckbd_translate(unsigned char scancode, unsigned char *keycode,<br>
-		    char raw_mode)<br>
+int pckbd_translate(void *devid, unsigned char scancode,<br>
+		    unsigned char *keycode, char raw_mode)<br>
 {<br>
 	if (prev_scancode) {<br>
 	  /*<br>
@@ -409,7 +436,7 @@<br>
  	return 1;<br>
 }<br>
 <br>
-char pckbd_unexpected_up(unsigned char keycode)<br>
+char pckbd_unexpected_up(void *devid, unsigned char keycode)<br>
 {<br>
 	/* unexpected, but this can happen: maybe this was a key release for a<br>
 	   FOCUS 9000 PF key; if we want to see it, we have to clear up_flag */<br>
@@ -452,7 +479,7 @@<br>
 #endif<br>
 		} else {<br>
 			if (do_acknowledge(scancode))<br>
-				handle_scancode(scancode);<br>
+				kbd_handle_scancode(pckbd_id, scancode);<br>
 			mark_bh(KEYBOARD_BH);<br>
 		}<br>
 <br>
@@ -501,7 +528,7 @@<br>
 	return 0;<br>
 }<br>
 <br>
-void pckbd_leds(unsigned char leds)<br>
+void pckbd_leds(void *devid, unsigned char leds)<br>
 {<br>
 	if (!send_data(KBD_CMD_SET_LEDS) || !send_data(leds))<br>
 	    send_data(KBD_CMD_ENABLE);	/* re-enable kbd if any errors */<br>
@@ -713,6 +740,10 @@<br>
 <br>
 	/* Ok, finally allocate the IRQ, and off we go.. */<br>
 	request_irq(KEYBOARD_IRQ, keyboard_interrupt, 0, "keyboard", NULL);<br>
+<br>
+	pckbd_id = register_keyboard(&amp;pckbd_operations, NULL, key_maps);<br>
+	if (pckbd_id == NULL)<br>
+		printk(KERN_ERR "Couldn't register PC keyboard!\n");<br>
 }<br>
 <br>
 #if defined CONFIG_PSMOUSE<br>
diff -ur linux/drivers/macintosh/mac_keyb.c linux-pmac/drivers/macintosh/mac_keyb.c<br>
--- linux/drivers/macintosh/mac_keyb.c	Mon Oct 12 10:32:52 1998<br>
+++ linux-pmac/drivers/macintosh/mac_keyb.c	Sun Oct 25 16:13:14 1998<br>
@@ -31,7 +31,27 @@<br>
 #define KEYB_LEDREG	2	/* register # for leds on ADB keyboard */<br>
 #define MOUSE_DATAREG	0	/* reg# for movement/button codes from mouse */<br>
 <br>
-static u_short macplain_map[NR_KEYS] __initdata = {<br>
+int mackbd_setkeycode(void *devid, unsigned int scancode, unsigned int keycode);<br>
+int mackbd_getkeycode(void *devid, unsigned int scancode);<br>
+int mackbd_pretranslate(void *devid, unsigned char scancode, char raw_mode);<br>
+int mackbd_translate(void *devid, unsigned char scancode,<br>
+		     unsigned char *keycode, char raw_mode);<br>
+char mackbd_unexpected_up(void *devid, unsigned char keycode);<br>
+void mackbd_leds(void *devid, unsigned char leds);<br>
+<br>
+/* this map indicates which keys shouldn't autorepeat. */<br>
+static unsigned char dont_repeat[128] = {<br>
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
+	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,	/* esc...option */<br>
+	0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, /* num lock */<br>
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, /* scroll lock */<br>
+	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
+};<br>
+<br>
+static u_short plain_map[NR_KEYS] = {<br>
 	0xfb61,	0xfb73,	0xfb64,	0xfb66,	0xfb68,	0xfb67,	0xfb7a,	0xfb78,<br>
 	0xfb63,	0xfb76,	0xf200,	0xfb62,	0xfb71,	0xfb77,	0xfb65,	0xfb72,<br>
 	0xfb79,	0xfb74,	0xf031,	0xf032,	0xf033,	0xf034,	0xf036,	0xf035,<br>
@@ -50,7 +70,7 @@<br>
 	0xf101,	0xf119,	0xf100,	0xf700,	0xf701,	0xf702,	0xf200,	0xf200,<br>
 };<br>
 <br>
-static u_short macshift_map[NR_KEYS] __initdata = {<br>
+static u_short shift_map[NR_KEYS] = {<br>
 	0xfb41,	0xfb53,	0xfb44,	0xfb46,	0xfb48,	0xfb47,	0xfb5a,	0xfb58,<br>
 	0xfb43,	0xfb56,	0xf200,	0xfb42,	0xfb51,	0xfb57,	0xfb45,	0xfb52,<br>
 	0xfb59,	0xfb54,	0xf021,	0xf040,	0xf023,	0xf024,	0xf05e,	0xf025,<br>
@@ -69,7 +89,7 @@<br>
 	0xf10b,	0xf20a,	0xf10a,	0xf700,	0xf701,	0xf702,	0xf200,	0xf200,<br>
 };<br>
 <br>
-static u_short macaltgr_map[NR_KEYS] __initdata = {<br>
+static u_short altgr_map[NR_KEYS] = {<br>
 	0xf914,	0xfb73,	0xf917,	0xf919,	0xfb68,	0xfb67,	0xfb7a,	0xfb78,<br>
 	0xf916,	0xfb76,	0xf200,	0xf915,	0xfb71,	0xfb77,	0xf918,	0xfb72,<br>
 	0xfb79,	0xfb74,	0xf200,	0xf040,	0xf200,	0xf024,	0xf200,	0xf200,<br>
@@ -88,7 +108,7 @@<br>
 	0xf50d,	0xf119,	0xf50c,	0xf700,	0xf701,	0xf702,	0xf200,	0xf200,<br>
 };<br>
 <br>
-static u_short macctrl_map[NR_KEYS] __initdata = {<br>
+static u_short ctrl_map[NR_KEYS] = {<br>
 	0xf001,	0xf013,	0xf004,	0xf006,	0xf008,	0xf007,	0xf01a,	0xf018,<br>
 	0xf003,	0xf016,	0xf200,	0xf002,	0xf011,	0xf017,	0xf005,	0xf012,<br>
 	0xf019,	0xf014,	0xf200,	0xf000,	0xf01b,	0xf01c,	0xf01e,	0xf01d,<br>
@@ -107,7 +127,7 @@<br>
 	0xf101,	0xf119,	0xf100,	0xf700,	0xf701,	0xf702,	0xf200,	0xf200,<br>
 };<br>
 <br>
-static u_short macshift_ctrl_map[NR_KEYS] __initdata = {<br>
+static u_short shift_ctrl_map[NR_KEYS] = {<br>
 	0xf001,	0xf013,	0xf004,	0xf006,	0xf008,	0xf007,	0xf01a,	0xf018,<br>
 	0xf003,	0xf016,	0xf200,	0xf002,	0xf011,	0xf017,	0xf005,	0xf012,<br>
 	0xf019,	0xf014,	0xf200,	0xf000,	0xf200,	0xf200,	0xf200,	0xf200,<br>
@@ -126,7 +146,7 @@<br>
 	0xf200,	0xf119,	0xf200,	0xf700,	0xf701,	0xf702,	0xf200,	0xf20c,<br>
 };<br>
 <br>
-static u_short macalt_map[NR_KEYS] __initdata = {<br>
+static u_short alt_map[NR_KEYS] = {<br>
 	0xf861,	0xf873,	0xf864,	0xf866,	0xf868,	0xf867,	0xf87a,	0xf878,<br>
 	0xf863,	0xf876,	0xf200,	0xf862,	0xf871,	0xf877,	0xf865,	0xf872,<br>
 	0xf879,	0xf874,	0xf831,	0xf832,	0xf833,	0xf834,	0xf836,	0xf835,<br>
@@ -145,7 +165,7 @@<br>
 	0xf501,	0xf119,	0xf500,	0xf700,	0xf701,	0xf702,	0xf200,	0xf200,<br>
 };<br>
 <br>
-static u_short macctrl_alt_map[NR_KEYS] __initdata = {<br>
+static u_short ctrl_alt_map[NR_KEYS] = {<br>
 	0xf801,	0xf813,	0xf804,	0xf806,	0xf808,	0xf807,	0xf81a,	0xf818,<br>
 	0xf803,	0xf816,	0xf200,	0xf802,	0xf811,	0xf817,	0xf805,	0xf812,<br>
 	0xf819,	0xf814,	0xf200,	0xf200,	0xf200,	0xf200,	0xf200,	0xf200,<br>
@@ -164,13 +184,28 @@<br>
 	0xf501,	0xf119,	0xf500,	0xf700,	0xf701,	0xf702,	0xf200,	0xf200,<br>
 };<br>
 <br>
+static ushort *mackey_maps[MAX_NR_KEYMAPS] = {<br>
+	plain_map, shift_map, altgr_map, 0,<br>
+	ctrl_map, shift_ctrl_map, 0, 0,<br>
+	alt_map, 0, 0, 0,<br>
+	ctrl_alt_map,	0<br>
+};<br>
 <br>
-static void kbd_repeat(unsigned long);<br>
-static struct timer_list repeat_timer = { NULL, NULL, 0, 0, kbd_repeat };<br>
-static int last_keycode;<br>
+struct kbd_ll_operations mackbd_operations = {<br>
+	mackbd_setkeycode,<br>
+	mackbd_getkeycode,<br>
+	mackbd_pretranslate,<br>
+	mackbd_translate,<br>
+	mackbd_unexpected_up,<br>
+	mackbd_leds,<br>
+	-1,		/* no SysRq key */<br>
+	NULL,<br>
+	HZ/2, HZ/15,<br>
+	dont_repeat<br>
+};<br>
 <br>
 static void keyboard_input(unsigned char *, int, struct pt_regs *, int);<br>
-static void input_keycode(int, int);<br>
+static void input_keycode(void *, int);<br>
 static void leds_done(struct adb_request *);<br>
 static void mac_put_queue(int);<br>
 <br>
@@ -185,44 +220,39 @@<br>
 extern int console_loglevel;<br>
 <br>
 extern struct kbd_struct kbd_table[];<br>
-extern struct wait_queue * keypress_wait;<br>
-<br>
-extern void handle_scancode(unsigned char);<br>
+extern struct wait_queue *keypress_wait;<br>
 <br>
 static struct adb_ids keyboard_ids;<br>
 static struct adb_ids mouse_ids;<br>
 <br>
-/* this map indicates which keys shouldn't autorepeat. */<br>
-static unsigned char dont_repeat[128] = {<br>
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
-	0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,	/* esc...option */<br>
-	0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, /* num lock */<br>
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, /* scroll lock */<br>
-	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,<br>
+struct mackbd_state {<br>
+	int	adb_id;<br>
+	void	*kbd_id;<br>
+	struct adb_request led_request;<br>
+	int	leds_pending;<br>
 };<br>
 <br>
+struct mackbd_state mackbd_states[16];<br>
+<br>
 __openfirmware<br>
 <br>
-int mackbd_setkeycode(unsigned int scancode, unsigned int keycode)<br>
+int mackbd_setkeycode(void *devid, unsigned int scancode, unsigned int keycode)<br>
 {<br>
 	return -EINVAL;<br>
 }<br>
 <br>
-int mackbd_getkeycode(unsigned int scancode)<br>
+int mackbd_getkeycode(void *devid, unsigned int scancode)<br>
 {<br>
 	return -EINVAL;<br>
 }<br>
 <br>
-int mackbd_pretranslate(unsigned char scancode, char raw_mode)<br>
+int mackbd_pretranslate(void *devid, unsigned char scancode, char raw_mode)<br>
 {<br>
 	return 1;<br>
 }<br>
 <br>
-int mackbd_translate(unsigned char keycode, unsigned char *keycodep,<br>
-		     char raw_mode)<br>
+int mackbd_translate(void *devid, unsigned char keycode,<br>
+		     unsigned char *keycodep, char raw_mode)<br>
 {<br>
 	if (!raw_mode) {<br>
 		/*<br>
@@ -238,7 +268,7 @@<br>
 	return 1;<br>
 }<br>
 <br>
-int mackbd_unexpected_up(unsigned char keycode)<br>
+char mackbd_unexpected_up(void *devid, unsigned char keycode)<br>
 {<br>
 	return 0x80;<br>
 }<br>
@@ -246,17 +276,22 @@<br>
 static void<br>
 keyboard_input(unsigned char *data, int nb, struct pt_regs *regs, int apoll)<br>
 {<br>
+	void *kbd_id;<br>
+<br>
 	/* first check this is from register 0 */<br>
 	if (nb != 3 || (data[0] &amp; 3) != KEYB_KEYREG)<br>
 		return;		/* ignore it */<br>
+	kbd_id = mackbd_states[data[0] &gt;&gt; 4].kbd_id;<br>
+	if (kbd_id == NULL)<br>
+		return;<br>
 	kbd_pt_regs = regs;<br>
-	input_keycode(data[1], 0);<br>
+	input_keycode(kbd_id, data[1]);<br>
 	if (!(data[2] == 0xff || (data[2] == 0x7f &amp;&amp; data[1] == 0x7f)))<br>
-		input_keycode(data[2], 0);<br>
+		input_keycode(kbd_id, data[2]);<br>
 }<br>
 <br>
 static void<br>
-input_keycode(int keycode, int repeat)<br>
+input_keycode(void *kbdid, int keycode)<br>
 {<br>
 	struct kbd_struct *kbd;<br>
 	int up_flag;<br>
@@ -269,9 +304,6 @@<br>
 	if (keycode == 0x7e)<br>
 		keycode = 0x7f;<br>
 <br>
-	if (!repeat)<br>
-		del_timer(&amp;repeat_timer);<br>
-<br>
 #ifdef CONFIG_ADBMOUSE<br>
 	/*<br>
 	 * XXX: Add mouse button 2+3 fake codes here if mouse open.<br>
@@ -305,12 +337,6 @@<br>
 #endif /* CONFIG_ADBMOUSE */<br>
 <br>
 	if (kbd-&gt;kbdmode != VC_RAW) {<br>
-		if (!up_flag &amp;&amp; !dont_repeat[keycode]) {<br>
-			last_keycode = keycode;<br>
-			repeat_timer.expires = jiffies + (repeat? HZ/15: HZ/2);<br>
-			add_timer(&amp;repeat_timer);<br>
-		}<br>
-<br>
 		/*<br>
 		 * adb kludge!! Imitate pc caps lock behaviour by<br>
 		 * generating an up/down event for each time caps<br>
@@ -320,8 +346,8 @@<br>
 		 switch (keycode) {<br>
 		 /*case 0xb9:*/<br>
 		 case 0x39:<br>
-			handle_scancode(0x39);<br>
-			handle_scancode(0xb9);<br>
+			kbd_handle_scancode(kbdid, 0x39);<br>
+			kbd_handle_scancode(kbdid, 0xb9);<br>
 		 	mark_bh(KEYBOARD_BH);<br>
 		 	return;<br>
 		 case 0x47:<br>
@@ -331,18 +357,7 @@<br>
 		 }<br>
 	}<br>
 <br>
-	handle_scancode(keycode + up_flag);<br>
-}<br>
-<br>
-static void<br>
-kbd_repeat(unsigned long xxx)<br>
-{<br>
-	unsigned long flags;<br>
-<br>
-	save_flags(flags);<br>
-	cli();<br>
-	input_keycode(last_keycode, 1);<br>
-	restore_flags(flags);<br>
+	kbd_handle_scancode(kbdid, keycode + up_flag);<br>
 }<br>
 <br>
 static void mac_put_queue(int ch)<br>
@@ -479,132 +494,120 @@<br>
     7,		/* caps + num + scroll lock */<br>
 };<br>
 <br>
-static struct adb_request led_request;<br>
-static int leds_pending[16];<br>
-static int pending_devs[16];<br>
-static int pending_led_start=0;<br>
-static int pending_led_end=0;<br>
-<br>
-static void real_mackbd_leds(unsigned char leds, int device)<br>
-{<br>
-<br>
-    if (led_request.complete) {<br>
-	adb_request(&amp;led_request, leds_done, 0, 3,<br>
-		    ADB_WRITEREG(device, KEYB_LEDREG), 0xff,<br>
-		    ~mac_ledmap[leds]);<br>
-    } else {<br>
-	if (!(leds_pending[device] &amp; 0x100)) {<br>
-	    pending_devs[pending_led_end] = device;<br>
-	    pending_led_end++;<br>
-	    pending_led_end = (pending_led_end &lt; 16) ? pending_led_end : 0;<br>
-	}<br>
-	leds_pending[device] = leds | 0x100;<br>
-    }<br>
-}<br>
-<br>
-void mackbd_leds(unsigned char leds)<br>
+void mackbd_leds(void *devid, unsigned char leds)<br>
 {<br>
-    int i;<br>
+	struct mackbd_state *ms = (struct mackbd_state *) devid;<br>
 <br>
-    for(i = 0; i &lt; keyboard_ids.nids; i++)<br>
-	real_mackbd_leds(leds,keyboard_ids.id[i]);<br>
+	if (ms-&gt;led_request.complete) {<br>
+		ms-&gt;led_request.arg = devid;<br>
+		adb_request(&amp;ms-&gt;led_request, leds_done, 0, 3,<br>
+			    ADB_WRITEREG(ms-&gt;adb_id, KEYB_LEDREG), 0xff,<br>
+			    ~mac_ledmap[leds]);<br>
+	} else {<br>
+		ms-&gt;leds_pending = leds | 0x100;<br>
+	}<br>
 }<br>
 <br>
 static void leds_done(struct adb_request *req)<br>
 {<br>
-    int leds,device;<br>
-<br>
-    if (pending_led_start != pending_led_end) {<br>
-	device = pending_devs[pending_led_start];<br>
-	leds = leds_pending[device] &amp; 0xff;<br>
-	leds_pending[device] = 0;<br>
-	pending_led_start++;<br>
-	pending_led_start = (pending_led_start &lt; 16) ? pending_led_start : 0;<br>
-	real_mackbd_leds(leds,device);<br>
-    }<br>
+	struct mackbd_state *ms = (struct mackbd_state *) req-&gt;arg;<br>
+	int leds;<br>
 <br>
+	if (ms-&gt;leds_pending) {<br>
+		leds = ms-&gt;leds_pending &amp; 0xff;<br>
+		ms-&gt;leds_pending = 0;<br>
+		mackbd_leds(ms, leds);<br>
+	}<br>
 }<br>
 <br>
-__initfunc(void mackbd_init_hw(void))<br>
+__initfunc(static void init_mouse(int id))<br>
 {<br>
 	struct adb_request req;<br>
-	int i;<br>
-<br>
-	if ( (_machine != _MACH_chrp) &amp;&amp; (_machine != _MACH_Pmac) )<br>
-	    return;<br>
-<br>
-	/* setup key map */<br>
-	memcpy(key_maps[0], macplain_map, sizeof(plain_map));<br>
-	memcpy(key_maps[1], macshift_map, sizeof(plain_map));<br>
-	memcpy(key_maps[2], macaltgr_map, sizeof(plain_map));<br>
-	memcpy(key_maps[4], macctrl_map, sizeof(plain_map));<br>
-	memcpy(key_maps[5], macshift_ctrl_map, sizeof(plain_map));<br>
-	memcpy(key_maps[8], macalt_map, sizeof(plain_map));<br>
-	memcpy(key_maps[12], macctrl_alt_map, sizeof(plain_map));<br>
-<br>
-#ifdef CONFIG_ADBMOUSE<br>
-	/* initialize mouse interrupt hook */<br>
-	adb_mouse_interrupt_hook = NULL;<br>
-<br>
-	adb_register(ADB_MOUSE, 1, &amp;mouse_ids, mouse_input);<br>
-#endif /* CONFIG_ADBMOUSE */<br>
-<br>
-	adb_register(ADB_KEYBOARD, 5, &amp;keyboard_ids, keyboard_input);<br>
-<br>
-	for(i = 0; i &lt; keyboard_ids.nids; i++) {<br>
-	    /* turn off all leds */<br>
-	    adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-	    ADB_WRITEREG(keyboard_ids.id[i], KEYB_LEDREG), 0xff, 0xff);<br>
-	}<br>
 <br>
-	/* get the keyboard to send separate codes for<br>
-	   left and right shift, control, option keys. */<br>
-	for(i = 0;i &lt; keyboard_ids.nids; i++) {<br>
-	    /* get the keyboard to send separate codes for<br>
-	    left and right shift, control, option keys. */<br>
-	    adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-	    ADB_WRITEREG(keyboard_ids.id[i], 3), 0, 3);<br>
-	}<br>
+	adb_request(&amp;req, NULL, ADBREQ_SYNC | ADBREQ_REPLY, 1,<br>
+		    ADB_READREG(id, 1));<br>
 <br>
-	led_request.complete = 1;<br>
+	if ((req.reply_len) &amp;&amp;<br>
+	    (req.reply[1] == 0x9a) &amp;&amp; (req.reply[2] == 0x21)) {<br>
+		printk("aha, trackball found at %d\n", id);<br>
 <br>
-	/* Try to switch the mouse (id 3) to handler 4, for three-button<br>
-	   mode. (0x20 is Service Request Enable, 0x03 is Device ID). */<br>
-	for(i = 0; i &lt; mouse_ids.nids; i++) {<br>
-	    adb_request(&amp;req, NULL, ADBREQ_SYNC | ADBREQ_REPLY, 1,<br>
-			ADB_READREG(mouse_ids.id[i], 1));<br>
-<br>
-	    if ((req.reply_len) &amp;&amp;<br>
-		(req.reply[1] == 0x9a) &amp;&amp; (req.reply[2] == 0x21)) {<br>
+		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
+			    ADB_WRITEREG(id, 3), 0x63, 4 );<br>
 <br>
-		printk("aha, trackball found at %d\n", mouse_ids.id[i]);<br>
+		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
+			    ADB_WRITEREG(id,1), 00,0x81);<br>
 <br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i], 3), 0x63, 4 );<br>
+			    ADB_WRITEREG(id,1), 01,0x81);<br>
 <br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i],1), 00,0x81);<br>
+			    ADB_WRITEREG(id,1), 02,0x81);<br>
 <br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i],1), 01,0x81);<br>
+			    ADB_WRITEREG(id,1), 03,0x38);<br>
 <br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i],1), 02,0x81);<br>
+			    ADB_WRITEREG(id,1), 00,0x81);<br>
 <br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i],1), 03,0x38);<br>
+			    ADB_WRITEREG(id,1), 01,0x81);<br>
 <br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i],1), 00,0x81);<br>
+			    ADB_WRITEREG(id,1), 02,0x81);<br>
 <br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i],1), 01,0x81);<br>
+			    ADB_WRITEREG(id,1), 03,0x38);<br>
+	}<br>
+}<br>
 <br>
+__initfunc(void mackbd_init_hw(void))<br>
+{<br>
+	int i;<br>
+<br>
+	if ((_machine != _MACH_chrp) &amp;&amp; (_machine != _MACH_Pmac))<br>
+		return;<br>
+<br>
+#ifdef CONFIG_ADBMOUSE<br>
+	/* initialize mouse interrupt hook */<br>
+	adb_mouse_interrupt_hook = NULL;<br>
+<br>
+	adb_register(ADB_MOUSE, 1, &amp;mouse_ids, mouse_input);<br>
+<br>
+	/* Try to switch the mouse (id 3) to handler 4, for three-button<br>
+	   mode. (0x20 is Service Request Enable, 0x03 is Device ID). */<br>
+	for (i = 0; i &lt; mouse_ids.nids; i++) {<br>
+		init_mouse(mouse_ids.id[i]);<br>
+	}<br>
+#endif /* CONFIG_ADBMOUSE */<br>
+<br>
+	adb_register(ADB_KEYBOARD, 5, &amp;keyboard_ids, keyboard_input);<br>
+	if (keyboard_ids.nids == 0)<br>
+		return;<br>
+<br>
+	for (i = 0; i &lt; keyboard_ids.nids; i++) {<br>
+		int id = keyboard_ids.id[i];<br>
+		struct mackbd_state *ms = &amp;mackbd_states[id];<br>
+		struct adb_request req;<br>
+<br>
+		memset(ms, 0, sizeof(*ms));<br>
+		ms-&gt;adb_id = id;<br>
+		ms-&gt;led_request.complete = 1;<br>
+		ms-&gt;kbd_id = register_keyboard(&amp;mackbd_operations, ms,<br>
+					       mackey_maps);<br>
+		if (ms-&gt;kbd_id == NULL)<br>
+			printk(KERN_ERR "Couldn't register ADB keyboard %d\n",<br>
+			       id);<br>
+<br>
+		/* turn off all leds */<br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i],1), 02,0x81);<br>
+			    ADB_WRITEREG(id, KEYB_LEDREG), 0xff, 0xff);<br>
 <br>
+		/* get the keyboard to send separate codes for<br>
+		   left and right shift, control, option keys. */<br>
 		adb_request(&amp;req, NULL, ADBREQ_SYNC, 3,<br>
-		ADB_WRITEREG(mouse_ids.id[i],1), 03,0x38);<br>
-	    }<br>
+			    ADB_WRITEREG(id, 3), 0, 3);<br>
 	}<br>
+<br>
+	/* setup default key map */<br>
+	memcpy(key_maps, mackey_maps, sizeof(mackey_maps));<br>
 }<br>
diff -ur linux/include/asm-i386/keyboard.h linux-pmac/include/asm-i386/keyboard.h<br>
--- linux/include/asm-i386/keyboard.h	Mon Jul 21 18:16:55 1997<br>
+++ linux-pmac/include/asm-i386/keyboard.h	Sun Oct 25 15:56:37 1998<br>
@@ -15,27 +15,11 @@<br>
 <br>
 #define KEYBOARD_IRQ			1<br>
 #define DISABLE_KBD_DURING_INTERRUPTS	0<br>
+#define NEW_STYLE_KEYBOARD<br>
 <br>
-extern int pckbd_setkeycode(unsigned int scancode, unsigned int keycode);<br>
-extern int pckbd_getkeycode(unsigned int scancode);<br>
-extern int pckbd_pretranslate(unsigned char scancode, char raw_mode);<br>
-extern int pckbd_translate(unsigned char scancode, unsigned char *keycode,<br>
-			   char raw_mode);<br>
-extern char pckbd_unexpected_up(unsigned char keycode);<br>
-extern void pckbd_leds(unsigned char leds);<br>
 extern void pckbd_init_hw(void);<br>
-extern unsigned char pckbd_sysrq_xlate[128];<br>
 <br>
-#define kbd_setkeycode		pckbd_setkeycode<br>
-#define kbd_getkeycode		pckbd_getkeycode<br>
-#define kbd_pretranslate	pckbd_pretranslate<br>
-#define kbd_translate		pckbd_translate<br>
-#define kbd_unexpected_up	pckbd_unexpected_up<br>
-#define kbd_leds		pckbd_leds<br>
 #define kbd_init_hw		pckbd_init_hw<br>
-#define kbd_sysrq_xlate		pckbd_sysrq_xlate<br>
-<br>
-#define SYSRQ_KEY 0x54<br>
 <br>
 #endif /* __KERNEL__ */<br>
 <br>
diff -ur linux/include/asm-ppc/keyboard.h linux-pmac/include/asm-ppc/keyboard.h<br>
--- linux/include/asm-ppc/keyboard.h	Thu Oct 22 16:31:01 1998<br>
+++ linux-pmac/include/asm-ppc/keyboard.h	Wed Oct 28 15:45:57 1998<br>
@@ -16,7 +16,7 @@<br>
 #ifdef __KERNEL__<br>
 <br>
 #include &lt;linux/config.h&gt;<br>
-#include &lt;asm/adb.h&gt;<br>
+#include &lt;asm/processor.h&gt;<br>
 <br>
 #ifdef CONFIG_APUS<br>
 #include &lt;asm-m68k/keyboard.h&gt;<br>
@@ -24,152 +24,22 @@<br>
 <br>
 #define KEYBOARD_IRQ			1<br>
 #define DISABLE_KBD_DURING_INTERRUPTS	0<br>
-#define INIT_KBD<br>
+#define NEW_STYLE_KEYBOARD<br>
 <br>
-extern int mackbd_setkeycode(unsigned int scancode, unsigned int keycode);<br>
-extern int mackbd_getkeycode(unsigned int scancode);<br>
-extern int mackbd_pretranslate(unsigned char scancode, char raw_mode);<br>
-extern int mackbd_translate(unsigned char scancode, unsigned char *keycode,<br>
-			   char raw_mode);<br>
-extern int mackbd_unexpected_up(unsigned char keycode);<br>
-extern void mackbd_leds(unsigned char leds);<br>
 extern void mackbd_init_hw(void);<br>
 <br>
-extern int pckbd_setkeycode(unsigned int scancode, unsigned int keycode);<br>
-extern int pckbd_getkeycode(unsigned int scancode);<br>
-extern int pckbd_pretranslate(unsigned char scancode, char raw_mode);<br>
-extern int pckbd_translate(unsigned char scancode, unsigned char *keycode,<br>
-			   char raw_mode);<br>
-extern char pckbd_unexpected_up(unsigned char keycode);<br>
-extern void pckbd_leds(unsigned char leds);<br>
 extern void pckbd_init_hw(void);<br>
 <br>
-static inline int kbd_setkeycode(unsigned int scancode, unsigned int keycode)<br>
-{<br>
-	if ( is_prep )<br>
-		return pckbd_setkeycode(scancode,keycode);<br>
-	else if ( is_chrp )<br>
-#ifndef CONFIG_MAC_KEYBOARD<br>
-		return pckbd_setkeycode(scancode,keycode);<br>
-#else<br>
-		/* I'm not actually sure if it's legal to have a CHRP machine<br>
-		 * without an ADB controller. In any case, this should really<br>
-		 * be changed to be a test to see if an ADB _keyboard_ exists<br>
-		 * (not just a controller), but that's another story for<br>
-		 * another night.<br>
-		 */<br>
-		if ( adb_hardware == ADB_NONE )<br>
-			return pckbd_setkeycode(scancode,keycode);<br>
-		else<br>
-			return mackbd_setkeycode(scancode,keycode);<br>
-#endif<br>
-	else<br>
-		return mackbd_setkeycode(scancode,keycode);<br>
-}<br>
-<br>
-static inline int kbd_getkeycode(unsigned int x)<br>
-{<br>
-	if ( is_prep )<br>
-		return pckbd_getkeycode(x);<br>
-	else if ( is_chrp )<br>
-#ifndef CONFIG_MAC_KEYBOARD<br>
-		return pckbd_getkeycode(x);<br>
-#else<br>
-		if ( adb_hardware == ADB_NONE )<br>
-			return pckbd_getkeycode(x);<br>
-		else<br>
-			return mackbd_getkeycode(x);<br>
-#endif<br>
-	else<br>
-		return mackbd_getkeycode(x);<br>
-}<br>
-<br>
-static inline int kbd_pretranslate(unsigned char x,char y)<br>
-{<br>
-	if ( is_prep )<br>
-		return pckbd_pretranslate(x,y);<br>
-	else if ( is_chrp )<br>
-#ifndef CONFIG_MAC_KEYBOARD<br>
-		return pckbd_pretranslate(x,y);<br>
-#else<br>
-		if ( adb_hardware == ADB_NONE )<br>
-			return pckbd_pretranslate(x,y);<br>
-		else<br>
-			return mackbd_pretranslate(x,y);<br>
-#endif<br>
-	else<br>
-		return mackbd_pretranslate(x,y);<br>
-}<br>
-<br>
-static inline int kbd_translate(unsigned char keycode, unsigned char *keycodep,<br>
-		     char raw_mode)<br>
-{<br>
-	if ( is_prep )<br>
-		return pckbd_translate(keycode,keycodep,raw_mode);<br>
-	else if ( is_chrp )<br>
-#ifndef CONFIG_MAC_KEYBOARD<br>
-		return pckbd_translate(keycode,keycodep,raw_mode);<br>
-#else<br>
-		if ( adb_hardware == ADB_NONE )<br>
-			return pckbd_translate(keycode,keycodep,raw_mode);<br>
-		else<br>
-			return mackbd_translate(keycode,keycodep,raw_mode);<br>
-#endif<br>
-	else<br>
-		return mackbd_translate(keycode,keycodep,raw_mode);<br>
-	<br>
-}<br>
-<br>
-static inline int kbd_unexpected_up(unsigned char keycode)<br>
-{<br>
-	if ( is_prep )<br>
-		return pckbd_unexpected_up(keycode);<br>
-	else if ( is_chrp )<br>
-#ifndef CONFIG_MAC_KEYBOARD<br>
-		return pckbd_unexpected_up(keycode);<br>
-#else<br>
-		if ( adb_hardware == ADB_NONE )<br>
-			return pckbd_unexpected_up(keycode);<br>
-		else<br>
-			return mackbd_unexpected_up(keycode);<br>
-#endif<br>
-	else<br>
-		return mackbd_unexpected_up(keycode);<br>
-	<br>
-}<br>
-<br>
-static inline void kbd_leds(unsigned char leds)<br>
-{<br>
-	if ( is_prep )<br>
-		pckbd_leds(leds);<br>
-	else if ( is_chrp )<br>
-#ifndef CONFIG_MAC_KEYBOARD<br>
-		pckbd_leds(leds);<br>
-#else<br>
-		if ( adb_hardware == ADB_NONE )<br>
-			pckbd_leds(leds);<br>
-		else<br>
-			mackbd_leds(leds);<br>
-#endif<br>
-	else<br>
-		mackbd_leds(leds);<br>
-}<br>
-<br>
 static inline void kbd_init_hw(void)<br>
 {<br>
-	if ( is_prep )<br>
-		pckbd_init_hw();<br>
-	else if ( is_chrp )<br>
-#ifndef CONFIG_MAC_KEYBOARD<br>
+#ifdef CONFIG_MAC_KEYBOARD<br>
+	if (!is_prep)<br>
+		mackbd_init_hw();<br>
+#endif<br>
+#ifdef CONFIG_PC_KEYBOARD<br>
+	if (is_prep || is_chrp)<br>
 		pckbd_init_hw();<br>
-#else<br>
-		if ( adb_hardware == ADB_NONE )<br>
-			pckbd_init_hw();<br>
-		else<br>
-			mackbd_init_hw();<br>
 #endif<br>
-	else<br>
-		mackbd_init_hw();<br>
 }<br>
 <br>
 #endif /* CONFIG_APUS */<br>
diff -ur linux/include/linux/kbd_ll.h linux-pmac/include/linux/kbd_ll.h<br>
--- linux/include/linux/kbd_ll.h	Mon Jul 21 18:44:40 1997<br>
+++ linux-pmac/include/linux/kbd_ll.h	Sat Oct 24 21:12:14 1998<br>
@@ -5,8 +5,35 @@<br>
 #ifndef _KBD_LL_H<br>
 #define _KBD_LL_H<br>
 <br>
+/*<br>
+ * The kbd_operations struct contains pointers to the procedures<br>
+ * which are supplied by the low-level keyboard driver and used<br>
+ * by the keymapper (drivers/char/keyboard.c).<br>
+ */<br>
+struct kbd_ll_operations {<br>
+	int	(*setkeycode)(void *devid, unsigned int scancode,<br>
+			      unsigned int keycode);<br>
+	int	(*getkeycode)(void *devid, unsigned int scancode);<br>
+	int	(*pretranslate)(void *devid, unsigned char scancode,<br>
+				char raw_mode);<br>
+	int	(*translate)(void *devid, unsigned char scancode,<br>
+			     unsigned char *keycode, char raw_mode);<br>
+	char	(*unexpected_up)(void *devid, unsigned char keycode);<br>
+	void	(*leds)(void *devid, unsigned char leds);<br>
+	int	sysrq_key;<br>
+	unsigned char *sysrq_xlate;<br>
+	int	repeat_initial;	/* initial delay for soft auto-repeat */<br>
+	int	repeat_delay;	/* delay between auto-repeats */<br>
+	unsigned char *dont_repeat;	/* keys which don't auto-repeat */<br>
+};<br>
+<br>
 extern struct pt_regs *kbd_pt_regs;<br>
 <br>
 void handle_scancode(unsigned char scancode);<br>
+<br>
+void *register_keyboard(struct kbd_ll_operations *ops, void *devid,<br>
+			ushort **key_maps);	/* returns kbd id */<br>
+void unregister_keyboard(void *kbdid);<br>
+void kbd_handle_scancode(void *kbdid, int scancode);<br>
 <br>
 #endif	/* _KBD_LL_H */<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0390.html">Chip Salzenberg: "Patch for 2.1.127-pre6 and gcc 2.7.x"</a>
<li> <b>Previous message:</b> <a href="0388.html">Alex Buell: "New DoS via SAK?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0445.html">Alan Cox: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0445.html">Alan Cox: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0707.html">Pavel Machek: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0715.html">Pavel Machek: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0746.html">Paul Mackerras: "Re: for comment: multi-keyboard patch"</a>
<li> <b>Reply:</b> <a href="0809.html">Stephen Lee: "Re: for comment: multi-keyboard patch"</a>
<!-- reply="end" -->
</ul>
</font></body>
