<!-- received="Wed Nov  4 07:17:44 1998 EET" -->
<!-- sent="Tue, 3 Nov 1998 23:39:28 -0500" -->
<!-- name="Theodore Y. Ts'o" -->
<!-- email="tytso@MIT.EDU" -->
<!-- subject="Patch to the serial driver" -->
<!-- id="199811040439.XAA26291@dcl.MIT.EDU" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: Patch to the serial driver</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Patch to the serial driver</h1>
<b>Theodore Y. Ts'o</b> (<a href="mailto:tytso@MIT.EDU"><i>tytso@MIT.EDU</i></a>)<br>
<i>Tue, 3 Nov 1998 23:39:28 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#386">[ date ]</a><a href="index.html#386">[ thread ]</a><a href="subject.html#386">[ subject ]</a><a href="author.html#386">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0387.html">Albert D. Cahalan: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0385.html">flewid: "Re: ppp and 2.1.126/2.1.125"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus,<br>
<p>
The following patch to the serial driver corrects two bugs.  The first<br>
is that if a non-privieged user tries to set some flags, the run-time<br>
flags in info-&gt;flags weren't getting set; instead only the long-term<br>
flags in state-&gt;flags were getting set.<br>
<p>
The second fix is to not allow someone to enter a zero base_baud<br>
configuration, since this would cause a divide by zero error later.<br>
<p>
I'd appreciate it if you could get this applied into the mainline kernel<br>
branch.  Thanks!!<br>
<p>
					- Ted<br>
<p>
<p>
Patch generated: on Tue Nov  3 23:34:46 EST 1998 by <a href="mailto:tytso@rsts-11.mit.edu">tytso@rsts-11.mit.edu</a><br>
against Linux version 2.1.126<br>
 <br>
===================================================================<br>
RCS file: drivers/char/RCS/serial.c,v<br>
retrieving revision 1.1<br>
diff -u -r1.1 drivers/char/serial.c<br>
--- drivers/char/serial.c	1998/11/03 02:07:19	1.1<br>
+++ drivers/char/serial.c	1998/11/04 04:34:34<br>
@@ -1653,6 +1653,8 @@<br>
 			return -EPERM;<br>
 		state-&gt;flags = ((state-&gt;flags &amp; ~ASYNC_USR_MASK) |<br>
 			       (new_serial.flags &amp; ASYNC_USR_MASK));<br>
+		info-&gt;flags = ((state-&gt;flags &amp; ~ASYNC_USR_MASK) |<br>
+			       (info-&gt;flags &amp; ASYNC_USR_MASK));<br>
 		state-&gt;custom_divisor = new_serial.custom_divisor;<br>
 		goto check_and_exit;<br>
 	}<br>
@@ -1660,8 +1662,9 @@<br>
 	new_serial.irq = irq_cannonicalize(new_serial.irq);<br>
 <br>
 	if ((new_serial.irq &gt;= NR_IRQS) || (new_serial.port &gt; 0xffff) ||<br>
-	    (new_serial.type &lt; PORT_UNKNOWN) ||<br>
-	    (new_serial.type &gt; PORT_MAX)) {<br>
+	    (new_serial.baud_base == 0) || (new_serial.type &lt; PORT_UNKNOWN) ||<br>
+	    (new_serial.type &gt; PORT_MAX) || (new_serial.type == PORT_CIRRUS) ||<br>
+	    (new_serial.type == PORT_STARTECH)) {<br>
 		return -EINVAL;<br>
 	}<br>
 <br>
===================================================================<br>
RCS file: include/linux/RCS/serial.h,v<br>
retrieving revision 1.1<br>
diff -u -r1.1 include/linux/serial.h<br>
--- include/linux/serial.h	1998/11/03 02:07:19	1.1<br>
+++ include/linux/serial.h	1998/11/03 02:28:15<br>
@@ -42,11 +42,11 @@<br>
 #define PORT_16450	2<br>
 #define PORT_16550	3<br>
 #define PORT_16550A	4<br>
-#define PORT_CIRRUS     5<br>
+#define PORT_CIRRUS     5	/* usurped by cyclades.c */<br>
 #define PORT_16650	6<br>
 #define PORT_16650V2	7<br>
 #define PORT_16750	8<br>
-#define PORT_STARTECH	9<br>
+#define PORT_STARTECH	9	/* usurped by cyclades.c */<br>
 #define PORT_MAX	9<br>
 <br>
 struct serial_uart_config {<br>
@@ -87,7 +87,7 @@<br>
 <br>
 #define ASYNC_LOW_LATENCY 0x2000 /* Request low latency behaviour */<br>
 <br>
-#define ASYNC_FLAGS	0x2FFF	/* Possible legal async flags */<br>
+#define ASYNC_FLAGS	0x3FFF	/* Possible legal async flags */<br>
 #define ASYNC_USR_MASK	0x3430	/* Legal flags that non-privileged<br>
 				 * users can set or reset */<br>
 <br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0387.html">Albert D. Cahalan: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0385.html">flewid: "Re: ppp and 2.1.126/2.1.125"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
