<!-- received="Wed Nov  4 04:19:52 1998 EET" -->
<!-- sent="Wed, 4 Nov 1998 01:18:17 +0100 (CET)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@e-mind.com" -->
<!-- subject="Re: arca-1-against-pre-2.1.127-3" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.96.981103235411.2168C-100000@dragon.bogus" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: arca-1-against-pre-2.1.127-3</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: arca-1-against-pre-2.1.127-3</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@e-mind.com"><i>andrea@e-mind.com</i></a>)<br>
<i>Wed, 4 Nov 1998 01:18:17 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#356">[ date ]</a><a href="index.html#356">[ thread ]</a><a href="subject.html#356">[ subject ]</a><a href="author.html#356">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0357.html">Brandon S. Allbery KF8NH: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0355.html">Andrea Arcangeli: "Re: [patch] my latest oom stuff"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Wed, 4 Nov 1998, Andrea Arcangeli wrote:<br>
<p>
<i>&gt;&gt;Just based on semantic considerations, timer_add()/timer_delete() makes</i><br>
<i>&gt;&gt;sense but timer_pending() makes races. In fact timer_pending() may just</i><br>
<p>
I looked where I was using timer_pending() (just to be sure for the race<br>
case).<br>
<p>
I fixed a bit more the aic7xxx misuse of the timer (I hope it will not<br>
cause fs corruption ;-). Here a fix against pre-2.1.127-3 (to allow people<br>
to comment it without having to download my whole arca-8). <br>
<p>
And Gerard, in _most_ of cases doing something if (!timer_pening()),<br>
doesn' t cause a race (because the timer is not set).<br>
<p>
Index: aic7xxx.c<br>
===================================================================<br>
RCS file: /var/cvs/linux/drivers/scsi/aic7xxx.c,v<br>
retrieving revision 1.1.1.3<br>
diff -u -r1.1.1.3 aic7xxx.c<br>
--- aic7xxx.c	1998/10/24 13:40:46	1.1.1.3<br>
+++ aic7xxx.c	1998/11/03 23:53:40<br>
@@ -3429,10 +3429,7 @@<br>
    * here so that we can delay all re-sent commands for this device for the<br>
    * 4 seconds and then have our timer routine pick them back up.<br>
    */<br>
-        if(p-&gt;dev_timer[i].expires)<br>
-        {<br>
-          del_timer(&amp;p-&gt;dev_timer[i]);<br>
-        }<br>
+        del_timer(&amp;p-&gt;dev_timer[i]);<br>
         p-&gt;dev_timer[i].expires = jiffies + (4 * HZ);<br>
         add_timer(&amp;p-&gt;dev_timer[i]);<br>
       }<br>
@@ -3481,12 +3478,8 @@<br>
             "delayed_scbs queue!\n", p-&gt;host_no, channel, i, lun);<br>
         scbq_init(&amp;p-&gt;delayed_scbs[i]);<br>
       }<br>
-      if ( (p-&gt;delayed_scbs[i].head == NULL) &amp;&amp;<br>
-           (p-&gt;dev_timer[i].expires) )<br>
-      {<br>
+      if ( p-&gt;delayed_scbs[i].head == NULL )<br>
         del_timer(&amp;p-&gt;dev_timer[i]);<br>
-        p-&gt;dev_timer[i].expires = 0;<br>
-      }<br>
     }<br>
   }<br>
 <br>
@@ -4007,7 +4000,7 @@<br>
     }<br>
     if ( (p-&gt;dev_active_cmds[tindex] &gt;=<br>
           p-&gt;dev_temp_queue_depth[tindex]) ||<br>
-         (p-&gt;dev_last_reset[tindex] &gt;= (jiffies - (4 * HZ))) )<br>
+         time_after_eq(p-&gt;dev_last_reset[tindex], jiffies - 4 * HZ) )<br>
     {<br>
 #ifdef AIC7XXX_VERBOSE_DEBUGGING<br>
       if (aic7xxx_verbose &gt; 0xffff)<br>
@@ -4015,7 +4008,7 @@<br>
                p-&gt;host_no, CTL_OF_SCB(scb));<br>
 #endif<br>
       scbq_insert_tail(&amp;p-&gt;delayed_scbs[tindex], scb);<br>
-      if ( !(p-&gt;dev_timer[tindex].expires) &amp;&amp;<br>
+      if ( !timer_pending(&amp;p-&gt;dev_timer[tindex]) &amp;&amp;<br>
            !(p-&gt;dev_active_cmds[tindex]) )<br>
       {<br>
         p-&gt;dev_timer[tindex].expires = p-&gt;dev_last_reset[tindex] + (4 * HZ);<br>
@@ -4154,15 +4147,8 @@<br>
 #endif<br>
   for(i=0; i&lt;MAX_TARGETS; i++)<br>
   {<br>
-    if ( (p-&gt;dev_timer[i].expires) &amp;&amp; <br>
-          (p-&gt;dev_timer[i].expires &lt;= jiffies) )<br>
+    if ( del_timer(&amp;p-&gt;dev_timer[i]) )<br>
     {<br>
-      p-&gt;dev_timer[i].expires = 0;<br>
-      if ( (p-&gt;dev_timer[i].prev != NULL) ||<br>
-           (p-&gt;dev_timer[i].next != NULL) )<br>
-      {<br>
-        del_timer(&amp;p-&gt;dev_timer[i]);<br>
-      }<br>
       p-&gt;dev_temp_queue_depth[i] =  p-&gt;dev_max_queue_depth[i];<br>
       j = 0;<br>
       while ( ((scb = scbq_remove_head(&amp;p-&gt;delayed_scbs[i])) != NULL) &amp;&amp;<br>
@@ -4895,7 +4881,7 @@<br>
               p-&gt;activescbs--;<br>
               scb-&gt;flags |= SCB_WAITINGQ | SCB_WAS_BUSY;<br>
                   <br>
-              if (p-&gt;dev_timer[tindex].expires == 0) <br>
+              if ( !timer_pending(&amp;p-&gt;dev_timer[tindex]) ) <br>
               {<br>
                 if ( p-&gt;dev_active_cmds[tindex] )<br>
                 {<br>
@@ -7462,7 +7448,7 @@<br>
   }<br>
 <br>
   p-&gt;host = host;<br>
-  p-&gt;last_reset = 0;<br>
+  p-&gt;last_reset = jiffies;<br>
   p-&gt;host_no = host-&gt;host_no;<br>
   host-&gt;unique_id = p-&gt;instance;<br>
   p-&gt;isr_count = 0;<br>
@@ -7489,7 +7475,7 @@<br>
     p-&gt;dev_commands_sent[i] = 0;<br>
     p-&gt;dev_flags[i] = 0;<br>
     p-&gt;dev_active_cmds[i] = 0;<br>
-    p-&gt;dev_last_reset[i] = 0;<br>
+    p-&gt;dev_last_reset[i] = jiffies;<br>
     p-&gt;dev_last_queue_full[i] = 0;<br>
     p-&gt;dev_last_queue_full_count[i] = 0;<br>
     p-&gt;dev_max_queue_depth[i] = 1;<br>
@@ -7497,7 +7483,6 @@<br>
     p-&gt;dev_mid_level_queue_depth[i] = 3;<br>
     scbq_init(&amp;p-&gt;delayed_scbs[i]);<br>
     init_timer(&amp;p-&gt;dev_timer[i]);<br>
-    p-&gt;dev_timer[i].expires = 0;<br>
     p-&gt;dev_timer[i].data = (unsigned long)p;<br>
     p-&gt;dev_timer[i].function = (void *)aic7xxx_timer;<br>
   }<br>
<p>
<p>
My arca-8 is out and fix the aic this way + rejects the FP_IMPOSSIBLE<br>
logic (but not yet s/KERNEL/USER since I guess I would duplicate Linus's <br>
work doing that now).<br>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0357.html">Brandon S. Allbery KF8NH: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0355.html">Andrea Arcangeli: "Re: [patch] my latest oom stuff"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
