<!-- received="Tue Nov  3 23:35:18 1998 EET" -->
<!-- sent="Tue, 3 Nov 1998 17:53:44 -0300" -->
<!-- name="Juanjo Ciarlante" -->
<!-- email="irriga@impsat1.com.ar" -->
<!-- subject="[PATCH] IP masq csum fix" -->
<!-- id="" -->
<!-- inreplyto="E0zajg6-00064V-00@devel2.axiom.internal" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] IP masq csum fix</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] IP masq csum fix</h1>
<b>Juanjo Ciarlante</b> (<a href="mailto:irriga@impsat1.com.ar"><i>irriga@impsat1.com.ar</i></a>)<br>
<i>Tue, 3 Nov 1998 17:53:44 -0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#305">[ date ]</a><a href="index.html#305">[ thread ]</a><a href="subject.html#305">[ subject ]</a><a href="author.html#305">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0306.html">H. Peter Anvin: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0304.html">Linus Torvalds: "Re: [patch] my latest oom stuff"</a>
<li> <b>In reply to:</b> <a href="0276.html">David Woodhouse: "Re: Either the IP masq code or my brain is broken."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--BOKacYhQ+x31HxR3<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
On Tue, Nov 03, 1998 at 04:51:34PM +0000, David Woodhouse wrote:<br>
<i>&gt; Thanks to Juanjo and Andi, I think this problem is now fixed.</i><br>
<i>&gt; </i><br>
<i>&gt; I think both of you simultaneously came up with the idea that the offset of </i><br>
<i>&gt; the data payload (proto_doff) could be negative, causing csum_partial() to </i><br>
<i>&gt; checksum the whole of physical memory before oopsing.</i><br>
<i>&gt; </i><br>
This patch fixes incorrect ip_masq csuming when faced with corrupted pkts.<br>
<p>
It have been succesfully tested by David "tortured-by-Oops" Woodhouse, <br>
his Oops have stopped so apparently it did fix the problem <br>
(_apart_ from the "apparent-fix" its a REAL code fix).<br>
<p>
Linus, could you please apply it?<br>
<p>
<pre>
-- 
-- Juanjo       <a href="http://juanjox.home.ml.org/">http://juanjox.home.ml.org/</a>
<p>
                  == free collective power ==---.
                             Linux &lt;------------'
<p>
--BOKacYhQ+x31HxR3
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="ip_masq-doff-v3.patch"
<p>
<p>
Basically, this patch does an ``anal-tappo'' protocol data size
check at ip_fw_*masq() entry path.
<p>
<p>
--- linux/net/ipv4/ip_masq.c.dist	Fri Oct 23 10:39:57 1998
+++ linux/net/ipv4/ip_masq.c	Tue Nov  3 17:15:36 1998
@@ -337,6 +337,9 @@
 #define PORT_MASQ_MUL 10
 #endif
 
+/*
+ *	At the moment, hardcore in sync with masq_proto_num
+ */
 atomic_t ip_masq_free_ports[3] = {
         ATOMIC_INIT((PORT_MASQ_END-PORT_MASQ_BEGIN) * PORT_MASQ_MUL),/* UDP */
         ATOMIC_INIT((PORT_MASQ_END-PORT_MASQ_BEGIN) * PORT_MASQ_MUL),/* TCP */
@@ -960,15 +963,40 @@
         return NULL;
 }
 
-static __inline__ unsigned proto_doff(unsigned proto, char *th)
+/*
+ *	Get transport protocol data offset, check against size
+ */
+static __inline__ int proto_doff(unsigned proto, char *th, unsigned size)
 {
+	unsigned ret = -1;
 	switch (proto) {
+		case IPPROTO_ICMP:
+			if (size &gt;= sizeof(struct icmphdr))
+				ret = sizeof(struct icmphdr);
+			break;
 		case IPPROTO_UDP:
-			return sizeof(struct udphdr);
+			if (size &gt;= sizeof(struct udphdr))
+				ret = sizeof(struct udphdr);
+			break;
 		case IPPROTO_TCP:
-			return ((struct tcphdr*)th)-&gt;doff &lt;&lt; 2;
+			/*
+			*	Is this case, this check _also_ avoids
+			*	touching an invalid pointer if 
+			*	size is invalid
+			*/
+			if (size &gt;= sizeof(struct tcphdr)) {
+				ret = ((struct tcphdr*)th)-&gt;doff &lt;&lt; 2;
+				if (ret &gt; size) {
+					ret = -1 ;
+				}
+			}
+
+			break;
 	}
-	return 0;
+	if (ret &lt; 0)
+		IP_MASQ_DEBUG(0, "mess proto_doff for proto=%d, size =%d\n",
+			proto, size);
+	return ret;
 }
 
 int ip_fw_masquerade(struct sk_buff **skb_p, __u32 maddr)
@@ -980,19 +1008,26 @@
 	int		size;
 
 	/* 
-	 * 	Magic "doff" csum semantics
-	 *		!0: saved payload csum IS valid, doff is correct
-	 *		0: csum not valid
+	 * 	doff holds transport protocol data offset
+	 *	csum holds its checksum
+	 *	csum_ok says if csum is valid
 	 */
-	unsigned doff = 0;
+	int doff = 0;
 	int csum = 0;
+	int csum_ok = 0;
 
 	/*
 	 * We can only masquerade protocols with ports... and hack some ICMPs
 	 */
 
 	h.raw = (char*) iph + iph-&gt;ihl * 4;
+	size = ntohs(iph-&gt;tot_len) - (iph-&gt;ihl * 4);
 
+	doff = proto_doff(iph-&gt;protocol, h.raw, size);
+	if (doff &lt; 0) {
+		IP_MASQ_DEBUG(0, "O-pkt invalid packet data size\n");
+		return -1;
+	}
 	switch (iph-&gt;protocol) {
 	case IPPROTO_ICMP:
 		return(ip_fw_masq_icmp(skb_p, maddr));
@@ -1002,7 +1037,6 @@
 			break;
 	case IPPROTO_TCP:
 		/* Make sure packet is in the masq range */
-		size = ntohs(iph-&gt;tot_len) - (iph-&gt;ihl * 4);
 		IP_MASQ_DEBUG(3, "O-pkt: %s size=%d\n",
 				masq_proto_name(iph-&gt;protocol),
 				size);
@@ -1011,7 +1045,7 @@
 		switch (skb-&gt;ip_summed)
 		{
 			case CHECKSUM_NONE:
-				doff = proto_doff(iph-&gt;protocol, h.raw);
+				csum_ok++;
 				csum = csum_partial(h.raw + doff, size - doff, 0);
 				IP_MASQ_DEBUG(3, "O-pkt: %s I-datacsum=%d\n",
 						masq_proto_name(iph-&gt;protocol),
@@ -1133,7 +1167,7 @@
 	 */
 
 	if (ms-&gt;app) 
-		doff = 0;
+		csum_ok = 0;
 
  	/*
  	 *	Attempt ip_masq_app call.
@@ -1148,6 +1182,7 @@
                 iph = skb-&gt;nh.iph;
 		h.raw = (char*) iph + iph-&gt;ihl *4;
                 size = skb-&gt;len - (h.raw - skb-&gt;nh.raw);
+		/* doff should have not changed */
         }
 
  	/*
@@ -1158,8 +1193,7 @@
 	 *	Transport's payload partial csum
 	 */
 
-	if (!doff) {
-		doff = proto_doff(iph-&gt;protocol, h.raw);
+	if (!csum_ok) {
 		csum = csum_partial(h.raw + doff, size - doff, 0);
 	}
 	skb-&gt;csum = csum;
@@ -1710,8 +1744,9 @@
 	union ip_masq_tphdr h;
 	struct ip_masq	*ms;
 	unsigned short size;
-	unsigned doff = 0;
+	int doff = 0;
 	int csum = 0;
+	int csum_ok = 0;
 	__u32 maddr;
 
 	/*
@@ -1727,8 +1762,19 @@
 		return 0;
 	}
 
-	maddr = iph-&gt;daddr;
 	h.raw = (char*) iph + iph-&gt;ihl * 4;
+	/*
+	 *	IP payload size
+	 */
+	size = ntohs(iph-&gt;tot_len) - (iph-&gt;ihl * 4);
+
+	doff = proto_doff(iph-&gt;protocol, h.raw, size);
+	if (doff &lt; 0) {
+		IP_MASQ_DEBUG(0, "I-pkt invalid packet data size\n");
+		return -1;
+	}
+
+	maddr = iph-&gt;daddr;
 
 	switch (iph-&gt;protocol) {
 	case IPPROTO_ICMP:
@@ -1749,7 +1795,6 @@
 			return 0;
 
 		/* Check that the checksum is OK */
-		size = ntohs(iph-&gt;tot_len) - (iph-&gt;ihl * 4);
 		if ((iph-&gt;protocol == IPPROTO_UDP) &amp;&amp; (h.uh-&gt;check == 0))
 			/* No UDP checksum */
 			break;
@@ -1757,8 +1802,8 @@
 		switch (skb-&gt;ip_summed)
 		{
 			case CHECKSUM_NONE:
-				doff = proto_doff(iph-&gt;protocol, h.raw);
 				csum = csum_partial(h.raw + doff, size - doff, 0);
+				csum_ok++;
 				skb-&gt;csum = csum_partial(h.raw , doff, csum);
 
 			case CHECKSUM_HW:
@@ -1846,7 +1891,7 @@
 		 */
 
 		if (ms-&gt;app) 
-			doff = 0;
+			csum_ok = 0;
 
                 /*
                  *	Attempt ip_masq_app call.
@@ -1873,8 +1918,7 @@
 		 *	Transport's payload partial csum
 		 */
 
-		if (!doff) {
-			doff = proto_doff(iph-&gt;protocol, h.raw);
+		if (!csum_ok) {
 			csum = csum_partial(h.raw + doff, size - doff, 0);
 		}
 		skb-&gt;csum = csum;
<p>
--BOKacYhQ+x31HxR3--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0306.html">H. Peter Anvin: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0304.html">Linus Torvalds: "Re: [patch] my latest oom stuff"</a>
<li> <b>In reply to:</b> <a href="0276.html">David Woodhouse: "Re: Either the IP masq code or my brain is broken."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
