<!-- received="Tue Nov  3 13:51:03 1998 EET" -->
<!-- sent="Tue, 3 Nov 1998 12:43:53 +0100 (MET)" -->
<!-- name="Rogier Wolff" -->
<!-- email="R.E.Wolff@BitWizard.nl" -->
<!-- subject="Specialix IO8+/PCI support." -->
<!-- id="199811031143.MAA02089@cave.BitWizard.nl" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: Specialix IO8+/PCI support.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Specialix IO8+/PCI support.</h1>
<b>Rogier Wolff</b> (<a href="mailto:R.E.Wolff@BitWizard.nl"><i>R.E.Wolff@BitWizard.nl</i></a>)<br>
<i>Tue, 3 Nov 1998 12:43:53 +0100 (MET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#230">[ date ]</a><a href="index.html#230">[ thread ]</a><a href="subject.html#230">[ subject ]</a><a href="author.html#230">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0231.html">Matthias Urlichs: "Re: NFS read performance ugliness"</a>
<li> <b>Previous message:</b> <a href="0229.html">Richard Gooch: "Re: Device driver scheduling time"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus,<br>
<p>
Could you include the specialix IO8+/PCI patch into 2.1.xxx? It now has<br>
had the official approval from Specialix. It adds support for the PCI<br>
version of the specialix IO8+ card.<br>
<p>
(If the below doesn't patch in OK due to mail-mangling, you can tell <br>
me, and I'll gzip/uuencode it for you (but this way you can read it<br>
immediately without unpacking) or you can get it yourself from <br>
    <a href="ftp://ftp.bitwizard.nl/specialix/specialix-2.1.124-1.10.patch">ftp://ftp.bitwizard.nl/specialix/specialix-2.1.124-1.10.patch</a><br>
)<br>
<p>
<p>
So far, you dropped this once without feedback. Resend timer set for<br>
november fifth.<br>
<p>
Thanks,<br>
<p>
<p>
Roger Wolff. <br>
<p>
--------------------------------------------------------------------<br>
<p>
diff -ur linux-2.1.124.clean/Documentation/Configure.help linux/Documentation/Configure.help<br>
--- linux-2.1.124.clean/Documentation/Configure.help	Sun Oct  4 19:21:45 1998<br>
+++ linux/Documentation/Configure.help	Sat Oct 31 13:20:30 1998<br>
@@ -7158,10 +7158,10 @@<br>
 <br>
 Specialix IO8+ card support<br>
 CONFIG_SPECIALIX<br>
-  This is a driver for the Specialix IO8+ multiport card which gives<br>
-  you many serial ports. You would need something like this to <br>
-  connect more than two modems to your Linux box, for instance in<br>
-  order to become a BBS. <br>
+  This is a driver for the Specialix IO8+ multiport card (both the<br>
+  ISA and the PCI version) which gives you many serial ports. You <br>
+  would need something like this to connect more than two modems to <br>
+  your Linux box, for instance in order to become a BBS. <br>
 <br>
   If you have a card like that, say Y here and read the file<br>
   Documentation/specialix.txt. Also it's possible to say M here and<br>
diff -ur linux-2.1.124.clean/Documentation/specialix.txt linux/Documentation/specialix.txt<br>
--- linux-2.1.124.clean/Documentation/specialix.txt	Tue Apr 28 23:22:04 1998<br>
+++ linux/Documentation/specialix.txt	Thu Oct 15 10:57:21 1998<br>
@@ -17,7 +17,10 @@<br>
       written by Dmitry Gorodchanin. The specialix IO8+ card<br>
       programming information was obtained from the CL-CD1865 Data<br>
       Book, and Specialix document number 6200059: IO8+ Hardware<br>
-      Functional Specification.<br>
+      Functional Specification, augmented by document number 6200088:<br>
+      Merak Hardware Functional Specification. (IO8+/PCI is also <br>
+      called Merak)<br>
+<br>
 <br>
       This program is free software; you can redistribute it and/or<br>
       modify it under the terms of the GNU General Public License as<br>
@@ -67,6 +70,9 @@<br>
 other computer runs just fine with the Specialix card at 0x100....<br>
 The card occupies 4 addresses, but actually only two are really used.<br>
 <br>
+The PCI version doesn't have any dip switches. The BIOS assigns<br>
+an IO address. <br>
+<br>
 The driver now still autoprobes at 0x100, 0x180, 0x250 and 0x260.  If<br>
 that causes trouble for you, please report that. I'll remove<br>
 autoprobing then.<br>
@@ -75,6 +81,9 @@<br>
 change any jumpers to change the IRQ. Just use a command line<br>
 argument (irq=xx) to the insmod program to set the interrupt.<br>
 <br>
+The BIOS assigns the IRQ on the PCI version. You have no say in what<br>
+IRQ to use in that case. <br>
+<br>
 If your specialix cards are not at the default locations, you can use<br>
 the kernel command line argument "specialix=io0,irq0,io1,irq1...".<br>
 Here "io0" is the io address for the first card, and "irq0" is the<br>
@@ -99,6 +108,32 @@<br>
 <br>
 in your /etc/lilo.conf file if you use lilo. <br>
 <br>
+The Specialix driver is slightly odd: It allows you to have the second<br>
+or third card detected without having a first card. This has<br>
+advantages and disadvantages. A slot that isn't filled by an ISA card,<br>
+might be filled if a PCI card is detected. Thus if you have an ISA<br>
+card at 0x250 and a PCI card, you would get:<br>
+<br>
+sx0: specialix IO8+ Board at 0x100 not found.<br>
+sx1: specialix IO8+ Board at 0x180 not found.<br>
+sx2: specialix IO8+ board detected at 0x250, IRQ 12, CD1865 Rev. B.<br>
+sx3: specialix IO8+ Board at 0x260 not found.<br>
+sx0: specialix IO8+ board detected at 0xd800, IRQ 9, CD1865 Rev. B.<br>
+<br>
+This would happen if you don't give any probe hints to the driver. <br>
+If you would specify:<br>
+<br>
+   specialix=0x250,11<br>
+<br>
+you'd get the following messages:<br>
+<br>
+sx0: specialix IO8+ board detected at 0x250, IRQ 11, CD1865 Rev. B.<br>
+sx1: specialix IO8+ board detected at 0xd800, IRQ 9, CD1865 Rev. B.<br>
+<br>
+ISA probing is aborted after the IO address you gave is exhausted, and<br>
+the PCI card is now detected as the second card. The ISA card is now<br>
+also forced to IRQ11....<br>
+<br>
 <br>
 Baud rates<br>
 ==========<br>
@@ -118,20 +153,26 @@<br>
 If you near the "limit" you will first start to see a graceful<br>
 degradation in that the chip cannot keep the transmitter busy at all<br>
 times. However with a central clock this slow, you can also get it to<br>
-miss incoming characters.<br>
+miss incoming characters. The driver will print a warning message when<br>
+you are outside the official specs. The messages usually show up in<br>
+the file /var/log/messages .<br>
 <br>
 The specialix card cannot reliably do 115k2. If you use it, you have<br>
 to do "extensive testing" (*) to verify if it actually works.<br>
 <br>
 When "mgetty" communicates with my modem at 115k2 it reports:<br>
 got: +++[0d]ATQ0V1H0[0d][0d][8a]O[cb][0d][8a]<br>
-                            ^^^^ ^^^^ ^^^^ <br>
+                            ^^^^ ^^^^    ^^^^ <br>
 <br>
 The three characters that have the "^^^" under them have suffered a<br>
 bit error in the highest bit. In conclusion: I've tested it, and found<br>
 that it simply DOESN'T work for me. I also suspect that this is also<br>
 caused by the baud rate being just a little bit out of tune. <br>
 <br>
+I upgraded the crystal to 66Mhz on one of my Specialix cards. Works<br>
+great! Contact me for details. (Voids warranty, requires a steady hand<br>
+and more such restrictions....)<br>
+<br>
 <br>
 (*) Cirrus logic CD1864 databook, page 40.<br>
 <br>
@@ -248,7 +289,7 @@<br>
 Ports and devices<br>
 =================<br>
 <br>
-Port 0 is the one furthest from the ISA connector.<br>
+Port 0 is the one furthest from the card-edge connector.<br>
 <br>
 Devices:<br>
 <br>
@@ -265,10 +306,20 @@<br>
 done<br>
 echo ""<br>
 <br>
+If your system doesn't come with these devices preinstalled, bug your<br>
+linux-vendor about this. They have had ample time to get this<br>
+implemented by now.<br>
 <br>
 You cannot have more than 4 boards in one computer. The card only<br>
 supports 4 different interrupts. If you really want this, contact me<br>
 about this and I'll give you a few tips (requires soldering iron)....<br>
+<br>
+If you have enough PCI slots, you can probably use more than 4 PCI<br>
+versions of the card though.... <br>
+<br>
+The PCI version of the card cannot adhere to the mechanical part of<br>
+the PCI spec because the 8 serial connectors are simply too large. If<br>
+it doesn't fit in your computer, bring back the card.<br>
 <br>
 <br>
 ------------------------------------------------------------------------<br>
diff -ur linux-2.1.124.clean/drivers/char/specialix.c linux/drivers/char/specialix.c<br>
--- linux-2.1.124.clean/drivers/char/specialix.c	Wed May  6 19:56:03 1998<br>
+++ linux/drivers/char/specialix.c	Tue Nov  3 11:54:03 1998<br>
@@ -58,10 +58,15 @@<br>
  *                Made many more debug printk's a compile time option.<br>
  * Revision 1.8:  Jul 1  1997<br>
  *                port to linux-2.1.43 kernel.<br>
+ * Revision 1.9:  Oct 9  1998<br>
+ *                Added stuff for the IO8+/PCI version. . <br>
+ * Revision 1.10: Nov 3  1998<br>
+ *                Now also check for the subsystem ID: prevents detecting<br>
+ *                SX cards as if they are IO8+/PCI.<br>
  * <br>
  */<br>
 <br>
-#define VERSION "1.8"<br>
+#define VERSION "1.10"<br>
 <br>
 <br>
 /*<br>
@@ -87,6 +92,7 @@<br>
 #include &lt;linux/delay.h&gt;<br>
 #include &lt;linux/tqueue.h&gt;<br>
 #include &lt;linux/version.h&gt;<br>
+#include &lt;linux/pci.h&gt;<br>
 <br>
 <br>
 /* ************************************************************** */<br>
@@ -173,7 +179,6 @@<br>
 #define SPECIALIX_TYPE_NORMAL	1<br>
 #define SPECIALIX_TYPE_CALLOUT	2<br>
 <br>
-static struct specialix_board * IRQ_to_board[16] = { NULL, } ;<br>
 static struct tty_driver specialix_driver, specialix_callout_driver;<br>
 static int    specialix_refcount = 0;<br>
 static struct tty_struct * specialix_table[SX_NBOARD * SX_NPORT] = { NULL, };<br>
@@ -331,17 +336,22 @@<br>
 <br>
 extern inline void sx_request_io_range(struct specialix_board * bp)<br>
 {<br>
-	request_region(bp-&gt;base, SX_IO_SPACE, "specialix IO8+" );<br>
+	request_region(bp-&gt;base, <br>
+	               bp-&gt;flags&amp;SX_BOARD_IS_PCI?SX_PCI_IO_SPACE:SX_IO_SPACE,<br>
+	               "specialix IO8+" );<br>
 }<br>
 <br>
 <br>
 extern inline void sx_release_io_range(struct specialix_board * bp)<br>
 {<br>
-	release_region(bp-&gt;base, SX_IO_SPACE);<br>
+	release_region(bp-&gt;base, <br>
+	               bp-&gt;flags&amp;SX_BOARD_IS_PCI?SX_PCI_IO_SPACE:SX_IO_SPACE);<br>
 }<br>
 <br>
 	<br>
 /* Must be called with enabled interrupts */<br>
+/* Ugly. Very ugly. Don't use this for anything else than initialization <br>
+   code */<br>
 extern inline void sx_long_delay(unsigned long delay)<br>
 {<br>
 	unsigned long i;<br>
@@ -357,6 +367,8 @@<br>
 	int virq;<br>
 	int i;<br>
 <br>
+	if (bp-&gt;flags &amp; SX_BOARD_IS_PCI) <br>
+		return 1;<br>
 	switch (bp-&gt;irq) {<br>
 	/* In the same order as in the docs... */<br>
 	case 15: virq = 0;break;<br>
@@ -484,9 +496,14 @@<br>
 	printk (KERN_DEBUG "sx%d: DSR lines are: %02x, rts lines are: %02x\n", <br>
 	        board_No(bp),  val1, val2);<br>
 #endif<br>
-	if (val1 != 0xb2) {<br>
-		printk(KERN_INFO "sx%d: specialix IO8+ ID at 0x%03x not found.\n",<br>
-		       board_No(bp), bp-&gt;base);<br>
+	/* They managed to switch the bit order between the docs and<br>
+	   the IO8+ card. The new PCI card now conforms to old docs.<br>
+	   They changed the PCI docs to reflect the situation on the<br>
+	   old card. */<br>
+	val2 = (bp-&gt;flags &amp; SX_BOARD_IS_PCI)?0x4d : 0xb2;<br>
+	if (val1 != val2) {<br>
+		printk(KERN_INFO "sx%d: specialix IO8+ ID %02x at 0x%03x not found (%02x).\n",<br>
+		       board_No(bp), val2, bp-&gt;base, val1);<br>
 		return 1;<br>
 	}<br>
 <br>
@@ -868,7 +885,7 @@<br>
 	unsigned long loop = 0;<br>
 	int saved_reg;<br>
 <br>
-	bp = IRQ_to_board[irq];<br>
+	bp = dev_id;<br>
 	<br>
 	if (!bp || !(bp-&gt;flags &amp; SX_BOARD_ACTIVE)) {<br>
 #ifdef SPECIALIX_DEBUG <br>
@@ -924,6 +941,25 @@<br>
  *  Routines for open &amp; close processing.<br>
  */<br>
 <br>
+void turn_ints_off (struct specialix_board *bp)<br>
+{<br>
+	if (bp-&gt;flags &amp; SX_BOARD_IS_PCI) {<br>
+		/* This was intended for enabeling the interrupt on the<br>
+		 * PCI card. However it seems that it's already enabled<br>
+		 * and as PCI interrupts can be shared, there is no real<br>
+		 * reason to have to turn it off. */<br>
+	}<br>
+	(void) sx_in_off (bp, 0); /* Turn off interrupts. */<br>
+}<br>
+<br>
+void turn_ints_on (struct specialix_board *bp)<br>
+{<br>
+	if (bp-&gt;flags &amp; SX_BOARD_IS_PCI) {<br>
+		/* play with the PCI chip. See comment above. */<br>
+	}<br>
+	(void) sx_in (bp, 0); /* Turn ON interrupts. */<br>
+}<br>
+<br>
 <br>
 /* Called with disabled interrupts */<br>
 extern inline int sx_setup_board(struct specialix_board * bp)<br>
@@ -933,14 +969,12 @@<br>
 	if (bp-&gt;flags &amp; SX_BOARD_ACTIVE) <br>
 		return 0;<br>
 <br>
-	error = request_irq(bp-&gt;irq, sx_interrupt, SA_INTERRUPT, "specialix IO8+", NULL);<br>
+	error = request_irq(bp-&gt;irq, sx_interrupt, SA_INTERRUPT, "specialix IO8+", bp);<br>
 <br>
 	if (error) <br>
 		return error;<br>
 <br>
-	IRQ_to_board[bp-&gt;irq] = bp;<br>
-	(void) sx_in (bp, 0); /* Turn ON interrupts. */<br>
-<br>
+	turn_ints_on (bp);<br>
 	bp-&gt;flags |= SX_BOARD_ACTIVE;<br>
 <br>
 	MOD_INC_USE_COUNT;<br>
@@ -956,11 +990,13 @@<br>
 	<br>
 	bp-&gt;flags &amp;= ~SX_BOARD_ACTIVE;<br>
 	<br>
-	free_irq(bp-&gt;irq, NULL);<br>
-	(void) sx_in_off (bp, 0); /* Turn off interrupts. */<br>
+#if SPECIALIX_DEBUG &gt; 2<br>
+	printk ("Freeing IRQ%d for board %d.\n", bp-&gt;irq, board_No (bp));<br>
+#endif<br>
+	free_irq(bp-&gt;irq, bp);<br>
+<br>
+	turn_ints_off (bp);<br>
 <br>
-	IRQ_to_board[bp-&gt;irq] = NULL;<br>
-	<br>
 	MOD_DEC_USE_COUNT;<br>
 }<br>
 <br>
@@ -1045,12 +1081,14 @@<br>
 		/* Page 48 of version 2.0 of the CL-CD1865 databook */<br>
 		if (tmp &gt;= 12) {<br>
 			printk (KERN_INFO "sx%d: Baud rate divisor is %ld. \n"<br>
-			        "Performance degradation is possible.\n",<br>
+			        "Performance degradation is possible.\n"<br>
+			        "Read specialix.txt for more info.\n",<br>
 			        port_No (port), tmp);<br>
 		} else {<br>
 			printk (KERN_INFO "sx%d: Baud rate divisor is %ld. \n"<br>
 			        "Warning: overstressing Cirrus chip. "<br>
-                                "This might not work.\n", <br>
+			        "This might not work.\n"<br>
+			        "Read specialix.txt for more info.\n", <br>
 			        port_No (port), tmp);<br>
 		}<br>
 	}<br>
@@ -2153,7 +2191,6 @@<br>
 		return 1;<br>
 	}<br>
 	init_bh(SPECIALIX_BH, do_specialix_bh);<br>
-	memset(IRQ_to_board, 0, sizeof(IRQ_to_board));<br>
 	memset(&amp;specialix_driver, 0, sizeof(specialix_driver));<br>
 	specialix_driver.magic = TTY_DRIVER_MAGIC;<br>
 	specialix_driver.name = "ttyW";<br>
@@ -2265,7 +2302,7 @@<br>
 	int i;<br>
 	int found = 0;<br>
 <br>
-	printk(KERN_INFO "sx: Specialix IO8+ driver v" VERSION ", (c) R.E.Wolff 1997.\n");<br>
+	printk(KERN_INFO "sx: Specialix IO8+ driver v" VERSION ", (c) R.E.Wolff 1997/1998.\n");<br>
 	printk(KERN_INFO "sx: derived from work (c) D.Gorodchanin 1994-1996.\n");<br>
 #ifdef CONFIG_SPECIALIX_RTSCTS<br>
 	printk (KERN_INFO "sx: DTR/RTS pin is always RTS.\n");<br>
@@ -2280,6 +2317,42 @@<br>
 		if (sx_board[i].base &amp;&amp; !sx_probe(&amp;sx_board[i]))<br>
 			found++;<br>
 <br>
+#ifdef CONFIG_PCI<br>
+	if (pci_present()) {<br>
+		struct pci_dev *pdev = NULL;<br>
+		unsigned int tint;<br>
+		unsigned short tshort;<br>
+<br>
+		i=0;<br>
+		while (i &lt;= SX_NBOARD) {<br>
+			if (sx_board[i].flags &amp; SX_BOARD_PRESENT) {<br>
+				i++;<br>
+				continue;<br>
+			}<br>
+			pdev = pci_find_device (PCI_VENDOR_ID_SPECIALIX, <br>
+			                        PCI_DEVICE_ID_SPECIALIX_SX_XIO_IO8, <br>
+			                        pdev);<br>
+			if (!pdev) break;<br>
+<br>
+			/* Specialix has a whole bunch of cards with<br>
+			   0x2000 as the device ID. They say its because<br>
+			   the standard requires it. Stupid standard. */<br>
+			pci_read_config_word (pdev, PCI_SUBSYSTEM_ID, &amp;tshort);<br>
+			if (tshort != 0xb008) continue;<br>
+<br>
+			sx_board[i].irq = pdev-&gt;irq;<br>
+<br>
+			pci_read_config_dword(pdev, PCI_BASE_ADDRESS_2, &amp;tint);<br>
+			/* Mask out the fact that it's IO-space */<br>
+			sx_board[i].base = tint &amp; PCI_BASE_ADDRESS_IO_MASK; <br>
+<br>
+			sx_board[i].flags |= SX_BOARD_IS_PCI;<br>
+			if (!sx_probe(&amp;sx_board[i]))<br>
+				found ++;<br>
+		}<br>
+	}<br>
+#endif<br>
+<br>
 	if (!found) {<br>
 		sx_release_drivers();<br>
 		printk(KERN_INFO "sx: No specialix IO8+ boards detected.\n");<br>
@@ -2296,7 +2369,8 @@<br>
 <br>
 /*<br>
  * You can setup up to 4 boards.<br>
- * by specifying "iobase=0xXXX iobase1=0xXXX ..." as insmod parameter.<br>
+ * by specifying "iobase=0xXXX,0xXXX ..." as insmod parameter.<br>
+ * You should specify the IRQs too in that case "irq=....,...". <br>
  * <br>
  * More than 4 boards in one computer is not possible, as the card can<br>
  * only use 4 different interrupts. <br>
diff -ur linux-2.1.124.clean/drivers/char/specialix_io8.h linux/drivers/char/specialix_io8.h<br>
--- linux-2.1.124.clean/drivers/char/specialix_io8.h	Sun Oct 18 17:40:43 1998<br>
+++ linux/drivers/char/specialix_io8.h	Thu Oct 15 11:51:54 1998<br>
@@ -43,9 +43,16 @@<br>
 <br>
 #ifdef __KERNEL__<br>
 <br>
-#define SX_NBOARD		4<br>
+/* You can have max 4 ISA cards in one PC, and I recommend not much <br>
+more than a few  PCI versions of the card. */<br>
+<br>
+#define SX_NBOARD		8<br>
+<br>
 /* NOTE: Specialix decoder recognizes 4 addresses, but only two are used.... */<br>
 #define SX_IO_SPACE             4<br>
+/* The PCI version decodes 8 addresses, but still only 2 are used. */<br>
+#define SX_PCI_IO_SPACE         8<br>
+<br>
 /* eight ports per board. */<br>
 #define SX_NPORT        	8<br>
 #define SX_BOARD(line)		((line) / SX_NPORT)<br>
@@ -93,6 +100,7 @@<br>
 <br>
 #define SX_BOARD_PRESENT	0x00000001<br>
 #define SX_BOARD_ACTIVE		0x00000002<br>
+#define SX_BOARD_IS_PCI		0x00000004<br>
 <br>
 <br>
 struct specialix_port {<br>
diff -ur linux-2.1.124.clean/drivers/pci/oldproc.c linux/drivers/pci/oldproc.c<br>
--- linux-2.1.124.clean/drivers/pci/oldproc.c	Wed Sep 16 22:25:57 1998<br>
+++ linux/drivers/pci/oldproc.c	Tue Nov  3 11:46:43 1998<br>
@@ -399,6 +399,7 @@<br>
 	DEVICE( LITEON,		LITEON_LNE100TX,"LNE100TX"),<br>
 	DEVICE( NP,		NP_PCI_FDDI,	"NP-PCI"),       <br>
 	DEVICE( ATT,		ATT_L56XMF,	"L56xMF"),<br>
+	DEVICE( SPECIALIX,	SPECIALIX_SX_XIO_IO8,	"SX/XIO/IO8+"),<br>
 	DEVICE( SPECIALIX,	SPECIALIX_XIO,	"XIO/SIO host"),<br>
 	DEVICE( SPECIALIX,	SPECIALIX_RIO,	"RIO host"),<br>
 	DEVICE( AURAVISION,	AURAVISION_VXP524,"VXP524"),<br>
diff -ur linux-2.1.124.clean/include/linux/pci.h linux/include/linux/pci.h<br>
--- linux-2.1.124.clean/include/linux/pci.h	Sun Oct 18 17:03:53 1998<br>
+++ linux/include/linux/pci.h	Tue Nov  3 11:45:11 1998<br>
@@ -841,6 +841,7 @@<br>
 #define PCI_DEVICE_ID_ATT_L56XMF	0x0440<br>
 <br>
 #define PCI_VENDOR_ID_SPECIALIX		0x11cb<br>
+#define PCI_DEVICE_ID_SPECIALIX_SX_XIO_IO8	0x2000<br>
 #define PCI_DEVICE_ID_SPECIALIX_XIO	0x4000<br>
 #define PCI_DEVICE_ID_SPECIALIX_RIO	0x8000<br>
 <br>
<p>
<pre>
-- 
| Most people would die sooner than think....  |    <a href="mailto:R.E.Wolff@BitWizard.nl">R.E.Wolff@BitWizard.nl</a> 
| in fact, most do.  -- Bertrand Russsell      |     phone: +31-15-2137555 
We write Linux device drivers for any device you may have! fax: ..-2138217
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0231.html">Matthias Urlichs: "Re: NFS read performance ugliness"</a>
<li> <b>Previous message:</b> <a href="0229.html">Richard Gooch: "Re: Device driver scheduling time"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
