<!-- received="Tue Nov  3 11:21:48 1998 EET" -->
<!-- sent="Tue, 3 Nov 1998 10:10:08 +0100 (MET)" -->
<!-- name="Jakub Jelinek" -->
<!-- email="jj@sunsite.ms.mff.cuni.cz" -->
<!-- subject="[PATCH] A new version of the sys_swapon bugfix" -->
<!-- id="199811030910.KAA19595@sunsite.ms.mff.cuni.cz" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] A new version of the sys_swapon bugfix</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] A new version of the sys_swapon bugfix</h1>
<b>Jakub Jelinek</b> (<a href="mailto:jj@sunsite.ms.mff.cuni.cz"><i>jj@sunsite.ms.mff.cuni.cz</i></a>)<br>
<i>Tue, 3 Nov 1998 10:10:08 +0100 (MET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#213">[ date ]</a><a href="index.html#213">[ thread ]</a><a href="subject.html#213">[ subject ]</a><a href="author.html#213">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0214.html">Yves Rougy: "2.1.126 Kernel Panic"</a>
<li> <b>Previous message:</b> <a href="0212.html">Steffen Grunewald: "Re: PCI modem !?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0223.html">Andreas Schwab: "Re: [PATCH] A new version of the sys_swapon bugfix"</a>
<li> <b>Reply:</b> <a href="0223.html">Andreas Schwab: "Re: [PATCH] A new version of the sys_swapon bugfix"</a>
<li> <b>Reply:</b> <a href="0315.html">Stephen Williams: "Re: [PATCH] A new version of the sys_swapon bugfix"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
This is a new enhanced version of the sys_swapon bugfix.<br>
I've checked C standard and I cannot find any word about pointer + integer<br>
being promoted first to pointer + long, so I'm pretty sure it is not a<br>
compiler bug to:<br>
<p>
static int i = 0, *p;<br>
if (&amp;p[i - 1] &gt;= p) printf("C does not promote in pointer arithmetic\n");<br>
<p>
on 64bit archs.<br>
The following patch solves that problem (swapon not allowing new format<br>
swaps with no bad pages) by simply subtracting -1L, which should work just<br>
fine. In addition to that, it makes the 2GB limit be checked on 32bit archs<br>
only, plus it adds a new check which actually tests SWP_* macros on what's<br>
the largest possible SWP_OFFSET in page tables (and the swap size in pages<br>
cannot obviously go beyond that). Without this, a couple of architectures<br>
are broken in the other direction in that they allow swaps larger than they<br>
can hold in page tables, particularly on mips and sparc32.<br>
<p>
With this patch, one should be able to use<br>
up to 12TB swaps on sparc64 (it could be 64PB, but the real limit is only 12TB, as<br>
			     swapfile.c does a vmalloc of size nr_swap_pages * 2<br>
			     and sparc64 limits VMALLOC area to 3GB at the moment)<br>
up to 128GB swaps on alpha<br>
up to 2GB swaps on arm<br>
up to 2GB swaps on i386<br>
up to 2GB swaps on m68k<br>
up to 2GB swaps on ppc<br>
up to 1GB swaps on sparc (resp. up to 2GB swaps if CONFIG_SUN4)<br>
up to 512MB swaps on mips<br>
<p>
Linus, can you please apply this to your tree?<br>
<p>
--- linux/mm/swapfile.c.jj	Wed Sep 23 15:13:34 1998<br>
+++ linux/mm/swapfile.c	Tue Nov  3 09:36:59 1998<br>
@@ -626,8 +626,12 @@<br>
 		p-&gt;highest_bit = swap_header-&gt;info.last_page - 1;<br>
 		p-&gt;max	       = swap_header-&gt;info.last_page;<br>
 <br>
-		if (p-&gt;max &gt;= 0x7fffffffL/PAGE_SIZE ||<br>
-		    (void *) &amp;swap_header-&gt;info.badpages[swap_header-&gt;info.nr_badpages-1] &gt;= (void *) swap_header-&gt;magic.magic) {<br>
+		/* Make sure the number of swap pages fits into SWP_OFFSET field<br>
+		   in page tables. This depends on the arch macros and thus poses<br>
+		   yet another constraint on swap size. */<br>
+		if ((BITS_PER_LONG == 32 &amp;&amp; p-&gt;max &gt;= 0x7fffffffL/PAGE_SIZE) ||<br>
+		    (p-&gt;max &gt; SWP_OFFSET(SWP_ENTRY(0,((unsigned long)-1)))) ||<br>
+		    (void *) &amp;swap_header-&gt;info.badpages[swap_header-&gt;info.nr_badpages-1L] &gt;= (void *) swap_header-&gt;magic.magic) {<br>
 			error = -EINVAL;<br>
 			goto bad_swap;<br>
 		}<br>
<p>
<p>
Cheers,<br>
    Jakub<br>
___________________________________________________________________<br>
Jakub Jelinek | <a href="mailto:jj@sunsite.mff.cuni.cz">jj@sunsite.mff.cuni.cz</a> | <a href="http://sunsite.mff.cuni.cz">http://sunsite.mff.cuni.cz</a><br>
Administrator of SunSITE Czech Republic, MFF, Charles University<br>
___________________________________________________________________<br>
Ultralinux - first 64bit OS to take full power of the UltraSparc<br>
Linux version 2.1.126 on a sparc64 machine (498.80 BogoMips).<br>
___________________________________________________________________<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0214.html">Yves Rougy: "2.1.126 Kernel Panic"</a>
<li> <b>Previous message:</b> <a href="0212.html">Steffen Grunewald: "Re: PCI modem !?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0223.html">Andreas Schwab: "Re: [PATCH] A new version of the sys_swapon bugfix"</a>
<li> <b>Reply:</b> <a href="0223.html">Andreas Schwab: "Re: [PATCH] A new version of the sys_swapon bugfix"</a>
<li> <b>Reply:</b> <a href="0315.html">Stephen Williams: "Re: [PATCH] A new version of the sys_swapon bugfix"</a>
<!-- reply="end" -->
</ul>
</font></body>
