<!-- received="Tue Nov  3 08:34:43 1998 EET" -->
<!-- sent="Mon, 2 Nov 1998 23:38:25 +0100" -->
<!-- name="Florian Lohoff" -->
<!-- email="flo@quit.mediaways.net" -->
<!-- subject="[PATCH] 2.0.35/36pre16 UMSDOS/initrd" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] 2.0.35/36pre16 UMSDOS/initrd</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.0.35/36pre16 UMSDOS/initrd</h1>
<b>Florian Lohoff</b> (<a href="mailto:flo@quit.mediaways.net"><i>flo@quit.mediaways.net</i></a>)<br>
<i>Mon, 2 Nov 1998 23:38:25 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#184">[ date ]</a><a href="index.html#184">[ thread ]</a><a href="subject.html#184">[ subject ]</a><a href="author.html#184">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0185.html">Michael H. Warfield: "Re: [2.1.127-pre3] gcc crashes in schec.c!"</a>
<li> <b>Previous message:</b> <a href="0183.html">Henning P. Schmiedehausen: "Re: NFS problem with NetworkAppliance .snapshot"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--W/nzBZO5zC0uMSeA<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
<p>
Hi,<br>
after i (re)discovered the old umsdos initrd bug and finding it very anoying.<br>
I did some hacking (first time in kernel space) and i think i have<br>
a patch for this problem which solves the problems with the unoff patch<br>
not able to build umsdos as a module anymore ... It might by VERY dirty<br>
but someone else with more knowledge of the kernel might take a look.<br>
Id like to see this in 2.0.36 (Hi Alan :) )<br>
<p>
Patch -&gt; Attachment <br>
<p>
Flo<br>
<pre>
-- 
<a href="mailto:Florian.Lohoff@mediaWays.net">Florian.Lohoff@mediaWays.net</a>			+49-5241-80-7085
Good, Fast, Cheap: Pick any two (you can't have all three). (RFC 1925)
<p>
--W/nzBZO5zC0uMSeA
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="umsdos-initrd.patch"
<p>
diff -u -r -P linux-2.0.36pre16/fs/super.c linux-2.0.36pre16-umsdos/fs/super.c
--- linux-2.0.36pre16/fs/super.c	Mon Nov  2 23:08:54 1998
+++ linux-2.0.36pre16-umsdos/fs/super.c	Mon Nov  2 23:16:37 1998
@@ -1025,6 +1025,13 @@
 			sb-&gt;s_flags = root_mountflags;
 			current-&gt;fs-&gt;pwd = inode;
 			current-&gt;fs-&gt;root = inode;
+#ifdef CONFIG_UMSDOS_FS
+			if ((strcmp(fs_type-&gt;name,"umsdos") == 0) &amp;&amp; sb-&gt;s_mounted-&gt;i_mount) {
+				current-&gt;fs-&gt;pwd = sb-&gt;s_mounted-&gt;i_mount;
+				current-&gt;fs-&gt;root = sb-&gt;s_mounted-&gt;i_mount;
+				sb-&gt;s_mounted-&gt;i_mount=NULL;
+			}
+#endif
 			printk ("VFS: Mounted root (%s filesystem)%s.\n",
 				fs_type-&gt;name,
 				(sb-&gt;s_flags &amp; MS_RDONLY) ? " readonly" : "");
diff -u -r -P linux-2.0.36pre16/fs/umsdos/inode.c linux-2.0.36pre16-umsdos/fs/umsdos/inode.c
--- linux-2.0.36pre16/fs/umsdos/inode.c	Mon Jul 13 22:47:38 1998
+++ linux-2.0.36pre16-umsdos/fs/umsdos/inode.c	Mon Nov  2 23:15:39 1998
@@ -409,7 +409,7 @@
 		PRINTK (("umsdos_read_super %p\n",sb-&gt;s_mounted));
 		umsdos_setup_dir_inode (sb-&gt;s_mounted);
 		PRINTK (("End umsdos_read_super\n"));
-		if (s == super_blocks){
+		if (s-&gt;s_dev == ROOT_DEV){
 			/* #Specification: pseudo root / mount
 				When a umsdos fs is mounted, a special handling is done
 				if it is the root partition. We check for the presence
@@ -479,6 +479,7 @@
 					umsdos_setup_dir_inode (pseudo);
 					Printk (("Activating pseudo root /%s\n",UMSDOS_PSDROOT_NAME));
 					pseudo_root = pseudo;
+					sb-&gt;s_mounted-&gt;i_mount=pseudo;
 					pseudo-&gt;i_count++;
 					pseudo = NULL;
 				}
diff -u -r -P linux-2.0.36pre16/init/main.c linux-2.0.36pre16-umsdos/init/main.c
--- linux-2.0.36pre16/init/main.c	Mon Nov  2 23:08:56 1998
+++ linux-2.0.36pre16-umsdos/init/main.c	Mon Nov  2 19:52:49 1998
@@ -1059,21 +1059,6 @@
 	smp_begin();
 #endif	
 
-	#ifdef CONFIG_UMSDOS_FS
-	{
-		/*
-			When mounting a umsdos fs as root, we detect
-			the pseudo_root (/linux) and initialise it here.
-			pseudo_root is defined in fs/umsdos/inode.c
-		*/
-		extern struct inode *pseudo_root;
-		if (pseudo_root != NULL){
-			current-&gt;fs-&gt;root = pseudo_root;
-			current-&gt;fs-&gt;pwd  = pseudo_root;
-		}
-	}
-	#endif
-
 #ifdef CONFIG_BLK_DEV_INITRD
 	root_mountflags = real_root_mountflags;
 	if (mount_initrd &amp;&amp; ROOT_DEV != real_root_dev &amp;&amp; ROOT_DEV == MKDEV(RAMDISK_MAJOR,0)) {
<p>
--W/nzBZO5zC0uMSeA--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0185.html">Michael H. Warfield: "Re: [2.1.127-pre3] gcc crashes in schec.c!"</a>
<li> <b>Previous message:</b> <a href="0183.html">Henning P. Schmiedehausen: "Re: NFS problem with NetworkAppliance .snapshot"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
