<!-- received="Mon Nov  2 17:08:50 1998 EET" -->
<!-- sent="Mon, 2 Nov 1998 14:54:24 -0000 " -->
<!-- name="Matthias.Fengler@dresdner-bank.com" -->
<!-- email="Matthias.Fengler@dresdner-bank.com" -->
<!-- subject="Two small fixes for the serial driver" -->
<!-- id="199811021442.OAA09996@harpo.dresdnerkb.com" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: Two small fixes for the serial driver</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Two small fixes for the serial driver</h1>
<a href="mailto:Matthias.Fengler@dresdner-bank.com"><i>Matthias.Fengler@dresdner-bank.com</i></a><br>
<i>Mon, 2 Nov 1998 14:54:24 -0000 </i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#137">[ date ]</a><a href="index.html#137">[ thread ]</a><a href="subject.html#137">[ subject ]</a><a href="author.html#137">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0138.html">Stephen.Rothwell@canb.auug.org.au: "Re: New APM BIOS patch"</a>
<li> <b>Previous message:</b> <a href="0136.html">Andrej Presern: "Re: Random Register Contents"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hello,<br>
<p>
while trying to use the serial port with some non-standard baud rates I had<br>
the following problems:<br>
<p>
A non-privileged user should be able to set or reset the ASYNC_SPD_* flags<br>
on a serial port, but he actually isn't.  setserial (or TIOC[SG]SERIAL) will<br>
allow him to change these settings and will also return those changed values<br>
afterwards even though the kernel won't use these values for the port.<br>
Setting the custom divisor works fine, so once root has set the<br>
ASYNC_SPD_CUST flag a normal user can specify the divisor, but is unable to<br>
reset the port to plain 38400 baud by resetting ASYNC_SPD_CUST.<br>
<p>
For some reason these flags are held in two different places within the<br>
async_struct (flags and state-&gt;flags) and happen to diverge for a non-root<br>
user.<br>
<p>
Here's a small patch against 2.1.125 that fixes the problem:<br>
<p>
--- serial.c.orig	Tue Sep  1 19:32:13 1998<br>
+++ serial.c	Thu Oct 22 11:21:54 1998<br>
@@ -32,6 +32,10 @@<br>
  *  4/98: Added changes to support the ARM architecture proposed by<br>
  * 	  Russell King<br>
  *<br>
+ * 10/98: Fixed bug in set_serial_info to allow non-privileged user<br>
+ *        to set/reset ASYNC_SPD_* flags<br>
+ *        Matthias Fengler &lt;<a href="mailto:mfengler@iname.com">mfengler@iname.com</a>&gt;<br>
+ *<br>
  * This module exports the following rs232 io functions:<br>
  *<br>
  *	int rs_init(void);<br>
@@ -1653,6 +1657,8 @@<br>
 			return -EPERM;<br>
 		state-&gt;flags = ((state-&gt;flags &amp; ~ASYNC_USR_MASK) |<br>
 			       (new_serial.flags &amp; ASYNC_USR_MASK));<br>
+		info-&gt;flags = ((info-&gt;flags &amp; ~ASYNC_USR_MASK) |<br>
+			       (new_serial.flags &amp; ASYNC_USR_MASK));<br>
 		state-&gt;custom_divisor = new_serial.custom_divisor;<br>
 		goto check_and_exit;<br>
 	}<br>
<p>
<p>
And here is another small patch that allows root to set/reset ASYNC_SPD_VHI<br>
and ASYNC_SPD_WARP. In this particular case a non-privileged user CAN<br>
set/reset these flags, but root can't.<br>
There is obviously one bit missing in the ASYNC_FLAGS mask that controls<br>
those higher baud rates (230 kbps, 460 kbps).  This bit is present in the<br>
ASYNC_USR_MASK.<br>
<p>
--- serial.h.orig	Sat Apr 18 07:04:44 1998<br>
+++ serial.h	Thu Oct 22 11:30:33 1998<br>
@@ -87,7 +87,7 @@<br>
 <br>
 #define ASYNC_LOW_LATENCY 0x2000 /* Request low latency behaviour */<br>
 <br>
-#define ASYNC_FLAGS	0x2FFF	/* Possible legal async flags */<br>
+#define ASYNC_FLAGS	0x3FFF	/* Possible legal async flags */<br>
 #define ASYNC_USR_MASK	0x3430	/* Legal flags that non-privileged<br>
 				 * users can set or reset */<br>
 <br>
<p>
Regards,<br>
<p>
Matthias<br>
<p>
<p>
Matthias Fengler<br>
Dresdner Kleinwort Benson<br>
Global Markets Division<br>
Market Risk Management<br>
Jrgen-Ponto-Platz 1<br>
D-60301 Frankfurt am Main<br>
Germany<br>
<p>
<p>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0138.html">Stephen.Rothwell@canb.auug.org.au: "Re: New APM BIOS patch"</a>
<li> <b>Previous message:</b> <a href="0136.html">Andrej Presern: "Re: Random Register Contents"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
