<!-- received="Mon Nov  2 15:14:04 1998 EET" -->
<!-- sent="Mon, 2 Nov 1998 20:04:01 +0700" -->
<!-- name="Vladimir V. Ivanov" -->
<!-- email="vlad@elis.tusur.ru" -->
<!-- subject="[PATCH] shaper.c bug in 2.1.x kernels" -->
<!-- id="199811021304.UAA28538@elis.tusur.ru" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] shaper.c bug in 2.1.x kernels</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] shaper.c bug in 2.1.x kernels</h1>
<b>Vladimir V. Ivanov</b> (<a href="mailto:vlad@elis.tusur.ru"><i>vlad@elis.tusur.ru</i></a>)<br>
<i>Mon, 2 Nov 1998 20:04:01 +0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#127">[ date ]</a><a href="index.html#127">[ thread ]</a><a href="subject.html#127">[ subject ]</a><a href="author.html#127">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0128.html">Florian Lohoff: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0126.html">Alan Cox: "Linux 2.0.36pre16"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hello,<br>
<p>
I have found a little bug in shaper.c caused the kernel Oops (at least then<br>
length of device name less then 16 bytes) then user's SHAPER_GET_DEV ioctl<br>
call occurs.<br>
<p>
The following is my patch solving a problem against 2.1.125 kernel source<br>
tree.<br>
<p>
--- CUT HERE ---<br>
--- linux.old/drivers/net/shaper.c	Fri Aug 21 01:33:10 1998<br>
+++ linux/drivers/net/shaper.c	Wed Oct 28 03:30:08 1998<br>
@@ -564,7 +564,7 @@<br>
 		case SHAPER_GET_DEV:<br>
 			if(sh-&gt;dev==NULL)<br>
 				return -ENODEV;<br>
-			memcpy(ss-&gt;ss_name, sh-&gt;dev-&gt;name, sizeof(ss-&gt;ss_name));<br>
+			memcpy(ss-&gt;ss_name, sh-&gt;dev-&gt;name, strlen(sh-&gt;dev-&gt;name)+1);<br>
 			return 0;<br>
 		case SHAPER_SET_SPEED:<br>
 			shaper_setspeed(sh,ss-&gt;ss_speed);<br>
 <br>
--- CUT HERE ---<br>
<p>
I have also slightly rewrote a shapecfg program and have added to them<br>
SHAPER_GET_DEV and SHAPER_GET_SPEED ioctl calls. (Anybody have wrote it<br>
already ?)<br>
<p>
Examples :<br>
<p>
elis# shapecfg 0 attach eth3		/* attach shaper */<br>
elis# shapecfg 0 speed 128000		/* speed setting */<br>
elis# shapecfg 0			/* getting properties */<br>
shaper0 on &lt;eth3&gt; speed 128000<br>
elis#<br>
<p>
Shaper device index have limited by number 999.<br>
<p>
--- CUT HERE ---<br>
#include &lt;stdio.h&gt;<br>
#include &lt;string.h&gt;<br>
#include &lt;stdlib.h&gt;<br>
#include &lt;linux/types.h&gt;<br>
#include &lt;net/if.h&gt;<br>
#include &lt;linux/if_shaper.h&gt;<br>
#include &lt;linux/sockios.h&gt;<br>
<p>
static unsigned char devname[] = "shaper\0\0\0";<br>
<p>
void usage(char *name)<br>
{	<br>
	fprintf(stderr,"Usage: %s &lt;index&gt; attach &lt;device&gt;\n"<br>
		       "       %s &lt;index&gt; speed &lt;speed&gt;\n"<br>
	               "       %s &lt;index&gt;\n", name, name, name);<br>
	exit(1);<br>
}<br>
<p>
void main(int argc, char *argv[])<br>
{<br>
	unsigned char *progname;<br>
	<br>
	int s = socket(AF_INET, SOCK_DGRAM,0);<br>
	if (s == -1)<br>
	{<br>
		perror("socket");<br>
		exit(1);<br>
	}<br>
	<br>
	progname = strrchr(argv[0], '/');<br>
	if (progname == NULL)<br>
		progname = argv[0];<br>
	else<br>
		progname++;<br>
	<br>
	if (argc &lt; 2)<br>
		usage(progname);<br>
	<br>
	devname[6] = argv[1][0];<br>
	if (argv[1][1]) {<br>
		devname[7] = argv[1][1];<br>
		if (argv[1][2]) devname[8] = argv[1][2];<br>
	}<br>
<p>
	if (argc == 2)<br>
	{<br>
		struct ifreq ifr;<br>
		struct shaperconf *shc = (struct shaperconf *)&amp;ifr.ifr_data;<br>
		unsigned speed;<br>
<p>
		strcpy(ifr.ifr_name,devname);		<br>
		shc-&gt;ss_cmd = SHAPER_GET_SPEED;<br>
		if (ioctl(s,SIOCDEVPRIVATE,&amp;ifr) == -1)<br>
		{<br>
			perror("SHAPER_GET_SPEED");<br>
			exit(1);<br>
		}<br>
		speed = shc-&gt;ss_speed;<br>
<p>
		strcpy(ifr.ifr_name,devname);		<br>
		shc-&gt;ss_cmd = SHAPER_GET_DEV;<br>
		if (ioctl(s,SIOCDEVPRIVATE,&amp;ifr) == -1)<br>
		{<br>
			perror("SHAPER_GET_DEV");<br>
			exit(1);<br>
		}<br>
<p>
		printf("%s on &lt;%s&gt; speed %d\n", devname, shc-&gt;ss_name, speed);<br>
		exit(0);<br>
	} <br>
<p>
	if (argc != 4)<br>
		usage(progname);<br>
		<br>
	if (strcmp(argv[2],"attach") == 0)<br>
	{<br>
		struct ifreq ifr;<br>
		struct shaperconf *shc = (struct shaperconf *)&amp;ifr.ifr_data;<br>
<p>
		strcpy(ifr.ifr_name,devname);<br>
		strcpy(shc-&gt;ss_name,argv[3]);<br>
		shc-&gt;ss_cmd = SHAPER_SET_DEV;<br>
		if (ioctl(s,SIOCDEVPRIVATE,&amp;ifr) == -1)<br>
		{<br>
			perror("SHAPER_SET_DEV");<br>
			exit(1);<br>
		}<br>
		exit(0);<br>
	}<br>
	if (strcmp(argv[2],"speed") == 0)<br>
	{<br>
		int v;<br>
		struct ifreq ifr;<br>
		struct shaperconf *shc = (struct shaperconf *)&amp;ifr.ifr_data;<br>
<p>
		strcpy(ifr.ifr_name,devname);<br>
		sscanf(argv[3],"%d",&amp;v);<br>
		shc-&gt;ss_speed = v;<br>
		shc-&gt;ss_cmd = SHAPER_SET_SPEED;<br>
		if (ioctl(s,SIOCDEVPRIVATE,&amp;ifr) == -1)<br>
		{<br>
			perror("SHAPER_SET_SPEED");<br>
			exit(1);<br>
		}<br>
		exit(0);<br>
	}<br>
	usage(progname);<br>
}<br>
--- CUT HERE ---<br>
<p>
I hope somebody will find my work useful.<br>
<p>
<pre>
---
Best regards,   Vladimir Ivanov
E-mail:         <a href="mailto:vlad@elis.tusur.ru">mailto:vlad@elis.tusur.ru</a>
World Wide Web: <a href="http://elis.tusur.ru/~vlad">http://elis.tusur.ru/~vlad</a>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0128.html">Florian Lohoff: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0126.html">Alan Cox: "Linux 2.0.36pre16"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
