<!-- received="Mon Nov  2 09:00:40 1998 EET" -->
<!-- sent="Mon, 2 Nov 1998 00:45:49 +0100 (CET)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@e-mind.com" -->
<!-- subject="Re: arca-1-against-pre-2.1.127-3" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.95.981102000603.7790A-100000@localhost" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: arca-1-against-pre-2.1.127-3</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: arca-1-against-pre-2.1.127-3</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@e-mind.com"><i>andrea@e-mind.com</i></a>)<br>
<i>Mon, 2 Nov 1998 00:45:49 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#94">[ date ]</a><a href="index.html#94">[ thread ]</a><a href="subject.html#94">[ subject ]</a><a href="author.html#94">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0095.html">Andrea Arcangeli: "Re: arca-1-against-pre-2.1.127-3"</a>
<li> <b>Previous message:</b> <a href="0093.html">flewid: "Re: ppp and 2.1.126/2.1.125"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, 2 Nov 1998, Gerard Roudier wrote:<br>
<p>
<i>&gt;Here is the bug report:</i><br>
<p>
I just put out a new arca-6 with a more high level (and fixed) approch to<br>
check if the timer is pending.<br>
<p>
Here the interesting part of the new patch. Tell me if you don' t like it:<br>
<p>
Index: linux/drivers/scsi/aic7xxx.c<br>
diff -u linux/drivers/scsi/aic7xxx.c:1.1.1.3 linux/drivers/scsi/aic7xxx.c:1.1.1.2.4.4<br>
--- linux/drivers/scsi/aic7xxx.c:1.1.1.3	Sat Oct 24 15:40:46 1998<br>
+++ linux/drivers/scsi/aic7xxx.c	Mon Nov  2 00:40:27 1998<br>
@@ -3429,7 +3429,7 @@<br>
    * here so that we can delay all re-sent commands for this device for the<br>
    * 4 seconds and then have our timer routine pick them back up.<br>
    */<br>
-        if(p-&gt;dev_timer[i].expires)<br>
+        if( timer_pending(&amp;p-&gt;dev_timer[i]) )<br>
         {<br>
           del_timer(&amp;p-&gt;dev_timer[i]);<br>
         }<br>
@@ -3482,11 +3482,8 @@<br>
         scbq_init(&amp;p-&gt;delayed_scbs[i]);<br>
       }<br>
       if ( (p-&gt;delayed_scbs[i].head == NULL) &amp;&amp;<br>
-           (p-&gt;dev_timer[i].expires) )<br>
-      {<br>
+           timer_pending(&amp;p-&gt;dev_timer[i]) )<br>
         del_timer(&amp;p-&gt;dev_timer[i]);<br>
-        p-&gt;dev_timer[i].expires = 0;<br>
-      }<br>
     }<br>
   }<br>
 <br>
@@ -4007,7 +4004,7 @@<br>
     }<br>
     if ( (p-&gt;dev_active_cmds[tindex] &gt;=<br>
           p-&gt;dev_temp_queue_depth[tindex]) ||<br>
-         (p-&gt;dev_last_reset[tindex] &gt;= (jiffies - (4 * HZ))) )<br>
+         time_after_eq(p-&gt;dev_last_reset[tindex], jiffies - 4 * HZ) )<br>
     {<br>
 #ifdef AIC7XXX_VERBOSE_DEBUGGING<br>
       if (aic7xxx_verbose &gt; 0xffff)<br>
@@ -4015,7 +4012,7 @@<br>
                p-&gt;host_no, CTL_OF_SCB(scb));<br>
 #endif<br>
       scbq_insert_tail(&amp;p-&gt;delayed_scbs[tindex], scb);<br>
-      if ( !(p-&gt;dev_timer[tindex].expires) &amp;&amp;<br>
+      if ( !timer_pending(&amp;p-&gt;dev_timer[tindex]) &amp;&amp;<br>
            !(p-&gt;dev_active_cmds[tindex]) )<br>
       {<br>
         p-&gt;dev_timer[tindex].expires = p-&gt;dev_last_reset[tindex] + (4 * HZ);<br>
@@ -4154,15 +4151,10 @@<br>
 #endif<br>
   for(i=0; i&lt;MAX_TARGETS; i++)<br>
   {<br>
-    if ( (p-&gt;dev_timer[i].expires) &amp;&amp; <br>
-          (p-&gt;dev_timer[i].expires &lt;= jiffies) )<br>
+    if ( timer_pending(&amp;p-&gt;dev_timer[i]) &amp;&amp; <br>
+         time_before_eq(p-&gt;dev_timer[i].expires, jiffies) )<br>
     {<br>
-      p-&gt;dev_timer[i].expires = 0;<br>
-      if ( (p-&gt;dev_timer[i].prev != NULL) ||<br>
-           (p-&gt;dev_timer[i].next != NULL) )<br>
-      {<br>
-        del_timer(&amp;p-&gt;dev_timer[i]);<br>
-      }<br>
+      del_timer(&amp;p-&gt;dev_timer[i]);<br>
       p-&gt;dev_temp_queue_depth[i] =  p-&gt;dev_max_queue_depth[i];<br>
       j = 0;<br>
       while ( ((scb = scbq_remove_head(&amp;p-&gt;delayed_scbs[i])) != NULL) &amp;&amp;<br>
@@ -4895,7 +4887,7 @@<br>
               p-&gt;activescbs--;<br>
               scb-&gt;flags |= SCB_WAITINGQ | SCB_WAS_BUSY;<br>
                   <br>
-              if (p-&gt;dev_timer[tindex].expires == 0) <br>
+              if ( !timer_pending(&amp;p-&gt;dev_timer[tindex]) ) <br>
               {<br>
                 if ( p-&gt;dev_active_cmds[tindex] )<br>
                 {<br>
@@ -7462,7 +7454,7 @@<br>
   }<br>
 <br>
   p-&gt;host = host;<br>
-  p-&gt;last_reset = 0;<br>
+  p-&gt;last_reset = jiffies;<br>
   p-&gt;host_no = host-&gt;host_no;<br>
   host-&gt;unique_id = p-&gt;instance;<br>
   p-&gt;isr_count = 0;<br>
@@ -7489,7 +7481,7 @@<br>
     p-&gt;dev_commands_sent[i] = 0;<br>
     p-&gt;dev_flags[i] = 0;<br>
     p-&gt;dev_active_cmds[i] = 0;<br>
-    p-&gt;dev_last_reset[i] = 0;<br>
+    p-&gt;dev_last_reset[i] = jiffies;<br>
     p-&gt;dev_last_queue_full[i] = 0;<br>
     p-&gt;dev_last_queue_full_count[i] = 0;<br>
     p-&gt;dev_max_queue_depth[i] = 1;<br>
@@ -7497,7 +7489,6 @@<br>
     p-&gt;dev_mid_level_queue_depth[i] = 3;<br>
     scbq_init(&amp;p-&gt;delayed_scbs[i]);<br>
     init_timer(&amp;p-&gt;dev_timer[i]);<br>
-    p-&gt;dev_timer[i].expires = 0;<br>
     p-&gt;dev_timer[i].data = (unsigned long)p;<br>
     p-&gt;dev_timer[i].function = (void *)aic7xxx_timer;<br>
   }<br>
Index: linux/drivers/scsi/scsi_obsolete.c<br>
diff -u linux/drivers/scsi/scsi_obsolete.c:1.1.1.3 linux/drivers/scsi/scsi_obsolete.c:1.1.1.2.4.5<br>
--- linux/drivers/scsi/scsi_obsolete.c:1.1.1.3	Sat Oct 24 15:40:59 1998<br>
+++ linux/drivers/scsi/scsi_obsolete.c	Mon Nov  2 00:41:06 1998<br>
@@ -607,8 +607,10 @@<br>
 	if ((++SCpnt-&gt;retries) &lt; SCpnt-&gt;allowed)<br>
 	{<br>
 	    if ((SCpnt-&gt;retries &gt;= (SCpnt-&gt;allowed &gt;&gt; 1))<br>
-		&amp;&amp; !(SCpnt-&gt;host-&gt;last_reset &gt; 0 &amp;&amp;<br>
-		     jiffies &lt; SCpnt-&gt;host-&gt;last_reset + MIN_RESET_PERIOD)<br>
+		/* FIXME: last_reset == 0 is allowed<br>
+                 *  &amp;&amp; !(SCpnt-&gt;host-&gt;last_reset &gt; 0 */ &amp;&amp;<br>
+		     time_before(jiffies, SCpnt-&gt;host-&gt;last_reset<br>
+                                 + MIN_RESET_PERIOD)<br>
 		&amp;&amp; !(SCpnt-&gt;flags &amp; WAS_RESET))<br>
 	    {<br>
 		printk("scsi%d channel %d : resetting for second half of retries.\n",<br>
@@ -954,8 +956,8 @@<br>
 		host-&gt;last_reset = jiffies;<br>
 	        SCpnt-&gt;flags |= (WAS_RESET | IS_RESETTING);<br>
 		temp = host-&gt;hostt-&gt;reset(SCpnt, reset_flags);<br>
-		if ((host-&gt;last_reset &lt; jiffies) ||<br>
-		    (host-&gt;last_reset &gt; (jiffies + 20 * HZ)))<br>
+		if (time_before(host-&gt;last_reset, jiffies) ||<br>
+		    (time_after(host-&gt;last_reset, jiffies + 20 * HZ)))<br>
 		  host-&gt;last_reset = jiffies;<br>
 		if (!host-&gt;block) host-&gt;host_busy--;<br>
 	    }<br>
@@ -1070,7 +1072,7 @@<br>
    * timers for timeout.<br>
    */<br>
 <br>
-  if( SCset-&gt;eh_timeout.expires == 0 )<br>
+  if( !timer_pending(&amp;SCset-&gt;eh_timeout) )<br>
     {<br>
       rtn = 0;<br>
     }<br>
Index: linux/include/linux/timer.h<br>
diff -u linux/include/linux/timer.h:1.1.1.1 linux/include/linux/timer.h:1.1.1.1.14.2<br>
--- linux/include/linux/timer.h:1.1.1.1	Fri Oct  2 19:22:40 1998<br>
+++ linux/include/linux/timer.h	Mon Nov  2 00:41:21 1998<br>
@@ -84,9 +84,24 @@<br>
 	return((long)((a) - (b)) &lt; 0L);<br>
 }<br>
 <br>
+extern inline int time_before_eq(unsigned long a, unsigned long b)<br>
+{<br>
+	return((long)((a) - (b)) &lt;= 0L);<br>
+}<br>
+<br>
 extern inline int time_after(unsigned long a, unsigned long b)<br>
 {<br>
 	return((long)((a) - (b)) &gt; 0L);<br>
+}<br>
+<br>
+extern inline int time_after_eq(unsigned long a, unsigned long b)<br>
+{<br>
+	return((long)((a) - (b)) &gt;= 0L);<br>
+}<br>
+<br>
+extern inline int timer_pending(struct timer_list * timer)<br>
+{<br>
+	return timer-&gt;prev || timer-&gt;next;<br>
 }<br>
 <br>
 #endif<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0095.html">Andrea Arcangeli: "Re: arca-1-against-pre-2.1.127-3"</a>
<li> <b>Previous message:</b> <a href="0093.html">flewid: "Re: ppp and 2.1.126/2.1.125"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
