<!-- received="Sun Nov  1 21:45:15 1998 EET" -->
<!-- sent="Sun, 01 Nov 1998 14:40:32 -0500" -->
<!-- name="Tomasz Przygoda" -->
<!-- email="tprzyg@securities.com" -->
<!-- subject="[PATCH] Drives above 64GB" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] Drives above 64GB</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Drives above 64GB</h1>
<b>Tomasz Przygoda</b> (<a href="mailto:tprzyg@securities.com"><i>tprzyg@securities.com</i></a>)<br>
<i>Sun, 01 Nov 1998 14:40:32 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#57">[ date ]</a><a href="index.html#57">[ thread ]</a><a href="subject.html#57">[ subject ]</a><a href="author.html#57">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0058.html">Mike Galbraith: "Re: arca-1-against-pre-2.1.127-3"</a>
<li> <b>Previous message:</b> <a href="0056.html">Rafael Reilova: "Weird freeze up with sound and X11 (2.1.x)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
I assume it's going to be more and more often that people have drives<br>
bigger than 64GB, unfortunately there's one (at least one, that I spot):<br>
scsicam_bios_param - the parameters calculated there (number of sectors,<br>
heads and cylinders) are only integer, whereas these days the number of<br>
cylinders may go above 65535. I don't know if this is the best way to<br>
fix the "problem", but:<br>
1. It fixes the problem I had (tested).<br>
2. Doesn't change the type of the structure (actually array) that holds<br>
the the values.<br>
<p>
I hope either this, or something similar can make it into the kernel<br>
(both 2.0.x and 2.1.x are affected).<br>
<p>
The patch below should work for up to 502GB.<br>
<p>
--- linux/drivers/scsi/scsicam.c.orig   Mon Jun 29 15:33:48 1998<br>
+++ linux/drivers/scsi/scsicam.c        Mon Jun 29 15:32:58 1998<br>
@@ -45,6 +45,7 @@<br>
     struct buffer_head *bh;<br>
     int ret_code;<br>
     int size = disk-&gt;capacity;<br>
+    unsigned long temp_cyl;<br>
<p>
     if (!(bh = bread(MKDEV(MAJOR(dev), MINOR(dev)&amp;~0xf), 0, 1024)))<br>
        return -1;<br>
@@ -67,6 +68,11 @@<br>
     if (ret_code || ip[0] &gt; 255 || ip[1] &gt; 63) {<br>
         ip[0] = 64;<br>
         ip[1] = 32;<br>
+        temp_cyl = size / (ip[0] * ip[1]);<br>
+        if (temp_cyl &gt; 65535) {<br>
+             ip[0] = 255;<br>
+             ip[1] = 63;<br>
+        }<br>
         ip[2] = size / (ip[0] * ip[1]);<br>
     }<br>
<p>
Thanks!<br>
<p>
-- Tomek,<br>
"In theory there's no difference between theory and practice, but in practice...."<br>
<p>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0058.html">Mike Galbraith: "Re: arca-1-against-pre-2.1.127-3"</a>
<li> <b>Previous message:</b> <a href="0056.html">Rafael Reilova: "Weird freeze up with sound and X11 (2.1.x)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
