<!-- received="Sun Nov  1 09:40:39 1998 EET" -->
<!-- sent="Sun, 1 Nov 1998 02:58:38 +0100 (CET)" -->
<!-- name="Ragnar Hojland Espinosa" -->
<!-- email="ragnar@redestb.es" -->
<!-- subject="[PATCH] krflushd" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] krflushd</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] krflushd</h1>
<b>Ragnar Hojland Espinosa</b> (<a href="mailto:ragnar@redestb.es"><i>ragnar@redestb.es</i></a>)<br>
<i>Sun, 1 Nov 1998 02:58:38 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#21">[ date ]</a><a href="index.html#21">[ thread ]</a><a href="subject.html#21">[ subject ]</a><a href="author.html#21">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0022.html">Mike Galbraith: "Re: arca-1-against-pre-2.1.127-3"</a>
<li> <b>Previous message:</b> <a href="0020.html">Feuer: "Re: Signal problems"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Applying the patch makes it possible to get rid of bdflush/update [0]<br>
The process is renamed to krflushd so in your init script, after mounting<br>
/proc, you can write something:<br>
<p>
if [ `pidof krflushd` ]<br>
then<br>
	kill -KILL `pidof "update (bdflush)"`<br>
fi<br>
<p>
[0] (unless, of course, you use it for things like spinning down)<br>
<pre>
-- 
____/|  Ragnar Hojland  (<a href="mailto:ragnar@lightside.ddns.org">ragnar@lightside.ddns.org</a>)      Fingerprint  94C4B
\ o.O|                                                   2F0D27DE025BE2302C
 =(_)=  "Thou shalt not follow the NULL pointer for      104B78C56 B72F0822
   U     chaos and madness await thee at its end."       hkp://keys.pgp.com
<p>
<p>
--- linux-2.1.126/fs/buffer.c.O	Wed Oct 28 18:46:21 1998
+++ linux-2.1.126/fs/buffer.c	Wed Oct 28 19:35:52 1998
@@ -63,6 +63,8 @@ static char buffersize_index[65] =
 #define MAX_UNUSED_BUFFERS NR_RESERVED+20 /* don't ever have more than this 
 					     number of unused buffer heads */
 
+extern int regular_sync_scheduled;
+
 /*
  * Hash table mask..
  */
@@ -1944,7 +1946,7 @@ int bdflush(void * unused) 
 
 	current-&gt;session = 1;
 	current-&gt;pgrp = 1;
-	sprintf(current-&gt;comm, "kflushd");
+	sprintf(current-&gt;comm, "krflushd");
 	bdflush_tsk = current;
 
 	/*
@@ -1956,11 +1958,19 @@ int bdflush(void * unused) 
 		 
 	for (;;) {
 #ifdef DEBUG
-		printk("bdflush() activated...");
+		printk("bdflush() activated...\n");
 #endif
 
 		CHECK_EMERGENCY_SYNC
 
+	        if (regular_sync_scheduled) {
+#ifdef DEBUG
+			printk (KERN_DEBUG "kflushd: sync\n");
+#endif		   
+			regular_sync_scheduled = 0;
+			fsync_dev(0);		   
+		}
+	   
 		ncount = 0;
 #ifdef DEBUG
 		for(nlist = 0; nlist &lt; NR_LIST; nlist++)
--- linux-2.1.126/mm/vmscan.c.O	Wed Oct 28 17:09:51 1998
+++ linux-2.1.126/mm/vmscan.c	Wed Oct 28 19:26:50 1998
@@ -7,6 +7,7 @@
  *  kswapd added: 7.1.96  sct
  *  Removed kswapd_ctl limits, and swap out as many pages as needed
  *  to bring the system back to freepages.high: 2.4.97, Rik van Riel.
+ *  Added sync_interval, Ragnar Hojland Espinosa
  *  Version: $Id: vmscan.c,v 1.5 1998/02/23 22:14:28 sct Exp $
  */
 
@@ -40,6 +41,18 @@ static unsigned long next_swap_jiffies =
 int swapout_interval = HZ / 4;
 
 /* 
+ * How often do we sync?
+ * Default is every 30 seconds.
+ */
+int sync_interval = HZ * 30;
+
+/*
+ * Flag so bdflush knows when to sync
+ */
+int regular_sync_scheduled = 0;
+void wakeup_bdflush (int);
+
+/* 
  * The wait queue for waking up the pageout daemon:
  */
 struct wait_queue * kswapd_wait = NULL;
@@ -655,6 +668,13 @@ void swap_tick(void)
 			kswapd_wakeup();
 		}
 	}
+   
+       /* Sync */
+       if (now % sync_interval == 0) {
+		regular_sync_scheduled = 1;
+		wakeup_bdflush(0);
+	}
+   
 	timer_active |= (1&lt;&lt;SWAP_TIMER);
 }
 
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0022.html">Mike Galbraith: "Re: arca-1-against-pre-2.1.127-3"</a>
<li> <b>Previous message:</b> <a href="0020.html">Feuer: "Re: Signal problems"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
