<!-- received="Sun Nov  1 00:45:41 1998 EET" -->
<!-- sent="Sat, 31 Oct 1998 14:36:01 -0800" -->
<!-- name="John Reiser" -->
<!-- email="jreiser@teleport.com" -->
<!-- subject="[PATCH] include/asm-i386/elf.h, kernel 2.1.126" -->
<!-- id="19981031152242Z154804-18277+1505@vger.rutgers.edu" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] include/asm-i386/elf.h, kernel 2.1.126</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] include/asm-i386/elf.h, kernel 2.1.126</h1>
<b>John Reiser</b> (<a href="mailto:jreiser@teleport.com"><i>jreiser@teleport.com</i></a>)<br>
<i>Sat, 31 Oct 1998 14:36:01 -0800</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1">[ date ]</a><a href="index.html#1">[ thread ]</a><a href="subject.html#1">[ subject ]</a><a href="author.html#1">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0002.html">John Reiser: "[PATCH] include/asm-i386/elf.h, kernel 2.1.126"</a>
<li> <b>Previous message:</b> <a href="0000.html">Steven N. Hirsch: "knfs server hosed in 2.1.127-pre3"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0004.html">Chip Salzenberg: "Re: Random Register Contents"</a>
<li> <b>Reply:</b> <a href="0004.html">Chip Salzenberg: "Re: Random Register Contents"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a MIME encapsulated message.<br>
<p>
--===_363B913F_==<br>
Content-Type: text/plain; charset=US-ASCII<br>
Content-Transfer-Encoding: 7bit<br>
<p>
I'm working on a product where it is desirable for a process to have as<br>
much run-to-run repeatability as possible.  I've run into problems with<br>
exec() introducing needless randomness via the registers. Clearing the<br>
registers in _start (crt0.s) is eons too late.  I'm in favor of spending<br>
the bytes and cycles to remove the randomness where it originates.<br>
  <br>
ELF_PLAT_INIT is used in fs/binfmt_elf.c .<br>
<p>
<pre>
-- 
-----------------------------------------------------------
<a href="mailto:jreiser@teleport.com">jreiser@teleport.com</a> (John Reiser)
-----------------------------------------------------------
--===_363B913F_==
Content-Type: text/plain; name="MY_PATCH"
<p>
diff -u linux-2.1.126/include/asm-i386/elf.h linux/include/asm-i386/elf.h
--- linux-2.1.126/include/asm-i386/elf.h	Wed Jun 24 14:30:11 1998
+++ linux/include/asm-i386/elf.h	Sat Oct 31 05:52:59 1998
@@ -33,7 +33,10 @@
    shared libraries that have been loaded before the code runs.
 
    A value of 0 tells we have no such handler.  */
-#define ELF_PLAT_INIT(_r)	_r-&gt;edx = 0
+#define ELF_PLAT_INIT(_r)	_r-&gt;edi = _r-&gt;esi = _r-&gt;ebp = _r-&gt;ebx = _r-&gt;edx = _r-&gt;ecx = _r-&gt;eax = 0
+/* Clear all registers except %esp, to improve repeatability, debugability,
+   make life easier for conservative garbage collectors, and reduce
+   covert channels from one process to another. */
 
 #define USE_ELF_CORE_DUMP
 #define ELF_EXEC_PAGESIZE	4096
--===_363B913F_==
Content-Type: text/plain; charset=US-ASCII
Content-Transfer-Encoding: 7bit
<p>
<p>
<p>
--===_363B913F_==--
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0002.html">John Reiser: "[PATCH] include/asm-i386/elf.h, kernel 2.1.126"</a>
<li> <b>Previous message:</b> <a href="0000.html">Steven N. Hirsch: "knfs server hosed in 2.1.127-pre3"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0004.html">Chip Salzenberg: "Re: Random Register Contents"</a>
<li> <b>Reply:</b> <a href="0004.html">Chip Salzenberg: "Re: Random Register Contents"</a>
<!-- reply="end" -->
</ul>
</font></body>
