<!-- received="Sat Jun 27 13:01:57 1998 EET DST" -->
<!-- sent="Sat, 27 Jun 1998 05:55:36 -0400" -->
<!-- name="Myrdraal" -->
<!-- email="myrdraal@jackalz.dyn.ml.org" -->
<!-- subject="[PATCH]: Runtime sysrq toggle for 2.1.107,2.1.108pre1. (Patch included this time.)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-25,: [PATCH]: Runtime sysrq toggle for 2.1.107,2.1.108pre1. (Patch included this time.)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH]: Runtime sysrq toggle for 2.1.107,2.1.108pre1. (Patch included this time.)</h1>
<b>Myrdraal</b> (<a href="mailto:myrdraal@jackalz.dyn.ml.org"><i>myrdraal@jackalz.dyn.ml.org</i></a>)<br>
<i>Sat, 27 Jun 1998 05:55:36 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1879">[ date ]</a><a href="index.html#1879">[ thread ]</a><a href="subject.html#1879">[ subject ]</a><a href="author.html#1879">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1880.html">Peter T. Breuer: "Re: Weird spelling fixes in 2.1.107"</a>
<li> <b>Previous message:</b> <a href="1878.html">Myrdraal: "[PATCH]: Runtime sysrq toggle for 2.1.107,2.1.108pre1."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--FkmkrVfFsRoUs1wW<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
Hi,<br>
 My apologies, I forgot to include the actual patch. Duh.<br>
-Myrdraal<br>
<pre>
-- 
Linux jackalz 2.1.108 #77 Sat Jun 27 00:55:49 EDT 1998 i486
5:55am  up  4:24, 15 users,  load average: 0.69, 0.47, 0.37
<p>
--FkmkrVfFsRoUs1wW
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="sysrq_enable-2.1.107.diff"
<p>
diff -ur linpatch/Documentation/sysrq.txt linux/Documentation/sysrq.txt
--- linpatch/Documentation/sysrq.txt	Sat Jun 27 05:25:53 1998
+++ linux/Documentation/sysrq.txt	Sat Jun 27 05:35:43 1998
@@ -1,6 +1,6 @@
-                      MAGIC SYSRQ KEY DOCUMENTATION v1.2
+                      MAGIC SYSRQ KEY DOCUMENTATION v1.3
                      ------------------------------------
-                        [Sat May 16 01:09:21 EDT 1998]
+                        [Sat Jun 27 05:35:38 EDT 1998]
 
 *  What is the magic SysRQ key?
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
@@ -104,6 +104,24 @@
 '#define SYSRQ_KEY 0x54' in [/usr/src/linux/]include/asm/keyboard.h to
 the keycode of the key you wish to use, then recompile. Oh, and by the way,
 you exit 'showkey' by not typing anything for ten seconds.
+
+*  Is SysRQ a security hazard?
+~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
+Well, I just told you the things you can do with it - judge for yourself. :)
+It's likely that someone with access to the console of the machine could do
+evil things with mostly the same effect. (Why hit ALT-SysRQ-B when you can
+just slam the reset switch?) There are probably some circumstances where this
+is not true (a well protected public access machine, perhaps.), but I think
+for the majority of systems SysRQ is very useful.
+
+*  Can I toggle SysRQ without recompiling and rebooting?
+~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
+Yes, provided you compiled in support for the magic SysRQ key.
+echo "0" &gt;/proc/sys/debug/sysrq_enable
+The above will disable the magic SysRQ key.
+echo "1" &gt;/proc/sys/debug/sysrq_enable
+The above will enable the magic SysRQ key. The magic SysRQ key defaults to
+being on at boot.
 
 *  I have more questions, who can I ask?
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
diff -ur linpatch/drivers/char/sysrq.c linux/drivers/char/sysrq.c
--- linpatch/drivers/char/sysrq.c	Thu Jun 25 01:10:11 1998
+++ linux/drivers/char/sysrq.c	Thu Jun 25 06:50:43 1998
@@ -27,6 +27,8 @@
 #include &lt;linux/apm_bios.h&gt;
 #endif
 
+int sysctl_sysrq_enable = 1;
+
 extern void wakeup_bdflush(int);
 extern void reset_vc(unsigned int);
 extern int console_loglevel;
@@ -57,7 +59,7 @@
 {
 	int orig_log_level = console_loglevel;
 
-	if (!key)
+	if (!key || !sysctl_sysrq_enable)
 		return;
 
 	console_loglevel = 7;
diff -ur linpatch/include/linux/sysctl.h linux/include/linux/sysctl.h
--- linpatch/include/linux/sysctl.h	Thu Jun 25 01:09:30 1998
+++ linux/include/linux/sysctl.h	Thu Jun 25 06:50:43 1998
@@ -369,6 +369,9 @@
 };
 
 /* CTL_DEBUG names: */
+enum {
+	DEBUG_SYSRQ_ENABLE = 1,
+};
 
 /* CTL_DEV names: */
 enum {
diff -ur linpatch/kernel/sysctl.c linux/kernel/sysctl.c
--- linpatch/kernel/sysctl.c	Thu Jun 25 01:10:37 1998
+++ linux/kernel/sysctl.c	Thu Jun 25 06:50:43 1998
@@ -41,6 +41,9 @@
 extern int bdf_prm[], bdflush_min[], bdflush_max[];
 extern char binfmt_java_interpreter[], binfmt_java_appletviewer[];
 extern int sysctl_overcommit_memory;
+#ifdef CONFIG_MAGIC_SYSRQ
+extern int sysctl_sysrq_enable;
+#endif
 #ifdef CONFIG_KMOD
 extern char modprobe_path[];
 #endif
@@ -236,6 +239,10 @@
 };
 
 static ctl_table debug_table[] = {
+#ifdef CONFIG_MAGIC_SYSRQ
+	{DEBUG_SYSRQ_ENABLE, "sysrq_enable", &amp;sysctl_sysrq_enable, sizeof(int),
+		0644, NULL, &amp;proc_dointvec},
+#endif
 	{0}
 };
 
<p>
--FkmkrVfFsRoUs1wW--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1880.html">Peter T. Breuer: "Re: Weird spelling fixes in 2.1.107"</a>
<li> <b>Previous message:</b> <a href="1878.html">Myrdraal: "[PATCH]: Runtime sysrq toggle for 2.1.107,2.1.108pre1."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
