<!-- received="Sat Jun 27 00:08:52 1998 EET DST" -->
<!-- sent="26 Jun 1998 11:39:12 -0500" -->
<!-- name="James H. Cloos Jr." -->
<!-- email="cloos@jhcloos.com" -->
<!-- subject="Re: Secure-linux and standard kernel" -->
<!-- id="" -->
<!-- inreplyto="Fri, 26 Jun 1998 05:27:29 -0400 (EDT)" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: Secure-linux and standard kernel</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Secure-linux and standard kernel</h1>
<b>James H. Cloos Jr.</b> (<a href="mailto:cloos@jhcloos.com"><i>cloos@jhcloos.com</i></a>)<br>
<i>26 Jun 1998 11:39:12 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1749">[ date ]</a><a href="index.html#1749">[ thread ]</a><a href="subject.html#1749">[ subject ]</a><a href="author.html#1749">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1750.html">Linus Torvalds: "Re: Thread implementations..."</a>
<li> <b>Previous message:</b> <a href="1748.html">Manuel J. Galan: "spelling fixes breaking apps..."</a>
<li> <b>In reply to:</b> <a href="1662.html">Albert D. Cahalan: "Re: Secure-linux and standard kernel"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1752.html">Krzysztof G. Baranowski: "Re: Secure-linux and standard kernel"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt;&gt;&gt;&gt;&gt; "Albert" == Albert D Cahalan &lt;<a href="mailto:acahalan@cs.uml.edu">acahalan@cs.uml.edu</a>&gt; writes:</i><br>
<p>
Albert&gt; ELF-only is good enough for Linux 2.2. It is better than was<br>
Albert&gt; expected.  Perl scripts will have to wait for Linux 2.4, with<br>
Albert&gt; filesystem support.<br>
<p>
If suidperl is sufficiently trusted, all Perl scripts need to do is<br>
call capget(2) and capset(2) to drop the capabilities they do not<br>
need.  Eg:<br>
<p>
===========================================================================<br>
#!/usr/bin/perl<br>
<p>
sub BEGIN {<br>
  # The following block should be a require 'syscall.ph' but that will<br>
  # only work if the installed glibc and perl were built against a 2.1<br>
  # kernel, the following will work on any current distrib so long as a<br>
  # recent 2.1 kernel is running.<br>
  <br>
  eval 'sub __NR_capget () {184;}' unless defined(&amp;__NR_capget);<br>
  eval 'sub __NR_capset () {185;}' unless defined(&amp;__NR_capset);<br>
  unless(defined(&amp;SYS_capget)) {<br>
  sub SYS_capget () { &amp;__NR_capget;}<br>
  }<br>
  unless(defined(&amp;SYS_capset)) {<br>
  sub SYS_capset () { &amp;__NR_capset;}<br>
  }<br>
  <br>
  # You will need to run h2ph to make this if perl<br>
  # was compiled vs a 2.0 kernel tree...<br>
  require 'linux/capability.ph';<br>
  <br>
  $cap_header = pack("Li", 0x19980330, $$);<br>
  $cap_effective = pack("L", 0);<br>
  $cap_permtted = pack("L", 0);<br>
  $cap_inheritable = pack("L", 0);<br>
  $cap_data = pack("PPP", $cap_effective, $cap_permtted, $cap_inheritable);<br>
  <br>
  syscall(&amp;SYS_capget, $cap_header, $cap_data)<br>
     or die "Cannot get capabilities flags";<br>
  <br>
  ($cap_version, $cap_pid) = unpack("Li",$cap_header);<br>
  <br>
  ($cap_effective, $cap_permtted, $cap_inheritable) = unpack("PPP",$cap_data);<br>
  <br>
  $cap_effective = $cap_inheritable =<br>
     pack("L", (unpack("L",$cap_permtted) &amp; (1&lt;&lt;CAP_NET_BIND_SERVICE)))<br>
  <br>
  $cap_header = pack("Li", $cap_version, $cap_pid);<br>
  $cap_data = pack("PPP", $cap_effective, $cap_permtted, $cap_inheritable);<br>
  <br>
  syscall(&amp;SYS_capset, $cap_header, $cap_data)<br>
     or die "Cannot set capabilities flags";<br>
}<br>
<p>
# Now go on to do your server....<br>
===========================================================================<br>
<p>
The above is only minimally tested.  Ie, I've got a server that can<br>
bind, etc but cannot eg write to a file in /root/.  (I'm sure someone<br>
will correct any errors.  At the very least there should be checks on<br>
whether the $cap_permitted returned by capget(2) is NULL; if so I think<br>
it should be treated as though it were pack("L",~0).  I think.  But it<br>
is time to crash now, so don't take my word for it. :)<br>
<p>
Were all that it a module, one could have something like:<br>
<p>
	use Capabilities qw(CAP_NET_BIND_SERVICE CAP_SYS_TIME);<br>
<p>
as the fisrt line in a server to allow it to bind to low ports and to<br>
chnage the system time.  (eg, for a ntpd type server.)  In any case, a<br>
proper Capabilities.pm, invoked before anything else, will be as<br>
secure as suidperl(1) is.  Of course, you could also embed 'use<br>
capabilities' into the binary, a la 'use strict', 'use integer', etc.<br>
<p>
-JimC<br>
<pre>
-- 
James H. Cloos, Jr.
&lt;<a href="mailto:cloos@jhcloos.com">cloos@jhcloos.com</a>&gt;
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1750.html">Linus Torvalds: "Re: Thread implementations..."</a>
<li> <b>Previous message:</b> <a href="1748.html">Manuel J. Galan: "spelling fixes breaking apps..."</a>
<li> <b>In reply to:</b> <a href="1662.html">Albert D. Cahalan: "Re: Secure-linux and standard kernel"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1752.html">Krzysztof G. Baranowski: "Re: Secure-linux and standard kernel"</a>
<!-- reply="end" -->
</ul>
</font></body>
