<!-- received="Thu Jun 25 23:28:39 1998 EET DST" -->
<!-- sent="Thu, 25 Jun 1998 11:14:08 -0700 (PDT)" -->
<!-- name="H.J. Lu" -->
<!-- email="hjl@lucon.org" -->
<!-- subject="A gdb patch for linux 2.0.35" -->
<!-- id="m0ypGXA-000265C@ocean.lucon.org" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-25,: A gdb patch for linux 2.0.35</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>A gdb patch for linux 2.0.35</h1>
<b>H.J. Lu</b> (<a href="mailto:hjl@lucon.org"><i>hjl@lucon.org</i></a>)<br>
<i>Thu, 25 Jun 1998 11:14:08 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1468">[ date ]</a><a href="index.html#1468">[ thread ]</a><a href="subject.html#1468">[ subject ]</a><a href="author.html#1468">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1469.html">Ragnar Hojland Espinosa: "2.1.107 console/fb"</a>
<li> <b>Previous message:</b> <a href="1467.html">Zefram: "Re: Y2K"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
This is a gdb patch for Linux 2.0.33/2.0.34. With this patch and my gdb<br>
4.17.0.x, you can debug floating point numbers on Linux/x86.<br>
<p>
BTW, Rudolf, my previous patch missed one line. Hardware watchpoint<br>
doesn't work. This patch fixes it.<br>
<p>
<p>
<pre>
-- 
H.J. Lu (<a href="mailto:hjl@gnu.org">hjl@gnu.org</a>)
<pre>
-- 
--- ../linux-2.0.34/include/asm-i386/ptrace.h	Wed Sep 13 00:08:39 1995
+++ include/asm-i386/ptrace.h	Sat Jun 20 14:48:57 1998
@@ -43,6 +43,12 @@
 	unsigned short ss, __ssu;
 };
 
+/* Arbitrarily choose the same ptrace numbers as used by the Sparc code. */
+#define PTRACE_GETREGS            12
+#define PTRACE_SETREGS            13
+#define PTRACE_GETFPREGS          14
+#define PTRACE_SETFPREGS          15
+
 #ifdef __KERNEL__
 #define user_mode(regs) ((VM_MASK &amp; (regs)-&gt;eflags) || (3 &amp; (regs)-&gt;cs))
 #define instruction_pointer(regs) ((regs)-&gt;eip)
--- ../linux-2.0.34/arch/i386/kernel/ptrace.c	Thu Jun  4 20:14:23 1998
+++ arch/i386/kernel/ptrace.c	Tue Jun 23 17:43:25 1998
@@ -417,6 +417,55 @@
 	return tmp;
 }
 
+static int putreg(struct task_struct *child,
+	unsigned long regno, unsigned long value)
+{
+	switch (regno &gt;&gt; 2) {
+		case ORIG_EAX:
+			return -EIO;
+		case FS:
+		case GS:
+		case DS:
+		case ES:
+			if (value &amp;&amp; (value &amp; 3) != 3)
+				return -EIO;
+			value &amp;= 0xffff;
+			break;
+		case SS:
+		case CS:
+			if ((value &amp; 3) != 3)
+				return -EIO;
+			value &amp;= 0xffff;
+			break;
+		case EFL:
+			value &amp;= FLAG_MASK;
+			value |= get_stack_long(child, sizeof(long)*EFL-MAGICNUMBER) &amp; ~FLAG_MASK;
+	}
+	put_stack_long(child, regno - sizeof(struct pt_regs), value);
+	return 0;
+}
+
+static unsigned long getreg(struct task_struct *child,
+	unsigned long regno)
+{
+	unsigned long retval = ~0UL;
+
+	switch (regno &gt;&gt; 2) {
+		case FS:
+		case GS:
+		case DS:
+		case ES:
+		case SS:
+		case CS:
+			retval = 0xffff;
+			/* fall through */
+		default:
+			regno = regno - sizeof(struct pt_regs);
+			retval &amp;= get_stack_long(child, regno);
+	}
+	return retval;
+}
+
 asmlinkage int sys_ptrace(long request, long pid, long addr, long data)
 {
 	struct task_struct *child;
@@ -490,39 +539,23 @@
 			unsigned long tmp;
 			int res;
 			
-  			if ((addr &amp; 3 &amp;&amp; 
-  			     (addr &lt; (long) (&amp;dummy-&gt;i387) ||
-  			      addr &gt; (long) (&amp;dummy-&gt;i387.st_space[20]) )) ||
-  			    addr &lt; 0 || addr &gt; sizeof(struct user) - 3)
+  			if ((addr &amp; 3) || addr &lt; 0
+			    || addr &gt; sizeof(struct user) - 3)
 				return -EIO;
 			
 			res = verify_area(VERIFY_WRITE, (void *) data, sizeof(long));
 			if (res)
 				return res;
 			tmp = 0;  /* Default return condition */
-  			if (addr &gt;= (long) (&amp;dummy-&gt;i387) &amp;&amp;
-  			    addr &lt; (long) (&amp;dummy-&gt;i387.st_space[20]) ) {
-#ifndef CONFIG_MATH_EMULATION
-				if (!hard_math)
-					return -EIO;
-#endif /* defined(CONFIG_MATH_EMULATION) */
-				tmp = get_fpreg_word(child, addr);
-  			} 
-			if(addr &lt; 17*sizeof(long)) {
-			  addr = addr &gt;&gt; 2; /* temporary hack. */
-
-			  tmp = get_stack_long(child, sizeof(long)*addr - MAGICNUMBER);
-			  if (addr == DS || addr == ES ||
-			      addr == FS || addr == GS ||
-			      addr == CS || addr == SS)
-			    tmp &amp;= 0xffff;
-			};
-			if(addr &gt;= (long) &amp;dummy-&gt;u_debugreg[0] &amp;&amp;
-			   addr &lt;= (long) &amp;dummy-&gt;u_debugreg[7]){
+			if(addr &lt; 17*sizeof(long))
+				tmp = getreg(child, addr);
+			else if(addr &gt;= (long) &amp;dummy-&gt;u_debugreg[0]
+				&amp;&amp; addr &lt;= (long) &amp;dummy-&gt;u_debugreg[7])
+			{
 				addr -= (long) &amp;dummy-&gt;u_debugreg[0];
 				addr = addr &gt;&gt; 2;
 				tmp = child-&gt;debugreg[addr];
-			};
+			}
 			put_fs_long(tmp,(unsigned long *) data);
 			return 0;
 		}
@@ -533,50 +566,18 @@
 			return write_long(child,addr,data);
 
 		case PTRACE_POKEUSR: /* write the word at location addr in the USER area */
-			if ((addr &amp; 3 &amp;&amp;
-			     (addr &lt; (long) (&amp;dummy-&gt;i387.st_space[0]) ||
-			      addr &gt; (long) (&amp;dummy-&gt;i387.st_space[20]) )) ||
-			    addr &lt; 0 || 
-			    addr &gt; sizeof(struct user) - 3)
-				return -EIO;
-				
-			if (addr &gt;= (long) (&amp;dummy-&gt;i387.st_space[0]) &amp;&amp;
-			    addr &lt; (long) (&amp;dummy-&gt;i387.st_space[20]) ) {
-#ifndef CONFIG_MATH_EMULATION
-				if (!hard_math)
-					return -EIO;
-#endif /* defined(CONFIG_MATH_EMULATION) */
-				return put_fpreg_word(child, addr, data);
-			}
-			addr = addr &gt;&gt; 2; /* temporary hack. */
-			
-			if (addr == ORIG_EAX)
-				return -EIO;
-			if (addr == DS || addr == ES ||
-			    addr == FS || addr == GS ||
-			    addr == CS || addr == SS) {
-			    	data &amp;= 0xffff;
-			    	if (data &amp;&amp; (data &amp; 3) != 3)
-					return -EIO;
-			}
-			if (addr == EFL) {   /* flags. */
-				data &amp;= FLAG_MASK;
-				data |= get_stack_long(child, EFL*sizeof(long)-MAGICNUMBER)  &amp; ~FLAG_MASK;
-			}
-		  /* Do not allow the user to set the debug register for kernel
-		     address space */
-		  if(addr &lt; 17){
-			  if (put_stack_long(child, sizeof(long)*addr-MAGICNUMBER, data))
+  			if ((addr &amp; 3) || addr &lt; 0
+			    || addr &gt; sizeof(struct user) - 3)
 				return -EIO;
-			return 0;
-			};
+
+			if(addr &lt; 17*sizeof(long))
+				return putreg(child, addr, data);
 
 		  /* We need to be very careful here.  We implicitly
 		     want to modify a portion of the task_struct, and we
 		     have to be selective about what portions we allow someone
 		     to modify. */
 
-		  addr = addr &lt;&lt; 2;  /* Convert back again */
 		  if(addr &gt;= (long) &amp;dummy-&gt;u_debugreg[0] &amp;&amp;
 		     addr &lt;= (long) &amp;dummy-&gt;u_debugreg[7]){
 
@@ -665,6 +666,108 @@
 			put_stack_long(child, sizeof(long)*EFL-MAGICNUMBER,tmp);
 			return 0;
 		}
+
+		case PTRACE_GETREGS: { /* Get all gp regs from the child. */
+#ifdef CONFIG_MATH_EMULATION
+			if (!hard_math)
+				/* Not supported. */
+				return -EIO;
+#endif
+
+			if (verify_area(VERIFY_WRITE, (void *) data,
+					17*sizeof(long)))
+			  return -EIO;
+			for (i = 0; i &lt; 17*sizeof(long);
+			     i += sizeof(long), data += sizeof(long))
+			  put_fs_long (getreg(child, i), (unsigned long *) data);
+			return 0;
+		  };
+
+		case PTRACE_SETREGS: { /* Set all gp regs in the child. */
+			unsigned long tmp;
+
+#ifdef CONFIG_MATH_EMULATION
+			if (!hard_math)
+				/* Not supported. */
+				return -EIO;
+#endif
+
+			if (verify_area(VERIFY_READ, (void *) data,
+					17*sizeof(long)))
+			  return -EIO;
+			for (i = 0; i &lt; 17*sizeof(long);
+			     i += sizeof(long), data += sizeof(long))
+			  {
+			    tmp = get_fs_long ((unsigned long *) data);
+			    putreg(child, i, tmp);
+			  }
+			return 0;
+		  };
+
+		case PTRACE_GETFPREGS: { /* Get the child FPU state. */
+			unsigned long *tmp;
+
+#ifdef CONFIG_MATH_EMULATION
+			if (!hard_math)
+				/* Not supported. */
+				return -EIO;
+#endif
+
+			if (verify_area(VERIFY_WRITE, (void *) data,
+					sizeof(struct user_i387_struct)))
+			  return -EIO;
+			if ( !child-&gt;used_math ) {
+			  /* Simulate an empty FPU. */
+			  child-&gt;tss.i387.hard.cwd = 0xffff037f;
+			  child-&gt;tss.i387.hard.swd = 0xffff0000;
+			  child-&gt;tss.i387.hard.twd = 0xffffffff;
+			}
+			if (last_task_used_math == child)
+			  {
+			    clts();
+			    __asm__("fnsave %0; fwait":"=m" (child-&gt;tss.i387.hard));
+			    last_task_used_math = NULL;
+			    stts();
+			  }
+			tmp = (unsigned long *) &amp;child-&gt;tss.i387.hard;
+			for ( i = 0; i &lt; sizeof(struct user_i387_struct); i += sizeof(long) )
+			  {
+			    put_fs_long (*tmp, (unsigned long *) data);
+			    data += sizeof(long);
+			    tmp++;
+			  }
+
+			return 0;
+		  };
+
+		case PTRACE_SETFPREGS: { /* Set the child FPU state. */
+			unsigned long *tmp;
+
+#ifdef CONFIG_MATH_EMULATION
+			if (!hard_math)
+				/* Not supported. */
+				return -EIO;
+#endif
+
+			if (verify_area(VERIFY_READ, (void *) data,
+					sizeof(struct user_i387_struct)))
+			  return -EIO;
+			child-&gt;used_math = 1;
+			if (last_task_used_math == child)
+			  {
+			    /* Discard the state of the FPU */
+			    last_task_used_math = NULL;
+			  }
+			tmp = (unsigned long *) &amp;child-&gt;tss.i387.hard;
+			for ( i = 0; i &lt; sizeof(struct user_i387_struct); i += sizeof(long) )
+			  {
+			    *tmp = get_fs_long ((unsigned long *) data);
+			    data += sizeof(long);
+			    tmp++;
+			  }
+			child-&gt;flags &amp;= ~PF_USEDFPU;
+			return 0;
+		  };
 
 		default:
 			return -EIO;
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1469.html">Ragnar Hojland Espinosa: "2.1.107 console/fb"</a>
<li> <b>Previous message:</b> <a href="1467.html">Zefram: "Re: Y2K"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
