<!-- received="Thu Jun 25 09:22:57 1998 EET DST" -->
<!-- sent="Thu, 25 Jun 1998 02:14:22 -0400" -->
<!-- name="Myrdraal" -->
<!-- email="myrdraal@jackalz.dyn.ml.org" -->
<!-- subject="[PATCH]: Runtime enable/disable magic sysrq against 2.1.107pre1." -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-25,: [PATCH]: Runtime enable/disable magic sysrq against 2.1.107pre1.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH]: Runtime enable/disable magic sysrq against 2.1.107pre1.</h1>
<b>Myrdraal</b> (<a href="mailto:myrdraal@jackalz.dyn.ml.org"><i>myrdraal@jackalz.dyn.ml.org</i></a>)<br>
<i>Thu, 25 Jun 1998 02:14:22 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1317">[ date ]</a><a href="index.html#1317">[ thread ]</a><a href="subject.html#1317">[ subject ]</a><a href="author.html#1317">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1318.html">Vojtech Pavlik: "Re: uniform input device packets?"</a>
<li> <b>Previous message:</b> <a href="1316.html">Rogier Wolff: "Re: Sendmail 8.9.0 claims a Linux kernel bug"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1438.html">Adam Sulmicki: "Re: [PATCH]: Runtime enable/disable magic sysrq against 2.1.107pre1."</a>
<li> <b>Reply:</b> <a href="1438.html">Adam Sulmicki: "Re: [PATCH]: Runtime enable/disable magic sysrq against 2.1.107pre1."</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--h31gzZEtNLTqOjlF<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
Hi,<br>
 For all those who said that having magic sysrq enabled on a system was<br>
 a security hole:<br>
 This patch will add /proc/sys/debug/sysrq_enable. If you:<br>
 echo "0"&gt;/proc/sys/debug/sysrq_enable<br>
 then sysrq won't work. If you:<br>
 echo "1"&gt;/proc/sys/debug/sysrq_enable<br>
 then sysrq will work. "1" is the default setting. Comments? This is<br>
 my very first kernel hack, so be gentle :)<br>
-Myrdraal<br>
<pre>
-- 
Linux jackalz 2.1.107 #72 Thu Jun 25 01:15:22 EDT 1998 i486
2:11am  up 38 min, 15 users,  load average: 0.01, 0.01, 0.00
<p>
--h31gzZEtNLTqOjlF
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="sysrq_enable-2.1.106.diff"
<p>
diff -ur linpatch/drivers/char/sysrq.c linux/drivers/char/sysrq.c
--- linpatch/drivers/char/sysrq.c	Thu Jun 25 01:10:11 1998
+++ linux/drivers/char/sysrq.c	Thu Jun 25 00:58:35 1998
@@ -27,6 +27,8 @@
 #include &lt;linux/apm_bios.h&gt;
 #endif
 
+int sysctl_sysrq_enable = 1;
+
 extern void wakeup_bdflush(int);
 extern void reset_vc(unsigned int);
 extern int console_loglevel;
@@ -57,7 +59,7 @@
 {
 	int orig_log_level = console_loglevel;
 
-	if (!key)
+	if (!key || !sysctl_sysrq_enable)
 		return;
 
 	console_loglevel = 7;
diff -ur linpatch/include/linux/sysctl.h linux/include/linux/sysctl.h
--- linpatch/include/linux/sysctl.h	Thu Jun 25 01:09:30 1998
+++ linux/include/linux/sysctl.h	Thu Jun 25 01:03:07 1998
@@ -369,6 +369,9 @@
 };
 
 /* CTL_DEBUG names: */
+enum {
+	DEBUG_SYSRQ_ENABLE = 1,
+};
 
 /* CTL_DEV names: */
 enum {
diff -ur linpatch/kernel/sysctl.c linux/kernel/sysctl.c
--- linpatch/kernel/sysctl.c	Thu Jun 25 01:10:37 1998
+++ linux/kernel/sysctl.c	Thu Jun 25 01:29:02 1998
@@ -41,6 +41,9 @@
 extern int bdf_prm[], bdflush_min[], bdflush_max[];
 extern char binfmt_java_interpreter[], binfmt_java_appletviewer[];
 extern int sysctl_overcommit_memory;
+#ifdef CONFIG_MAGIC_SYSRQ
+extern int sysctl_sysrq_enable;
+#endif
 #ifdef CONFIG_KMOD
 extern char modprobe_path[];
 #endif
@@ -236,6 +239,10 @@
 };
 
 static ctl_table debug_table[] = {
+#ifdef CONFIG_MAGIC_SYSRQ
+	{DEBUG_SYSRQ_ENABLE, "sysrq_enable", &amp;sysctl_sysrq_enable, sizeof(int),
+		0644, NULL, &amp;proc_dointvec},
+#endif
 	{0}
 };
 
<p>
--h31gzZEtNLTqOjlF--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1318.html">Vojtech Pavlik: "Re: uniform input device packets?"</a>
<li> <b>Previous message:</b> <a href="1316.html">Rogier Wolff: "Re: Sendmail 8.9.0 claims a Linux kernel bug"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1438.html">Adam Sulmicki: "Re: [PATCH]: Runtime enable/disable magic sysrq against 2.1.107pre1."</a>
<li> <b>Reply:</b> <a href="1438.html">Adam Sulmicki: "Re: [PATCH]: Runtime enable/disable magic sysrq against 2.1.107pre1."</a>
<!-- reply="end" -->
</ul>
</font></body>
