<!-- received="Thu Jun 25 08:53:52 1998 EET DST" -->
<!-- sent="Thu, 25 Jun 1998 01:46:15 -0400 (EDT)" -->
<!-- name="Mathieu Bouchard" -->
<!-- email="boum01@UQAH.UQuebec.CA" -->
<!-- subject="Re: keyboard raw mode?" -->
<!-- id="Pine.SOL.3.91.980625013053.5685F-100000@io" -->
<!-- inreplyto="19980623162708.46367@twilight.ucw.cz" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: keyboard raw mode?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: keyboard raw mode?</h1>
<b>Mathieu Bouchard</b> (<a href="mailto:boum01@UQAH.UQuebec.CA"><i>boum01@UQAH.UQuebec.CA</i></a>)<br>
<i>Thu, 25 Jun 1998 01:46:15 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1312">[ date ]</a><a href="index.html#1312">[ thread ]</a><a href="subject.html#1312">[ subject ]</a><a href="author.html#1312">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1313.html">Michael O'Reilly: "Re: Scheduler fixes"</a>
<li> <b>Previous message:</b> <a href="1311.html">Alex Buell: "v2.1.106 oddities revisited."</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1322.html">Vojtech Pavlik: "Re: keyboard raw mode?"</a>
<li> <b>Reply:</b> <a href="1322.html">Vojtech Pavlik: "Re: keyboard raw mode?"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt; Now this sounds very interesting to me. I'd like to add a device like this,</i><br>
<i>&gt; which would output raw keystrokes/releases, with timestamps &amp; stuff,</i><br>
<i>&gt; like my current joystick driver does. It could even share most of the</i><br>
<i>&gt; routines with the joystick driver.</i><br>
<p>
i would rather integrate it to the kernel; actually, the code already <br>
does exist in its most part, it's just the we lack the /dev/keyboard to <br>
peep the scancodes passed from one part of the kernel to another.<br>
<p>
<i>&gt; &gt; all other things i've done are palette reconfiguration scripts, clumsy</i><br>
<i>&gt; &gt; patches to the joystick.o driver (to enable the two extra buttons when the</i><br>
<i>&gt; &gt; two extra pots don't exist), and a joystick-to-mouse converter that sucks. </i><br>
<i>&gt; As a joystick driver maintainer, I'm interested in any joystick hacks for</i><br>
<i>&gt; Linux that have been done ... including these. The 4-button one is probably</i><br>
<i>&gt; obsoleted by the 1.0+ drivers, but the joystick-to-mouse thingy sounds</i><br>
<i>&gt; interesting. Would it be possible for me to take a look at it? There already</i><br>
<i>&gt; is a nice joy2key utility by Peter Amstutz, so a joy2mouse utility would</i><br>
<i>&gt; fit nicely into the collection.</i><br>
<p>
not exactly knowing what i was doing, i wrote this:<br>
<p>
#include &lt;linux/joystick.h&gt;<br>
#include &lt;fcntl.h&gt;<br>
#include &lt;unistd.h&gt;<br>
<p>
int main (int argc, char **argv) {<br>
  int v, fd, mouse, status, nx, ny; char buf[5];<br>
  struct JS_DATA_TYPE js;<br>
<p>
  fd = open ("/dev/js0", O_RDONLY);<br>
  if (fd &lt; 0) { perror ("js"); exit (1); }<br>
  mouse = open("/dev/joymouse", O_RDWR|O_NONBLOCK);<br>
  if (mouse &lt; 0) { perror ("joymouse"); exit (2); }<br>
<p>
  status = read (fd, &amp;js, JS_RETURN); nx = js.x/2; ny = js.y/2;<br>
<p>
  while (1) {<br>
    status = read (fd, &amp;js, JS_RETURN);<br>
    v = 1 + (js.buttons&amp;0x04)/2;<br>
    buf[0]= (<br>
          ((js.buttons&amp;0x08)&gt;&gt;3)<br>
<i>        |  (js.buttons&amp;0x02)</i><br>
<i>        | ((js.buttons&amp;0x01)&lt;&lt;2)</i><br>
    )^0x07 | 0x80;<br>
    buf[3]=buf[1]= ( (js.x &gt; nx*3) ? +v : (js.x &lt; nx) ? -v : 0 )&amp;0xff;<br>
    buf[4]=buf[2]= ( (js.y &gt; ny*3) ? -v : (js.y &lt; ny) ? +v : 0 )&amp;0xff;<br>
    write(mouse,buf,5);<br>
    usleep(5000);<br>
  }<br>
  return 0;<br>
}<br>
<p>
i'm not sure whether i'd recommend using this, though.<br>
btw, here are the instructions:<br>
<p>
using a gravis gamepad, red button is left button, blue button is middle <br>
button, green button is right button, and yellow button makes the pad <br>
move the pointer twice as fast.<br>
<p>
matju<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1313.html">Michael O'Reilly: "Re: Scheduler fixes"</a>
<li> <b>Previous message:</b> <a href="1311.html">Alex Buell: "v2.1.106 oddities revisited."</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1322.html">Vojtech Pavlik: "Re: keyboard raw mode?"</a>
<li> <b>Reply:</b> <a href="1322.html">Vojtech Pavlik: "Re: keyboard raw mode?"</a>
<!-- reply="end" -->
</ul>
</font></body>
