<!-- received="Wed Jun 24 16:03:17 1998 EET DST" -->
<!-- sent="Wed, 24 Jun 1998 14:01:09 +0200" -->
<!-- name="Pavel Machek" -->
<!-- email="pavel@bug.ucw.cz" -->
<!-- subject="Scheduler fixes" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-25,: Scheduler fixes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Scheduler fixes</h1>
<b>Pavel Machek</b> (<a href="mailto:pavel@bug.ucw.cz"><i>pavel@bug.ucw.cz</i></a>)<br>
<i>Wed, 24 Jun 1998 14:01:09 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1170">[ date ]</a><a href="index.html#1170">[ thread ]</a><a href="subject.html#1170">[ subject ]</a><a href="author.html#1170">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1171.html">Pavel Machek: "Re: bogomips in 2.0.34"</a>
<li> <b>Previous message:</b> <a href="1169.html">Pavel Machek: "sleep after sync? how to flush all caches?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
Linux tries to measure times spend in<br>
processes... Somehow. Unfortunately, it is optimistic: it will show<br>
less than real values under some pretty common<br>
circumstances. (Application sleeping for short times and doing small<br>
ammount of processing is marked as eating 0% of system time. There are<br>
some applications which do this - for example ksame, qweb (and I think<br>
that everything using qt) - which do evil busy waiting.)<br>
<p>
This patch changes it: now, kernel is pesimistic. It just finds<br>
someone to accound him spend time. This way, busy waiting applications<br>
get accounted, so they can be identified. I think this is good, or at<br>
least it is much better than current state.<br>
<p>
It also includes small fixes to sched.c. This is for experimentation<br>
and comments, not for inclusion. [Well, small fixes maybe should be<br>
included...]<br>
<p>
								Pavel<br>
<p>
PS: Comments welcome, testers welcome. <br>
<p>
PPS: I know that 'need_update_times' name for variable is misleading,<br>
does anyone have something better?<br>
<p>
--- clean/kernel/sched.c	Tue Jun 23 23:10:49 1998<br>
+++ linux/kernel/sched.c	Wed Jun 24 00:56:32 1998<br>
@@ -82,6 +82,8 @@<br>
 long time_adjust_step = 0;<br>
 <br>
 int need_resched = 0;<br>
+int need_update_times = 0;<br>
+int need_update_times_system = 0;<br>
 unsigned long event = 0;<br>
 <br>
 extern int do_setitimer(int, struct itimerval *, struct itimerval *);<br>
@@ -495,10 +494,14 @@<br>
 	next-&gt;processor = this_cpu;<br>
 #endif<br>
 <br>
+<br>
+	if (need_update_times)<br>
+		update_process_times( next, need_update_times, need_update_times_system );<br>
+<br>
 	if (prev != next) {<br>
 		struct timer_list timer;<br>
 <br>
 		kstat.context_swtch++;<br>
 		if (timeout) {<br>
 			init_timer(&amp;timer);<br>
 			timer.expires = timeout;<br>
@@ -767,10 +774,7 @@<br>
 struct timer_struct timer_table[32];<br>
 <br>
 /*<br>
- * Hmm.. Changed this, as the GNU make sources (load.c) seems to<br>
- * imply that avenrun[] is the standard name for this kind of thing.<br>
- * Nothing else seems to be standardized: the fractional size etc<br>
- * all seem to differ on different machines.<br>
+ * This is famous 'load average'<br>
  */<br>
 unsigned long avenrun[3] = { 0,0,0 };<br>
 <br>
@@ -1046,14 +1050,15 @@<br>
 	do_it_prof(p, ticks);<br>
 }	<br>
 <br>
-static void update_process_times(unsigned long ticks, unsigned long system)<br>
+static void update_process_times(struct task_struct *p, unsigned long ticks, unsigned long system)<br>
 {<br>
 /*<br>
  * SMP does this on a per-CPU basis elsewhere<br>
  */<br>
 #ifndef  __SMP__<br>
-	struct task_struct * p = current;<br>
 	unsigned long user = ticks - system;<br>
+	need_update_times = need_update_times_system = 0;<br>
+<br>
 	if (p-&gt;pid) {<br>
 		p-&gt;counter -= ticks;<br>
 		if (p-&gt;counter &lt; 0) {<br>
@@ -1091,8 +1096,8 @@<br>
 		calc_load(ticks);<br>
 		update_wall_time(ticks);<br>
 		restore_flags(flags);<br>
-		<br>
-		update_process_times(ticks, system);<br>
+<br>
+//		update_process_times(current, ticks, system);<br>
 <br>
 	} else<br>
 		restore_flags(flags);<br>
@@ -1100,6 +1105,8 @@<br>
 <br>
 static void timer_bh(void)<br>
 {<br>
+	if (need_update_times&gt;1)<br>
+		update_process_times( current, need_update_times, need_update_times_system );<br>
 	update_times();<br>
 	run_old_timers();<br>
 	run_timer_list();<br>
@@ -1107,11 +1114,14 @@<br>
 <br>
 void do_timer(struct pt_regs * regs)<br>
 {<br>
-	(*(unsigned long *)&amp;jiffies)++;<br>
+	(*(unsigned long * volatile)&amp;jiffies)++;<br>
 	lost_ticks++;<br>
 	mark_bh(TIMER_BH);<br>
-	if (!user_mode(regs))<br>
+	need_update_times++;<br>
+	if (!user_mode(regs)) {<br>
 		lost_ticks_system++;<br>
+		need_update_times_system++;<br>
+	}<br>
 	if (tq_timer)<br>
 		mark_bh(TQUEUE_BH);<br>
 }<br>
@@ -1532,7 +1545,7 @@<br>
 		printk(stat_nam[p-&gt;state]);<br>
 	else<br>
 		printk(" ");<br>
-#if ((~0UL) == 0xffffffff)<br>
+#if (BITS_PER_LONG == 32)<br>
 	if (p == current)<br>
 		printk(" current  ");<br>
 	else<br>
@@ -1595,7 +1608,7 @@<br>
 {<br>
 	struct task_struct *p;<br>
 <br>
-#if ((~0UL) == 0xffffffff)<br>
+#if (BITS_PER_LONG == 32)<br>
 	printk("\n"<br>
 	       "                         free                        sibling\n");<br>
 	printk("  task             PC    stack   pid father child younger older\n");<br>
<p>
<pre>
-- 
I'm really <a href="mailto:pavel@atrey.karlin.mff.cuni.cz">pavel@atrey.karlin.mff.cuni.cz</a>. 	   Pavel
Look at <a href="http://atrey.karlin.mff.cuni.cz/~pavel/">http://atrey.karlin.mff.cuni.cz/~pavel/</a> ;-).
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1171.html">Pavel Machek: "Re: bogomips in 2.0.34"</a>
<li> <b>Previous message:</b> <a href="1169.html">Pavel Machek: "sleep after sync? how to flush all caches?"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
