<!-- received="Tue Jun 23 21:14:17 1998 EET DST" -->
<!-- sent="Tue, 23 Jun 1998 22:06:04 +0400" -->
<!-- name="Savochkin Andrey Vladimirovich" -->
<!-- email="saw@msu.ru" -->
<!-- subject="Re: Major 2.1.x problem index" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.96.980620002249.8166A-100000@mirkwood.dummy.home" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: Major 2.1.x problem index</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Major 2.1.x problem index</h1>
<b>Savochkin Andrey Vladimirovich</b> (<a href="mailto:saw@msu.ru"><i>saw@msu.ru</i></a>)<br>
<i>Tue, 23 Jun 1998 22:06:04 +0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1024">[ date ]</a><a href="index.html#1024">[ thread ]</a><a href="subject.html#1024">[ subject ]</a><a href="author.html#1024">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1025.html">Alex Buell: "v2.1.106 and binutils-2.9.1.0.6 oddity (built with egcs 1.0.3a)"</a>
<li> <b>Previous message:</b> <a href="1023.html">Gabriel Paubert: "Re: Y2K"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--ikeVEW9yuYc//A+q<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
<i>&gt; On Fri, 19 Jun 1998, Alan Cox wrote:</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; <a href="http://roadrunner.swansea.uk.linux.org/jobs.shtml">http://roadrunner.swansea.uk.linux.org/jobs.shtml</a> holds the major showstopper </i><br>
<i>&gt; &gt; items for a 2.2 release, and a few other bugs indexed on a web page.</i><br>
<p>
I've written a piece of code to solve mlock problem.<br>
I'm certainly not a mm guru so the code may be wrong.<br>
Do people agree with the implemented approach to fix the problem?<br>
<p>
Best wishes<br>
					Andrey V.<br>
					Savochkin<br>
<p>
--ikeVEW9yuYc//A+q<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename="mlock.1"<br>
<p>
--- linux.orig/mm/mlock.c	Wed Jun 17 14:57:33 1998<br>
+++ linux/mm/mlock.c	Sun Jun 21 20:00:32 1998<br>
@@ -126,26 +126,7 @@<br>
 		if (!(newflags &amp; VM_LOCKED))<br>
 			pages = -pages;<br>
 		vma-&gt;vm_mm-&gt;locked_vm += pages;<br>
-<br>
-#if 0<br>
-/*<br>
- * This is horribly broken. See the comment on the same<br>
- * brokenness in mm/mmap.c (essentially, this doesn't<br>
- * work anyway for PROT_NONE and writable pages, and now<br>
- * that we properly get the mmap semaphore it would just<br>
- * lock up on us).<br>
- *<br>
- * Fix the same way.<br>
- */<br>
-		if (newflags &amp; VM_LOCKED) {<br>
-			while (start &lt; end) {<br>
-				int c;<br>
-				get_user(c,(int *) start);<br>
-				__asm__ __volatile__("": :"r" (c));<br>
-				start += PAGE_SIZE;<br>
-			}<br>
-		}<br>
-#endif<br>
+		make_pages_present(start, end);<br>
 	}<br>
 	return retval;<br>
 }<br>
--- linux.orig/mm/memory.c	Wed Jun 17 14:57:33 1998<br>
+++ linux/mm/memory.c	Tue Jun 23 19:06:55 1998<br>
@@ -918,6 +918,72 @@<br>
 	oom(tsk);<br>
 }<br>
 <br>
+/*<br>
+ * mm semaphore and global kernel lock should be held,<br>
+ * pages should belong to the same vma.<br>
+ */<br>
+void make_pages_present(unsigned long addr, unsigned long end)<br>
+{<br>
+	struct vm_area_struct * vma;<br>
+	pgd_t *pgd;<br>
+	pmd_t *pmd;<br>
+	pte_t *pte;<br>
+	pte_t origentry;<br>
+	int writable, needfix;<br>
+<br>
+	vma = find_vma(current-&gt;mm, addr);<br>
+	pgd = pgd_offset(current-&gt;mm, addr);<br>
+<br>
+	while (1) {<br>
+		pmd = pmd_alloc(pgd, addr);<br>
+		if (!pmd)<br>
+			goto no_memory;<br>
+		pte = pte_alloc(pmd, addr);<br>
+		if (!pte)<br>
+			goto no_memory;<br>
+<br>
+		writable = vma-&gt;vm_flags &amp; VM_MAYWRITE;<br>
+		needfix = writable;<br>
+		flush_cache_page(vma, addr);<br>
+		origentry = *pte;<br>
+		if (pte_none(origentry) || !pte_present(origentry))<br>
+			do_no_page(current, vma, addr, writable, pte,<br>
+				   origentry);<br>
+		else if (writable &amp;&amp; !pte_write(origentry))<br>
+			do_wp_page(current, vma, addr, writable, pte);<br>
+		else<br>
+			needfix = 0;<br>
+<br>
+		/* do_xxx_page() can make the page writtable when it<br>
+		 * isn't. Now we fix the protection. The page can't<br>
+		 * be accessed before the fix because:<br>
+		 * 1) the code hasn't blocked<br>
+		 * 2) global kernel lock is held<br>
+		 * 3) user space pages can't be accessed from<br>
+		 *    interrupts.<br>
+		 */<br>
+		if (needfix) {<br>
+			pte_t entry;<br>
+			flush_cache_page(vma, addr);<br>
+			entry = pte_modify(*pte, vma-&gt;vm_page_prot);<br>
+			if (vma-&gt;vm_flags &amp; VM_WRITE)<br>
+				entry = pte_mkwrite(entry);<br>
+			if (!pte_dirty(origentry))<br>
+				entry = pte_mkclean(entry);<br>
+			set_pte(pte, entry);<br>
+			flush_tlb_page(vma, addr);<br>
+		}<br>
+		update_mmu_cache(vma, addr, *pte);<br>
+<br>
+		addr += PAGE_SIZE;<br>
+		if (addr &gt;= end)<br>
+			break;<br>
+	}<br>
+	return;<br>
+no_memory:<br>
+	oom(current);<br>
+}<br>
+<br>
 /* Low and high watermarks for page table cache.<br>
    The system should try to have pgt_water[0] &lt;= cache elements &lt;= pgt_water[1]<br>
  */<br>
--- linux.orig/include/linux/mm.h	Wed Jun 17 14:49:08 1998<br>
+++ linux/include/linux/mm.h	Sun Jun 21 20:27:45 1998<br>
@@ -292,6 +292,7 @@<br>
 extern void vmtruncate(struct inode * inode, unsigned long offset);<br>
 extern void handle_mm_fault(struct task_struct *tsk,struct vm_area_struct *vma, unsigned long address, int write_access);<br>
 extern void check_pgt_cache(void);<br>
+extern void make_pages_present(unsigned long addr, unsigned long end);<br>
 <br>
 extern unsigned long paging_init(unsigned long start_mem, unsigned long end_mem);<br>
 extern void mem_init(unsigned long start_mem, unsigned long end_mem);<br>
<p>
--ikeVEW9yuYc//A+q<br>
Content-Type: application/x-gunzip<br>
Content-Transfer-Encoding: base64<br>
Content-Disposition: attachment; filename="memlock-test.c.gz"<br>
<p>
H4sICATqjzUCA21lbWxvY2suYwCtVm1v2jAQ/s6vuKVal9B0TQKaNmg3IZVtlVhb0W79sFXI<br>
TRzqNdjIcbq37r/v7CRAIOmLNFCQfS/PPXfn+NhiPEyyiMJ+qiImXl6/bW0tRBlnKK3K4pCr<br>
pCpKf6V7sxnhm1JJU5HJkGpNi/GEcQq3gkWQCBLZZtUmUSSd1p8W4IekM9QnRLGEgm1Z0MOv<br>
JS2w23Z4TSS0HWPu9Ft/q4BKZOF1DaLxCvv5Gg6ggtNvCmod6Jiho5eeWTm5bcUd4cJVIong<br>
0/xHRioNDZuSx1KX1EY1HnnoAQZMyoCSqkxy7YRxliAhSdiVJIo2BFG+CyrAp5PDKB/J5qwK<br>
4LlIEvv482jkgueC73leoVDBuqnqrEsKVmi6q6F3ilXHsDRNmBHGbcYVEDkN3bwN7TZubkuy<br>
WhlHOd6yb1+7l/2FmvUb08Knm2tTJbNQgcxSMqWQpWiSpUG/ZZRxhNTFnHLbIoRYLpxMxocX<br>
4yINFoONFvvgOfAH5lRKIW1Lm1tOH+hPpmwfF39zLEPPu0RAPOzzonav/TfI53R8cj4ZDweH<br>
d2Z1MT46H7rwaXA6Ofs4GA8PXSSCdV4JuwA7MGbvB0ej4eEqCx3DW6NROs/mUigaqhLFha73<br>
5tUKDUfj7vqIZ3xMv0vc0lcKpzFL/4lZno6Pvgz0pjZN/4E0/UYewRN5DI5Pju8qhLwaPsF/<br>
KXtQLTtGHj6m7Fxw2lz4zv0JP+JMdR5ILqiLbbzxRcVXIYC7O/3S3mLbigP6InnhLBKKhQSb<br>
IUuvDwztU/abitjEdvZWNuiL+GxnZ+m6qGMiwpvciGERbbbtO+90KXs63ZoibhRTAzTlcW+X<br>
1k7No96TH7XtygdOEQPFe21gCu/lLKVAYI53UUyyRMEVzWUlHvyQTNHdYkdxcl1TY/4M2ns5<br>
clcPlsUFXzR4SlV+xdnjz2eDD8PJ2XD03oVtvPCcpjveTNlFM9Zpe5c7ujKbCr/GOKiVrQIs<br>
g3UunzBKmvMKykklcRbEtnXOZoxPe/B8FAGO5KJATPBejgiK3NBUq3GeQUpDwSNgRuB845a7<br>
aPHG2NIDRS/0ZOmuRT3VU8W0Mu3hVPsOzxPERyZ6UYFFxi9lNkGbGPu+q0fRcr9pxnjVzOyd<br>
Ym6Z0+aZvzn/AFM7yuqiCQAA<br>
<p>
--ikeVEW9yuYc//A+q--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1025.html">Alex Buell: "v2.1.106 and binutils-2.9.1.0.6 oddity (built with egcs 1.0.3a)"</a>
<li> <b>Previous message:</b> <a href="1023.html">Gabriel Paubert: "Re: Y2K"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
