<!-- received="Mon Jun 22 07:58:43 1998 EET DST" -->
<!-- sent="Mon, 22 Jun 1998 00:53:41 -0400 (EDT)" -->
<!-- name="George" -->
<!-- email="greerga@nidhogg.ham.muohio.edu" -->
<!-- subject="Re: Fix (sort of) for OOM swap deadlock." -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.96.980622002417.14546B-100000@nidhogg.ham.muohio.edu" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: Fix (sort of) for OOM swap deadlock.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Fix (sort of) for OOM swap deadlock.</h1>
<b>George</b> (<a href="mailto:greerga@nidhogg.ham.muohio.edu"><i>greerga@nidhogg.ham.muohio.edu</i></a>)<br>
<i>Mon, 22 Jun 1998 00:53:41 -0400 (EDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#498">[ date ]</a><a href="index.html#498">[ thread ]</a><a href="subject.html#498">[ subject ]</a><a href="author.html#498">[ author ]</a>
<!-- next="start" -->
<li> <b>Previous message:</b> <a href="0497.html">199806212123.WAA12500@loki.wkstn.nix: "199806212123.WAA12500@loki.wkstn.nix"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Mon, 22 Jun 1998, George wrote:<br>
<p>
<i>&gt;@@ -564,6 +586,13 @@ int kswapd(void *unused)</i><br>
<i>&gt; 		 * woken up more often and the rate will be even</i><br>
<i>&gt; 		 * higher).</i><br>
<i>&gt; 		 */</i><br>
<i>&gt;+		if (out_of_swap()) {</i><br>
<i>&gt;+#ifdef DEBUG</i><br>
<i>&gt;+			printk("kswapd: No swap left, not paging.\n");</i><br>
<i>&gt;+#endif</i><br>
<i>&gt;+			continue;</i><br>
<i>&gt;+		}</i><br>
<p>
There's always the obvious method that just slips by... :)<br>
<p>
I haven't tested this one, but it compiles.  It should work so long as<br>
show_mem() is accurate, and my previous one doing the same concept worked<br>
ok. <br>
<p>
--- 2.1.106/linux/mm/vmscan.c	Mon Jun 22 00:01:49 1998<br>
+++ linux/mm/vmscan.c	Mon Jun 22 00:44:47 1998<br>
@@ -564,6 +564,13 @@ int kswapd(void *unused)<br>
 		 * woken up more often and the rate will be even<br>
 		 * higher).<br>
 		 */<br>
+		if (nr_swap_pages == 0) {<br>
+#ifdef DEBUG<br>
+			printk("kswapd: No swap left, not paging.\n");<br>
+#endif<br>
+			continue;<br>
+		}<br>
+<br>
 		tries = pager_daemon.tries_base &gt;&gt; free_memory_available(3);<br>
 	<br>
 		while (tries--) {<br>
<p>
-George<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Previous message:</b> <a href="0497.html">199806212123.WAA12500@loki.wkstn.nix: "199806212123.WAA12500@loki.wkstn.nix"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
