<!-- received="Sun Jun 21 17:29:49 1998 EET DST" -->
<!-- sent="Sun, 21 Jun 1998 16:22:50 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="arcangeli@mbox.queen.it" -->
<!-- subject="Re: fork() memory corruption... is this glibc2 or kernel?" -->
<!-- id="" -->
<!-- inreplyto="Pine.GSO.3.96.980621081431.29299A-100000@valerie.inf.elte.hu" -->
<title>Linux-kernel mailing list archive 1998-25,: Re: fork() memory corruption... is this glibc2 or kernel?</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: fork() memory corruption... is this glibc2 or kernel?</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:arcangeli@mbox.queen.it"><i>arcangeli@mbox.queen.it</i></a>)<br>
<i>Sun, 21 Jun 1998 16:22:50 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#269">[ date ]</a><a href="index.html#269">[ thread ]</a><a href="subject.html#269">[ subject ]</a><a href="author.html#269">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0270.html">Bryn Paul Arnold Jones: "Re: kernel 2.0.34 msdos support."</a>
<li> <b>Previous message:</b> <a href="0268.html">fork() memory corruption... is this glibc2 or kernel?: "fork() memory corruption... is this glibc2 or kernel?"</a>
<li> <b>In reply to:</b> <a href="0193.html">Pine.GSO.3.96.980621081431.29299A-100000@valerie.inf.elte.hu: "Pine.GSO.3.96.980621081431.29299A-100000@valerie.inf.elte.hu"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sun, 21 Jun 1998, MOLNAR Ingo wrote:<br>
<p>
<i>&gt;i think the bug is a bit more complex. The actual 'corruption' is</i><br>
<i>&gt;reproducible no matter what the standard output is.</i><br>
<p>
Applying this patch to the file simple.c:<br>
<p>
--- ../fork_debug/simple.c	Sat Jun 20 23:16:38 1998<br>
+++ simple.c	Sun Jun 21 16:08:54 1998<br>
@@ -4,6 +4,7 @@<br>
  */<br>
 <br>
 #include &lt;sys/types.h&gt;<br>
+#include &lt;sys/wait.h&gt;<br>
 #include &lt;stdio.h&gt;<br>
 #include &lt;unistd.h&gt;<br>
 #include &lt;string.h&gt;<br>
@@ -50,9 +51,13 @@<br>
 			{<br>
 				case 0:	if(strcmp(webpage, "---BEGIN DATA---")==0)<br>
 					{<br>
+						int status;<br>
 						pw_returnvalue++;<br>
 						D2print(0, "Begin data\n");<br>
+#if 1<br>
 						if((err_r=fork())&lt;1)die(err_r); /* MEMORY CORRUPTION detected here - depends on number of things... */<br>
+						wait(&amp;status);<br>
+#endif<br>
 						continue;<br>
 					}<br>
 					break;<br>
@@ -66,7 +71,11 @@<br>
 						D2print(0, "End of data\n");<br>
 						continue;<br>
 					} else {<br>
+						int status;<br>
+#if 0<br>
 						if((err_r=fork())&lt;1)die(err_r); /* the corruption will appear more likely here if not in the first one... */<br>
+						wait(&amp;status);<br>
+#endif<br>
 						D2print(0, "[%s]\n", webpage);<br>
 					}<br>
 					break;<br>
<p>
<p>
7066  write(1, "Begin data\n", 11)      = 11<br>
      ^^^^^ this write is not on the screen here<br>
7066  fork()                            = 7067<br>
7066  wait4(-1,  &lt;unfinished ...&gt;<br>
7067  lseek(6, -2838, SEEK_CUR)         = 1258<br>
7067  munmap(0x400b4000, 4096)          = 0<br>
7067  munmap(0x400b5000, 4096)          = 0<br>
      ^^^^^^ the write is on the screen the fist time somewhere here<br>
7067  _exit(0)                          = ?<br>
7066  &lt;... wait4 resumed&gt; [WIFEXITED(s) &amp;&amp; WEXITSTATUS(s) == 0], 0, NULL)<br>
= 7067<br>
7066  --- SIGCHLD (Child exited) ---<br>
      ^^^^^^^ the write got duplicated somewhere here too<br>
7066  write(1, "[00 ValidDataValidDataValidDataV"..., 87) = 87<br>
<p>
show that the parent do a write() and _then_ libc must assume the data is<br>
just on stdout, but really the data is not yet there and only when the<br>
child exit() after the fork() the write happen on the screen, and this<br>
cause duplication of the string since also the parent process will write<br>
the same data then...<br>
<p>
I don' t think this should happen, I think that the string should be<br>
printed only at once.<br>
<p>
Andrea[s] Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0270.html">Bryn Paul Arnold Jones: "Re: kernel 2.0.34 msdos support."</a>
<li> <b>Previous message:</b> <a href="0268.html">fork() memory corruption... is this glibc2 or kernel?: "fork() memory corruption... is this glibc2 or kernel?"</a>
<li> <b>In reply to:</b> <a href="0193.html">Pine.GSO.3.96.980621081431.29299A-100000@valerie.inf.elte.hu: "Pine.GSO.3.96.980621081431.29299A-100000@valerie.inf.elte.hu"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
